// auto-generated by sbt-boilerplate
/*
 * Copyright 2016 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.regex
package laws
package discipline

import java.util.regex.Pattern
import kantan.codecs.laws._
import org.scalacheck.Arbitrary

trait ArbitraryArities extends kantan.codecs.laws.discipline.ArbitraryInstances {
  def toMatch(p: Pattern, is: String*): Match = {
    val matcher = p.matcher(is.mkString(" "))
    matcher.find()
    new Match(matcher)
  }

  val pattern1 = Pattern.compile("([^ ]*)")

  def arbLegalCaseClass1[I1, O](f: (I1) => O)(implicit al1: Arbitrary[LegalString[I1]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith1(f)((i1: String) => toMatch(pattern1, i1)))
  }

  def arbIllegalCaseClass1[I1, O](implicit ai1: Arbitrary[IllegalString[I1]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith1[String, I1, Match, O, codecs.type]((i1: String) => toMatch(pattern1, i1)))
  }

  implicit def arbLegalTuple1[I1](implicit al1: Arbitrary[LegalString[I1]]): Arbitrary[LegalMatch[Tuple1[I1]]] =
    arbLegalCaseClass1(Tuple1.apply[I1])

  implicit def arbIllegalTuple1[I1](implicit ai1: Arbitrary[IllegalString[I1]]): Arbitrary[IllegalMatch[Tuple1[I1]]] =
    arbIllegalCaseClass1[I1, Tuple1[I1]]

  val pattern2 = Pattern.compile("([^ ]*) ([^ ]*)")

  def arbLegalCaseClass2[I1, I2, O](f: (I1, I2) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith2(f)((i1: String, i2: String) => toMatch(pattern2, i1, i2)))
  }

  def arbIllegalCaseClass2[I1, I2, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith2[String, String, I1, I2, Match, O, codecs.type]((i1: String, i2: String) => toMatch(pattern2, i1, i2)))
  }

  implicit def arbLegalTuple2[I1, I2](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]]): Arbitrary[LegalMatch[Tuple2[I1, I2]]] =
    arbLegalCaseClass2(Tuple2.apply[I1, I2])

  implicit def arbIllegalTuple2[I1, I2](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]]): Arbitrary[IllegalMatch[Tuple2[I1, I2]]] =
    arbIllegalCaseClass2[I1, I2, Tuple2[I1, I2]]

  val pattern3 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass3[I1, I2, I3, O](f: (I1, I2, I3) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith3(f)((i1: String, i2: String, i3: String) => toMatch(pattern3, i1, i2, i3)))
  }

  def arbIllegalCaseClass3[I1, I2, I3, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith3[String, String, String, I1, I2, I3, Match, O, codecs.type]((i1: String, i2: String, i3: String) => toMatch(pattern3, i1, i2, i3)))
  }

  implicit def arbLegalTuple3[I1, I2, I3](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]]): Arbitrary[LegalMatch[Tuple3[I1, I2, I3]]] =
    arbLegalCaseClass3(Tuple3.apply[I1, I2, I3])

  implicit def arbIllegalTuple3[I1, I2, I3](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]]): Arbitrary[IllegalMatch[Tuple3[I1, I2, I3]]] =
    arbIllegalCaseClass3[I1, I2, I3, Tuple3[I1, I2, I3]]

  val pattern4 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass4[I1, I2, I3, I4, O](f: (I1, I2, I3, I4) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith4(f)((i1: String, i2: String, i3: String, i4: String) => toMatch(pattern4, i1, i2, i3, i4)))
  }

  def arbIllegalCaseClass4[I1, I2, I3, I4, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith4[String, String, String, String, I1, I2, I3, I4, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String) => toMatch(pattern4, i1, i2, i3, i4)))
  }

  implicit def arbLegalTuple4[I1, I2, I3, I4](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]]): Arbitrary[LegalMatch[Tuple4[I1, I2, I3, I4]]] =
    arbLegalCaseClass4(Tuple4.apply[I1, I2, I3, I4])

  implicit def arbIllegalTuple4[I1, I2, I3, I4](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]]): Arbitrary[IllegalMatch[Tuple4[I1, I2, I3, I4]]] =
    arbIllegalCaseClass4[I1, I2, I3, I4, Tuple4[I1, I2, I3, I4]]

  val pattern5 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass5[I1, I2, I3, I4, I5, O](f: (I1, I2, I3, I4, I5) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith5(f)((i1: String, i2: String, i3: String, i4: String, i5: String) => toMatch(pattern5, i1, i2, i3, i4, i5)))
  }

  def arbIllegalCaseClass5[I1, I2, I3, I4, I5, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith5[String, String, String, String, String, I1, I2, I3, I4, I5, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String) => toMatch(pattern5, i1, i2, i3, i4, i5)))
  }

  implicit def arbLegalTuple5[I1, I2, I3, I4, I5](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]]): Arbitrary[LegalMatch[Tuple5[I1, I2, I3, I4, I5]]] =
    arbLegalCaseClass5(Tuple5.apply[I1, I2, I3, I4, I5])

  implicit def arbIllegalTuple5[I1, I2, I3, I4, I5](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]]): Arbitrary[IllegalMatch[Tuple5[I1, I2, I3, I4, I5]]] =
    arbIllegalCaseClass5[I1, I2, I3, I4, I5, Tuple5[I1, I2, I3, I4, I5]]

  val pattern6 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass6[I1, I2, I3, I4, I5, I6, O](f: (I1, I2, I3, I4, I5, I6) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith6(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String) => toMatch(pattern6, i1, i2, i3, i4, i5, i6)))
  }

  def arbIllegalCaseClass6[I1, I2, I3, I4, I5, I6, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith6[String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String) => toMatch(pattern6, i1, i2, i3, i4, i5, i6)))
  }

  implicit def arbLegalTuple6[I1, I2, I3, I4, I5, I6](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]]): Arbitrary[LegalMatch[Tuple6[I1, I2, I3, I4, I5, I6]]] =
    arbLegalCaseClass6(Tuple6.apply[I1, I2, I3, I4, I5, I6])

  implicit def arbIllegalTuple6[I1, I2, I3, I4, I5, I6](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]]): Arbitrary[IllegalMatch[Tuple6[I1, I2, I3, I4, I5, I6]]] =
    arbIllegalCaseClass6[I1, I2, I3, I4, I5, I6, Tuple6[I1, I2, I3, I4, I5, I6]]

  val pattern7 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass7[I1, I2, I3, I4, I5, I6, I7, O](f: (I1, I2, I3, I4, I5, I6, I7) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith7(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String) => toMatch(pattern7, i1, i2, i3, i4, i5, i6, i7)))
  }

  def arbIllegalCaseClass7[I1, I2, I3, I4, I5, I6, I7, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith7[String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String) => toMatch(pattern7, i1, i2, i3, i4, i5, i6, i7)))
  }

  implicit def arbLegalTuple7[I1, I2, I3, I4, I5, I6, I7](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]]): Arbitrary[LegalMatch[Tuple7[I1, I2, I3, I4, I5, I6, I7]]] =
    arbLegalCaseClass7(Tuple7.apply[I1, I2, I3, I4, I5, I6, I7])

  implicit def arbIllegalTuple7[I1, I2, I3, I4, I5, I6, I7](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]]): Arbitrary[IllegalMatch[Tuple7[I1, I2, I3, I4, I5, I6, I7]]] =
    arbIllegalCaseClass7[I1, I2, I3, I4, I5, I6, I7, Tuple7[I1, I2, I3, I4, I5, I6, I7]]

  val pattern8 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass8[I1, I2, I3, I4, I5, I6, I7, I8, O](f: (I1, I2, I3, I4, I5, I6, I7, I8) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith8(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String) => toMatch(pattern8, i1, i2, i3, i4, i5, i6, i7, i8)))
  }

  def arbIllegalCaseClass8[I1, I2, I3, I4, I5, I6, I7, I8, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith8[String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String) => toMatch(pattern8, i1, i2, i3, i4, i5, i6, i7, i8)))
  }

  implicit def arbLegalTuple8[I1, I2, I3, I4, I5, I6, I7, I8](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]]): Arbitrary[LegalMatch[Tuple8[I1, I2, I3, I4, I5, I6, I7, I8]]] =
    arbLegalCaseClass8(Tuple8.apply[I1, I2, I3, I4, I5, I6, I7, I8])

  implicit def arbIllegalTuple8[I1, I2, I3, I4, I5, I6, I7, I8](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]]): Arbitrary[IllegalMatch[Tuple8[I1, I2, I3, I4, I5, I6, I7, I8]]] =
    arbIllegalCaseClass8[I1, I2, I3, I4, I5, I6, I7, I8, Tuple8[I1, I2, I3, I4, I5, I6, I7, I8]]

  val pattern9 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass9[I1, I2, I3, I4, I5, I6, I7, I8, I9, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith9(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String) => toMatch(pattern9, i1, i2, i3, i4, i5, i6, i7, i8, i9)))
  }

  def arbIllegalCaseClass9[I1, I2, I3, I4, I5, I6, I7, I8, I9, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith9[String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String) => toMatch(pattern9, i1, i2, i3, i4, i5, i6, i7, i8, i9)))
  }

  implicit def arbLegalTuple9[I1, I2, I3, I4, I5, I6, I7, I8, I9](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]]): Arbitrary[LegalMatch[Tuple9[I1, I2, I3, I4, I5, I6, I7, I8, I9]]] =
    arbLegalCaseClass9(Tuple9.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9])

  implicit def arbIllegalTuple9[I1, I2, I3, I4, I5, I6, I7, I8, I9](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]]): Arbitrary[IllegalMatch[Tuple9[I1, I2, I3, I4, I5, I6, I7, I8, I9]]] =
    arbIllegalCaseClass9[I1, I2, I3, I4, I5, I6, I7, I8, I9, Tuple9[I1, I2, I3, I4, I5, I6, I7, I8, I9]]

  val pattern10 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith10(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String) => toMatch(pattern10, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)))
  }

  def arbIllegalCaseClass10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith10[String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String) => toMatch(pattern10, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)))
  }

  implicit def arbLegalTuple10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]]): Arbitrary[LegalMatch[Tuple10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10]]] =
    arbLegalCaseClass10(Tuple10.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10])

  implicit def arbIllegalTuple10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]]): Arbitrary[IllegalMatch[Tuple10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10]]] =
    arbIllegalCaseClass10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, Tuple10[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10]]

  val pattern11 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith11(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String) => toMatch(pattern11, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)))
  }

  def arbIllegalCaseClass11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith11[String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String) => toMatch(pattern11, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)))
  }

  implicit def arbLegalTuple11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]]): Arbitrary[LegalMatch[Tuple11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11]]] =
    arbLegalCaseClass11(Tuple11.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11])

  implicit def arbIllegalTuple11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]]): Arbitrary[IllegalMatch[Tuple11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11]]] =
    arbIllegalCaseClass11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, Tuple11[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11]]

  val pattern12 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith12(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String) => toMatch(pattern12, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)))
  }

  def arbIllegalCaseClass12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith12[String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String) => toMatch(pattern12, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)))
  }

  implicit def arbLegalTuple12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]]): Arbitrary[LegalMatch[Tuple12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12]]] =
    arbLegalCaseClass12(Tuple12.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12])

  implicit def arbIllegalTuple12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]]): Arbitrary[IllegalMatch[Tuple12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12]]] =
    arbIllegalCaseClass12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, Tuple12[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12]]

  val pattern13 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith13(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String) => toMatch(pattern13, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)))
  }

  def arbIllegalCaseClass13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith13[String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String) => toMatch(pattern13, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)))
  }

  implicit def arbLegalTuple13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]]): Arbitrary[LegalMatch[Tuple13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13]]] =
    arbLegalCaseClass13(Tuple13.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13])

  implicit def arbIllegalTuple13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]]): Arbitrary[IllegalMatch[Tuple13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13]]] =
    arbIllegalCaseClass13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, Tuple13[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13]]

  val pattern14 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith14(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String) => toMatch(pattern14, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)))
  }

  def arbIllegalCaseClass14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith14[String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String) => toMatch(pattern14, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)))
  }

  implicit def arbLegalTuple14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]]): Arbitrary[LegalMatch[Tuple14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14]]] =
    arbLegalCaseClass14(Tuple14.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14])

  implicit def arbIllegalTuple14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]]): Arbitrary[IllegalMatch[Tuple14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14]]] =
    arbIllegalCaseClass14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, Tuple14[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14]]

  val pattern15 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith15(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String) => toMatch(pattern15, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)))
  }

  def arbIllegalCaseClass15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith15[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String) => toMatch(pattern15, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)))
  }

  implicit def arbLegalTuple15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]]): Arbitrary[LegalMatch[Tuple15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15]]] =
    arbLegalCaseClass15(Tuple15.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15])

  implicit def arbIllegalTuple15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]]): Arbitrary[IllegalMatch[Tuple15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15]]] =
    arbIllegalCaseClass15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, Tuple15[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15]]

  val pattern16 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith16(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String) => toMatch(pattern16, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)))
  }

  def arbIllegalCaseClass16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith16[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String) => toMatch(pattern16, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)))
  }

  implicit def arbLegalTuple16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]]): Arbitrary[LegalMatch[Tuple16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16]]] =
    arbLegalCaseClass16(Tuple16.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16])

  implicit def arbIllegalTuple16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]]): Arbitrary[IllegalMatch[Tuple16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16]]] =
    arbIllegalCaseClass16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, Tuple16[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16]]

  val pattern17 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith17(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String) => toMatch(pattern17, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)))
  }

  def arbIllegalCaseClass17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith17[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String) => toMatch(pattern17, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)))
  }

  implicit def arbLegalTuple17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]]): Arbitrary[LegalMatch[Tuple17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17]]] =
    arbLegalCaseClass17(Tuple17.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17])

  implicit def arbIllegalTuple17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]]): Arbitrary[IllegalMatch[Tuple17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17]]] =
    arbIllegalCaseClass17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, Tuple17[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17]]

  val pattern18 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.LegalValue[String, I18, codecs.type]] = Arbitrary(al18.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith18(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String) => toMatch(pattern18, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)))
  }

  def arbIllegalCaseClass18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.IllegalValue[String, I18, codecs.type]] = Arbitrary(ai18.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith18[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String) => toMatch(pattern18, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)))
  }

  implicit def arbLegalTuple18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]]): Arbitrary[LegalMatch[Tuple18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18]]] =
    arbLegalCaseClass18(Tuple18.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18])

  implicit def arbIllegalTuple18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]]): Arbitrary[IllegalMatch[Tuple18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18]]] =
    arbIllegalCaseClass18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, Tuple18[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18]]

  val pattern19 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.LegalValue[String, I18, codecs.type]] = Arbitrary(al18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.LegalValue[String, I19, codecs.type]] = Arbitrary(al19.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith19(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String) => toMatch(pattern19, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)))
  }

  def arbIllegalCaseClass19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.IllegalValue[String, I18, codecs.type]] = Arbitrary(ai18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.IllegalValue[String, I19, codecs.type]] = Arbitrary(ai19.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith19[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String) => toMatch(pattern19, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)))
  }

  implicit def arbLegalTuple19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]]): Arbitrary[LegalMatch[Tuple19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19]]] =
    arbLegalCaseClass19(Tuple19.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19])

  implicit def arbIllegalTuple19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]]): Arbitrary[IllegalMatch[Tuple19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19]]] =
    arbIllegalCaseClass19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, Tuple19[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19]]

  val pattern20 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.LegalValue[String, I18, codecs.type]] = Arbitrary(al18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.LegalValue[String, I19, codecs.type]] = Arbitrary(al19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.LegalValue[String, I20, codecs.type]] = Arbitrary(al20.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith20(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String) => toMatch(pattern20, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)))
  }

  def arbIllegalCaseClass20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.IllegalValue[String, I18, codecs.type]] = Arbitrary(ai18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.IllegalValue[String, I19, codecs.type]] = Arbitrary(ai19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.IllegalValue[String, I20, codecs.type]] = Arbitrary(ai20.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith20[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String) => toMatch(pattern20, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)))
  }

  implicit def arbLegalTuple20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]]): Arbitrary[LegalMatch[Tuple20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20]]] =
    arbLegalCaseClass20(Tuple20.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20])

  implicit def arbIllegalTuple20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]]): Arbitrary[IllegalMatch[Tuple20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20]]] =
    arbIllegalCaseClass20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, Tuple20[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20]]

  val pattern21 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]], al21: Arbitrary[LegalString[I21]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.LegalValue[String, I18, codecs.type]] = Arbitrary(al18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.LegalValue[String, I19, codecs.type]] = Arbitrary(al19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.LegalValue[String, I20, codecs.type]] = Arbitrary(al20.arbitrary.map(_.tag[codecs.type]))
    implicit val arb21: Arbitrary[CodecValue.LegalValue[String, I21, codecs.type]] = Arbitrary(al21.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith21(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String, i21: String) => toMatch(pattern21, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)))
  }

  def arbIllegalCaseClass21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]], ai21: Arbitrary[IllegalString[I21]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.IllegalValue[String, I18, codecs.type]] = Arbitrary(ai18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.IllegalValue[String, I19, codecs.type]] = Arbitrary(ai19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.IllegalValue[String, I20, codecs.type]] = Arbitrary(ai20.arbitrary.map(_.tag[codecs.type]))
    implicit val arb21: Arbitrary[CodecValue.IllegalValue[String, I21, codecs.type]] = Arbitrary(ai21.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith21[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String, i21: String) => toMatch(pattern21, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)))
  }

  implicit def arbLegalTuple21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]], al21: Arbitrary[LegalString[I21]]): Arbitrary[LegalMatch[Tuple21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21]]] =
    arbLegalCaseClass21(Tuple21.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21])

  implicit def arbIllegalTuple21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]], ai21: Arbitrary[IllegalString[I21]]): Arbitrary[IllegalMatch[Tuple21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21]]] =
    arbIllegalCaseClass21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, Tuple21[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21]]

  val pattern22 = Pattern.compile("([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*)")

  def arbLegalCaseClass22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22, O](f: (I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22) => O)(implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]], al21: Arbitrary[LegalString[I21]], al22: Arbitrary[LegalString[I22]]): Arbitrary[LegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.LegalValue[String, I1, codecs.type]] = Arbitrary(al1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.LegalValue[String, I2, codecs.type]] = Arbitrary(al2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.LegalValue[String, I3, codecs.type]] = Arbitrary(al3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.LegalValue[String, I4, codecs.type]] = Arbitrary(al4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.LegalValue[String, I5, codecs.type]] = Arbitrary(al5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.LegalValue[String, I6, codecs.type]] = Arbitrary(al6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.LegalValue[String, I7, codecs.type]] = Arbitrary(al7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.LegalValue[String, I8, codecs.type]] = Arbitrary(al8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.LegalValue[String, I9, codecs.type]] = Arbitrary(al9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.LegalValue[String, I10, codecs.type]] = Arbitrary(al10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.LegalValue[String, I11, codecs.type]] = Arbitrary(al11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.LegalValue[String, I12, codecs.type]] = Arbitrary(al12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.LegalValue[String, I13, codecs.type]] = Arbitrary(al13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.LegalValue[String, I14, codecs.type]] = Arbitrary(al14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.LegalValue[String, I15, codecs.type]] = Arbitrary(al15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.LegalValue[String, I16, codecs.type]] = Arbitrary(al16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.LegalValue[String, I17, codecs.type]] = Arbitrary(al17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.LegalValue[String, I18, codecs.type]] = Arbitrary(al18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.LegalValue[String, I19, codecs.type]] = Arbitrary(al19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.LegalValue[String, I20, codecs.type]] = Arbitrary(al20.arbitrary.map(_.tag[codecs.type]))
    implicit val arb21: Arbitrary[CodecValue.LegalValue[String, I21, codecs.type]] = Arbitrary(al21.arbitrary.map(_.tag[codecs.type]))
    implicit val arb22: Arbitrary[CodecValue.LegalValue[String, I22, codecs.type]] = Arbitrary(al22.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genLegalWith22(f)((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String, i21: String, i22: String) => toMatch(pattern22, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)))
  }

  def arbIllegalCaseClass22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22, O](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]], ai21: Arbitrary[IllegalString[I21]], ai22: Arbitrary[IllegalString[I22]]): Arbitrary[IllegalMatch[O]] = {
    implicit val arb1: Arbitrary[CodecValue.IllegalValue[String, I1, codecs.type]] = Arbitrary(ai1.arbitrary.map(_.tag[codecs.type]))
    implicit val arb2: Arbitrary[CodecValue.IllegalValue[String, I2, codecs.type]] = Arbitrary(ai2.arbitrary.map(_.tag[codecs.type]))
    implicit val arb3: Arbitrary[CodecValue.IllegalValue[String, I3, codecs.type]] = Arbitrary(ai3.arbitrary.map(_.tag[codecs.type]))
    implicit val arb4: Arbitrary[CodecValue.IllegalValue[String, I4, codecs.type]] = Arbitrary(ai4.arbitrary.map(_.tag[codecs.type]))
    implicit val arb5: Arbitrary[CodecValue.IllegalValue[String, I5, codecs.type]] = Arbitrary(ai5.arbitrary.map(_.tag[codecs.type]))
    implicit val arb6: Arbitrary[CodecValue.IllegalValue[String, I6, codecs.type]] = Arbitrary(ai6.arbitrary.map(_.tag[codecs.type]))
    implicit val arb7: Arbitrary[CodecValue.IllegalValue[String, I7, codecs.type]] = Arbitrary(ai7.arbitrary.map(_.tag[codecs.type]))
    implicit val arb8: Arbitrary[CodecValue.IllegalValue[String, I8, codecs.type]] = Arbitrary(ai8.arbitrary.map(_.tag[codecs.type]))
    implicit val arb9: Arbitrary[CodecValue.IllegalValue[String, I9, codecs.type]] = Arbitrary(ai9.arbitrary.map(_.tag[codecs.type]))
    implicit val arb10: Arbitrary[CodecValue.IllegalValue[String, I10, codecs.type]] = Arbitrary(ai10.arbitrary.map(_.tag[codecs.type]))
    implicit val arb11: Arbitrary[CodecValue.IllegalValue[String, I11, codecs.type]] = Arbitrary(ai11.arbitrary.map(_.tag[codecs.type]))
    implicit val arb12: Arbitrary[CodecValue.IllegalValue[String, I12, codecs.type]] = Arbitrary(ai12.arbitrary.map(_.tag[codecs.type]))
    implicit val arb13: Arbitrary[CodecValue.IllegalValue[String, I13, codecs.type]] = Arbitrary(ai13.arbitrary.map(_.tag[codecs.type]))
    implicit val arb14: Arbitrary[CodecValue.IllegalValue[String, I14, codecs.type]] = Arbitrary(ai14.arbitrary.map(_.tag[codecs.type]))
    implicit val arb15: Arbitrary[CodecValue.IllegalValue[String, I15, codecs.type]] = Arbitrary(ai15.arbitrary.map(_.tag[codecs.type]))
    implicit val arb16: Arbitrary[CodecValue.IllegalValue[String, I16, codecs.type]] = Arbitrary(ai16.arbitrary.map(_.tag[codecs.type]))
    implicit val arb17: Arbitrary[CodecValue.IllegalValue[String, I17, codecs.type]] = Arbitrary(ai17.arbitrary.map(_.tag[codecs.type]))
    implicit val arb18: Arbitrary[CodecValue.IllegalValue[String, I18, codecs.type]] = Arbitrary(ai18.arbitrary.map(_.tag[codecs.type]))
    implicit val arb19: Arbitrary[CodecValue.IllegalValue[String, I19, codecs.type]] = Arbitrary(ai19.arbitrary.map(_.tag[codecs.type]))
    implicit val arb20: Arbitrary[CodecValue.IllegalValue[String, I20, codecs.type]] = Arbitrary(ai20.arbitrary.map(_.tag[codecs.type]))
    implicit val arb21: Arbitrary[CodecValue.IllegalValue[String, I21, codecs.type]] = Arbitrary(ai21.arbitrary.map(_.tag[codecs.type]))
    implicit val arb22: Arbitrary[CodecValue.IllegalValue[String, I22, codecs.type]] = Arbitrary(ai22.arbitrary.map(_.tag[codecs.type]))
    Arbitrary(genIllegalWith22[String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22, Match, O, codecs.type]((i1: String, i2: String, i3: String, i4: String, i5: String, i6: String, i7: String, i8: String, i9: String, i10: String, i11: String, i12: String, i13: String, i14: String, i15: String, i16: String, i17: String, i18: String, i19: String, i20: String, i21: String, i22: String) => toMatch(pattern22, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)))
  }

  implicit def arbLegalTuple22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22](implicit al1: Arbitrary[LegalString[I1]], al2: Arbitrary[LegalString[I2]], al3: Arbitrary[LegalString[I3]], al4: Arbitrary[LegalString[I4]], al5: Arbitrary[LegalString[I5]], al6: Arbitrary[LegalString[I6]], al7: Arbitrary[LegalString[I7]], al8: Arbitrary[LegalString[I8]], al9: Arbitrary[LegalString[I9]], al10: Arbitrary[LegalString[I10]], al11: Arbitrary[LegalString[I11]], al12: Arbitrary[LegalString[I12]], al13: Arbitrary[LegalString[I13]], al14: Arbitrary[LegalString[I14]], al15: Arbitrary[LegalString[I15]], al16: Arbitrary[LegalString[I16]], al17: Arbitrary[LegalString[I17]], al18: Arbitrary[LegalString[I18]], al19: Arbitrary[LegalString[I19]], al20: Arbitrary[LegalString[I20]], al21: Arbitrary[LegalString[I21]], al22: Arbitrary[LegalString[I22]]): Arbitrary[LegalMatch[Tuple22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22]]] =
    arbLegalCaseClass22(Tuple22.apply[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22])

  implicit def arbIllegalTuple22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22](implicit ai1: Arbitrary[IllegalString[I1]], ai2: Arbitrary[IllegalString[I2]], ai3: Arbitrary[IllegalString[I3]], ai4: Arbitrary[IllegalString[I4]], ai5: Arbitrary[IllegalString[I5]], ai6: Arbitrary[IllegalString[I6]], ai7: Arbitrary[IllegalString[I7]], ai8: Arbitrary[IllegalString[I8]], ai9: Arbitrary[IllegalString[I9]], ai10: Arbitrary[IllegalString[I10]], ai11: Arbitrary[IllegalString[I11]], ai12: Arbitrary[IllegalString[I12]], ai13: Arbitrary[IllegalString[I13]], ai14: Arbitrary[IllegalString[I14]], ai15: Arbitrary[IllegalString[I15]], ai16: Arbitrary[IllegalString[I16]], ai17: Arbitrary[IllegalString[I17]], ai18: Arbitrary[IllegalString[I18]], ai19: Arbitrary[IllegalString[I19]], ai20: Arbitrary[IllegalString[I20]], ai21: Arbitrary[IllegalString[I21]], ai22: Arbitrary[IllegalString[I22]]): Arbitrary[IllegalMatch[Tuple22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22]]] =
    arbIllegalCaseClass22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22, Tuple22[I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22]]
}
