/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.Content;
import com.nulabinc.backlog4j.Project;
import com.nulabinc.backlog4j.User;
import java.util.Date;

public interface Activity {
    public long getId();

    public String getIdAsString();

    public Project getProject();

    public Type getType();

    public Content getContent();

    public User getCreatedUser();

    public Date getCreated();

    public static enum Type {
        Undefined(-1),
        IssueCreated(1),
        IssueUpdated(2),
        IssueCommented(3),
        IssueDeleted(4),
        WikiCreated(5),
        WikiUpdated(6),
        WikiDeleted(7),
        FileAdded(8),
        FileUpdated(9),
        FileDeleted(10),
        SvnCommitted(11),
        GitPushed(12),
        GitRepositoryCreated(13),
        IssueMultiUpdated(14),
        ProjectUserAdded(15),
        ProjectUserRemoved(16),
        NotifyAdded(17),
        PullRequestAdded(18),
        PullRequestUpdated(19),
        PullRequestCommented(20),
        PullRequestMerged(21);

        private int intValue;

        private Type(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static Type valueOf(int anIntValue) {
            for (Type d : Type.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return Undefined;
        }
    }
}

