/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.BacklogAPIError;
import com.nulabinc.backlog4j.BacklogAPIErrorMessage;
import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import com.nulabinc.backlog4j.internal.json.Jackson;
import java.util.Iterator;

public class BacklogAPIException
extends BacklogException {
    protected BacklogHttpResponse response;
    private int statusCode = -1;
    private BacklogAPIError backlogAPIError;

    public BacklogAPIException(String message, Throwable cause) {
        super(message, cause);
        this.decode(message);
    }

    public BacklogAPIException(String message, Exception cause, int statusCode) {
        this(message, cause);
        this.decode(message);
        this.statusCode = statusCode;
    }

    public BacklogAPIException(String message, BacklogHttpResponse response) {
        this(message);
        this.decode(response.asString());
        this.response = response;
        this.statusCode = response.getStatusCode();
    }

    public BacklogAPIException(String s) {
        super(s);
    }

    public BacklogAPIException(Throwable throwable) {
        super(throwable);
    }

    @Override
    public String getMessage() {
        StringBuilder value = new StringBuilder();
        value.append(super.getMessage());
        if (this.statusCode > 0) {
            value.append("\n");
            value.append("status code - ").append(this.statusCode);
        }
        if (this.backlogAPIError != null) {
            for (BacklogAPIErrorMessage errorMessage : this.backlogAPIError.getErrors()) {
                String moreInfo;
                value.append("\n");
                value.append("message - ").append(errorMessage.getMessage()).append("\n");
                value.append("code - ").append(errorMessage.getCode()).append("\n");
                String info = errorMessage.getErrorInfo();
                if (info != null && info.length() > 0) {
                    value.append("errorInfo - ").append(info).append("\n");
                }
                if ((moreInfo = errorMessage.getMoreInfo()) == null || moreInfo.length() <= 0) continue;
                value.append("moreInfo - ").append(moreInfo).append("\n");
            }
        }
        return value.toString();
    }

    public BacklogAPIError getBacklogAPIError() {
        return this.backlogAPIError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    protected void decode(String str) {
        if (str != null && str.startsWith("{")) {
            this.backlogAPIError = Jackson.fromJsonString(str, BacklogAPIError.class);
        }
    }

    public ErrorType getErrorType() {
        Iterator<BacklogAPIErrorMessage> iterator;
        if (this.backlogAPIError != null && (iterator = this.backlogAPIError.getErrors().iterator()).hasNext()) {
            BacklogAPIErrorMessage errorMessage = iterator.next();
            return ErrorType.valueOf(errorMessage.getCode());
        }
        return null;
    }

    public static enum ErrorType {
        Undefined(-1),
        InternalError(1),
        LicenceError(2),
        LicenceExpiredError(3),
        AccessDeniedError(4),
        UnauthorizedOperationError(5),
        NoResourceError(6),
        InvalidRequestError(7),
        SpaceOverCapacityError(8),
        ResourceOverflowError(9),
        TooLargeFileError(10),
        AuthenticationError(11);

        private int intValue;

        private ErrorType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static ErrorType valueOf(int anIntValue) {
            for (ErrorType d : ErrorType.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return Undefined;
        }
    }
}

