/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.BacklogAPIException;
import com.nulabinc.backlog4j.BacklogEndPointSupport;
import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.api.option.DeleteParams;
import com.nulabinc.backlog4j.api.option.GetParams;
import com.nulabinc.backlog4j.api.option.PatchParams;
import com.nulabinc.backlog4j.api.option.PostParams;
import com.nulabinc.backlog4j.api.option.QueryParams;
import com.nulabinc.backlog4j.auth.AccessToken;
import com.nulabinc.backlog4j.auth.OAuthSupport;
import com.nulabinc.backlog4j.conf.BacklogConfigure;
import com.nulabinc.backlog4j.http.BacklogHttpClient;
import com.nulabinc.backlog4j.http.BacklogHttpClientImpl;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import com.nulabinc.backlog4j.http.NameValuePair;
import com.nulabinc.backlog4j.internal.InternalFactory;
import com.nulabinc.backlog4j.internal.json.InternalFactoryJSONImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BacklogClientBase {
    private final Logger logger = LoggerFactory.getLogger(BacklogClientBase.class);
    protected BacklogHttpClient httpClient;
    protected BacklogConfigure configure;
    protected InternalFactory factory = new InternalFactoryJSONImpl();
    protected OAuthSupport oAuthSupport;
    protected BacklogEndPointSupport backlogEndPointSupport;

    public BacklogClientBase(BacklogConfigure configure) {
        this.configure = configure;
        this.httpClient = new BacklogHttpClientImpl();
        this.backlogEndPointSupport = new BacklogEndPointSupport(configure);
        this.configureHttpClient();
    }

    public BacklogClientBase(BacklogConfigure configure, BacklogHttpClient httpClient) {
        this.configure = configure;
        this.httpClient = httpClient;
        this.backlogEndPointSupport = new BacklogEndPointSupport(configure);
        this.configureHttpClient();
    }

    public void setOAuthSupport(OAuthSupport oAuthSupport) {
        this.oAuthSupport = oAuthSupport;
    }

    private void configureHttpClient() {
        if (this.configure.getApiKey() != null) {
            this.httpClient.setApiKey(this.configure.getApiKey());
        } else if (this.configure.getAccessToken() != null) {
            this.httpClient.setBearerToken(this.configure.getAccessToken().getToken());
        } else {
            throw new BacklogAPIException("ApiKey or AccessToken must not be null");
        }
        this.httpClient.setReadTimeout(this.configure.getReadTimeout());
        this.httpClient.setConnectionTimeout(this.configure.getConnectionTimeout());
    }

    protected BacklogHttpResponse get(String endpoint) throws BacklogException {
        return this.get(endpoint, null, null);
    }

    protected BacklogHttpResponse get(String endpoint, GetParams getParams) throws BacklogException {
        return this.get(endpoint, getParams, null);
    }

    protected BacklogHttpResponse get(String endpoint, QueryParams queryParams) throws BacklogException {
        return this.get(endpoint, null, queryParams);
    }

    protected BacklogHttpResponse get(String endpoint, GetParams getParams, QueryParams queryParams) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.get(endpoint, getParams, queryParams);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.get(endpoint, getParams, queryParams);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    protected BacklogHttpResponse post(String endpoint) throws BacklogException {
        return this.post(endpoint, new ArrayList<NameValuePair>(), new ArrayList<NameValuePair>());
    }

    protected BacklogHttpResponse post(String endpoint, PostParams postParams) throws BacklogException {
        return this.post(endpoint, postParams.getParamList(), new ArrayList<NameValuePair>());
    }

    protected BacklogHttpResponse post(String endpoint, List<NameValuePair> parameters, List<NameValuePair> headers) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.post(endpoint, parameters, headers);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.post(endpoint, parameters, headers);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    protected BacklogHttpResponse patch(String endpoint, PatchParams postParams) throws BacklogException {
        return this.patch(endpoint, postParams.getParamList(), new ArrayList<NameValuePair>());
    }

    protected BacklogHttpResponse patch(String endpoint, List<NameValuePair> parameters, List<NameValuePair> headers) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.patch(endpoint, parameters, headers);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.patch(endpoint, parameters, headers);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    protected BacklogHttpResponse put(String endpoint, List<NameValuePair> parameters) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.put(endpoint, parameters);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.put(endpoint, parameters);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    protected BacklogHttpResponse delete(String endpoint) throws BacklogException {
        return this.delete(endpoint, new ArrayList<NameValuePair>());
    }

    protected BacklogHttpResponse delete(String endpoint, DeleteParams deleteParams) throws BacklogException {
        return this.delete(endpoint, deleteParams.getParamList());
    }

    protected BacklogHttpResponse delete(String endpoint, NameValuePair param) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (param != null) {
            params.add(param);
        }
        return this.delete(endpoint, params);
    }

    protected BacklogHttpResponse delete(String endpoint, List<NameValuePair> parameters) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.delete(endpoint, parameters);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.delete(endpoint, parameters);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    protected BacklogHttpResponse postMultiPart(String endpoint, Map<String, Object> parameters) throws BacklogException {
        BacklogHttpResponse ires = this.httpClient.postMultiPart(endpoint, parameters);
        if (this.needTokenRefresh(ires)) {
            this.refreshToken();
            ires = this.httpClient.postMultiPart(endpoint, parameters);
        }
        this.loggingResponse(endpoint, ires);
        this.checkError(ires);
        return ires;
    }

    private void loggingResponse(String endpoint, BacklogHttpResponse ires) {
        this.logger.info("status code:" + ires.getStatusCode() + " url:" + endpoint);
    }

    private String getRateLimitResetFormatedDate(BacklogHttpResponse ires) {
        if (ires.getRateLimitResetDate() == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdf.format(ires.getRateLimitResetDate());
    }

    protected String buildEndpoint(String connection) {
        StringBuilder url = new StringBuilder().append(this.configure.getRestBaseURL()).append(connection == null ? "" : "/" + connection);
        return url.toString();
    }

    private void checkError(BacklogHttpResponse ires) {
        if (ires.getStatusCode() != 200 && ires.getStatusCode() != 201 && ires.getStatusCode() != 202 && ires.getStatusCode() != 203 && ires.getStatusCode() != 204) {
            if (ires.getStatusCode() == 429) {
                throw new BacklogAPIException("The API usage limit has been exceeded, and will be available again from " + this.getRateLimitResetFormatedDate(ires) + ".", ires);
            }
            throw new BacklogAPIException("backlog api request failed.", ires);
        }
    }

    private boolean needTokenRefresh(BacklogHttpResponse ires) {
        return (ires.getStatusCode() == 401 || ires.getStatusCode() == 0) && this.configure.getApiKey() == null && this.configure.getAccessToken() != null;
    }

    private void refreshToken() {
        AccessToken accessToken = this.oAuthSupport.refreshOAuthAccessToken();
        this.configure.accessToken(accessToken);
        this.configureHttpClient();
    }
}

