/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.Activity;
import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.AttachmentData;
import com.nulabinc.backlog4j.BacklogAPIException;
import com.nulabinc.backlog4j.BacklogClient;
import com.nulabinc.backlog4j.BacklogClientBase;
import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.Category;
import com.nulabinc.backlog4j.CustomFieldSetting;
import com.nulabinc.backlog4j.DiskUsage;
import com.nulabinc.backlog4j.DiskUsageDetail;
import com.nulabinc.backlog4j.Group;
import com.nulabinc.backlog4j.Icon;
import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.IssueComment;
import com.nulabinc.backlog4j.IssueType;
import com.nulabinc.backlog4j.Milestone;
import com.nulabinc.backlog4j.Notification;
import com.nulabinc.backlog4j.Priority;
import com.nulabinc.backlog4j.Project;
import com.nulabinc.backlog4j.ProjectWithVCS;
import com.nulabinc.backlog4j.PullRequest;
import com.nulabinc.backlog4j.PullRequestComment;
import com.nulabinc.backlog4j.Repository;
import com.nulabinc.backlog4j.Resolution;
import com.nulabinc.backlog4j.ResponseList;
import com.nulabinc.backlog4j.SharedFile;
import com.nulabinc.backlog4j.SharedFileData;
import com.nulabinc.backlog4j.Space;
import com.nulabinc.backlog4j.SpaceNotification;
import com.nulabinc.backlog4j.Star;
import com.nulabinc.backlog4j.Status;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.Version;
import com.nulabinc.backlog4j.ViewedIssue;
import com.nulabinc.backlog4j.ViewedProject;
import com.nulabinc.backlog4j.ViewedWiki;
import com.nulabinc.backlog4j.Watch;
import com.nulabinc.backlog4j.Webhook;
import com.nulabinc.backlog4j.Wiki;
import com.nulabinc.backlog4j.WikiHistory;
import com.nulabinc.backlog4j.WikiTag;
import com.nulabinc.backlog4j.api.option.ActivityQueryParams;
import com.nulabinc.backlog4j.api.option.AddCategoryParams;
import com.nulabinc.backlog4j.api.option.AddCheckBoxCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddDateCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddIssueCommentNotificationParams;
import com.nulabinc.backlog4j.api.option.AddIssueCommentParams;
import com.nulabinc.backlog4j.api.option.AddIssueTypeParams;
import com.nulabinc.backlog4j.api.option.AddMilestoneParams;
import com.nulabinc.backlog4j.api.option.AddMultipleListCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddNumericCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddPullRequestCommentParams;
import com.nulabinc.backlog4j.api.option.AddPullRequestParams;
import com.nulabinc.backlog4j.api.option.AddRadioCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddSingleListCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddStatusParams;
import com.nulabinc.backlog4j.api.option.AddTextAreaCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddTextCustomFieldParams;
import com.nulabinc.backlog4j.api.option.AddVersionParams;
import com.nulabinc.backlog4j.api.option.AddWikiAttachmentParams;
import com.nulabinc.backlog4j.api.option.CreateGroupParams;
import com.nulabinc.backlog4j.api.option.CreateIssueParams;
import com.nulabinc.backlog4j.api.option.CreateProjectParams;
import com.nulabinc.backlog4j.api.option.CreateUserParams;
import com.nulabinc.backlog4j.api.option.CreateWebhookParams;
import com.nulabinc.backlog4j.api.option.CreateWikiParams;
import com.nulabinc.backlog4j.api.option.GetIssuesCountParams;
import com.nulabinc.backlog4j.api.option.GetIssuesParams;
import com.nulabinc.backlog4j.api.option.GetNotificationCountParams;
import com.nulabinc.backlog4j.api.option.GetRepositoriesParams;
import com.nulabinc.backlog4j.api.option.GetStarsParams;
import com.nulabinc.backlog4j.api.option.GetWatchesParams;
import com.nulabinc.backlog4j.api.option.GetWikiTagsParams;
import com.nulabinc.backlog4j.api.option.GetWikisParams;
import com.nulabinc.backlog4j.api.option.OffsetParams;
import com.nulabinc.backlog4j.api.option.PullRequestQueryParams;
import com.nulabinc.backlog4j.api.option.QueryParams;
import com.nulabinc.backlog4j.api.option.UpdateCategoryParams;
import com.nulabinc.backlog4j.api.option.UpdateCheckBoxCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateDateCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateGroupParams;
import com.nulabinc.backlog4j.api.option.UpdateIssueCommentParams;
import com.nulabinc.backlog4j.api.option.UpdateIssueParams;
import com.nulabinc.backlog4j.api.option.UpdateIssueTypeParams;
import com.nulabinc.backlog4j.api.option.UpdateMilestoneParams;
import com.nulabinc.backlog4j.api.option.UpdateMultipleListCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateNumericCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateOrderOfStatusParams;
import com.nulabinc.backlog4j.api.option.UpdateProjectParams;
import com.nulabinc.backlog4j.api.option.UpdatePullRequestCommentParams;
import com.nulabinc.backlog4j.api.option.UpdatePullRequestParams;
import com.nulabinc.backlog4j.api.option.UpdateRadioCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateSingleListCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateStatusParams;
import com.nulabinc.backlog4j.api.option.UpdateTextAreaCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateTextCustomFieldParams;
import com.nulabinc.backlog4j.api.option.UpdateVersionParams;
import com.nulabinc.backlog4j.api.option.UpdateWatchParams;
import com.nulabinc.backlog4j.api.option.UpdateWebhookParams;
import com.nulabinc.backlog4j.api.option.UpdateWikiParams;
import com.nulabinc.backlog4j.conf.BacklogConfigure;
import com.nulabinc.backlog4j.http.BacklogHttpClient;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import com.nulabinc.backlog4j.http.NameValuePair;
import com.nulabinc.backlog4j.internal.file.AttachmentDataImpl;
import com.nulabinc.backlog4j.internal.file.IconImpl;
import com.nulabinc.backlog4j.internal.file.SharedFileDataImpl;
import com.nulabinc.backlog4j.internal.json.ResponseListImpl;
import com.nulabinc.backlog4j.internal.json.customFields.CheckBoxCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.DateCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.MultipleListCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.NumericCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.RadioCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.SingleListCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.TextAreaCustomFieldSetting;
import com.nulabinc.backlog4j.internal.json.customFields.TextCustomFieldSetting;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class BacklogClientImpl
extends BacklogClientBase
implements BacklogClient {
    public BacklogClientImpl(BacklogConfigure configure) {
        super(configure);
    }

    public BacklogClientImpl(BacklogConfigure configure, BacklogHttpClient httpClient) {
        super(configure, httpClient);
    }

    @Override
    public Space getSpace() throws BacklogException {
        return this.factory.createSpace(this.get(this.buildEndpoint("space")));
    }

    @Override
    public ResponseList<Activity> getSpaceActivities() throws BacklogException {
        return this.getSpaceActivities(null);
    }

    @Override
    public ResponseList<Activity> getSpaceActivities(ActivityQueryParams params) throws BacklogException {
        return this.factory.createActivityList(this.get(this.buildEndpoint("space/activities"), params));
    }

    @Override
    public Icon getSpaceIcon() throws BacklogException {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getSpaceIconEndpoint());
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new IconImpl(filename, inputStream);
    }

    @Override
    public SpaceNotification getSpaceNotification() throws BacklogException {
        return this.factory.createSpaceNotification(this.get(this.buildEndpoint("space/notification")));
    }

    @Override
    public SpaceNotification updateSpaceNotification(String content) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("content", content));
        return this.factory.createSpaceNotification(this.put(this.buildEndpoint("space/notification"), params));
    }

    @Override
    public DiskUsage getSpaceDiskUsage() throws BacklogException {
        return this.factory.createDiskUsage(this.get(this.buildEndpoint("space/diskUsage")));
    }

    @Override
    public Attachment postAttachment(AttachmentData attachmentData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", attachmentData);
        BacklogHttpResponse backlogHttpResponse = this.postMultiPart(this.buildEndpoint("space/attachment"), parameters);
        return this.factory.createAttachment(backlogHttpResponse);
    }

    @Override
    public ResponseList<Project> getProjects() throws BacklogException {
        return this.factory.createProjectList(this.get(this.buildEndpoint("projects")));
    }

    @Override
    public ProjectWithVCS createProject(CreateProjectParams params) throws BacklogException {
        return this.factory.createProject(this.post(this.buildEndpoint("projects"), params));
    }

    @Override
    public ProjectWithVCS getProject(Object projectIdOrKey) throws BacklogException {
        return this.factory.createProject(this.get(this.buildEndpoint("projects/" + projectIdOrKey)));
    }

    @Override
    public ProjectWithVCS updateProject(UpdateProjectParams params) throws BacklogException {
        return this.factory.createProject(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString()), params));
    }

    @Override
    public Project deleteProject(Object projectIdOrKey) throws BacklogException {
        return this.factory.createProject(this.delete(this.buildEndpoint("projects/" + projectIdOrKey)));
    }

    @Override
    public Icon getProjectIcon(Object projectIdOrKey) throws BacklogException {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getProjectIconEndpoint(projectIdOrKey));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new IconImpl(filename, inputStream);
    }

    @Override
    public ResponseList<Activity> getProjectActivities(Object projectIdOrKey) throws BacklogException {
        return this.factory.createActivityList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/activities")));
    }

    @Override
    public ResponseList<Activity> getProjectActivities(Object projectIdOrKey, ActivityQueryParams query) throws BacklogException {
        return this.factory.createActivityList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/activities"), query));
    }

    @Override
    public ResponseList<User> getProjectUsers(Object projectIdOrKey) throws BacklogException {
        return this.factory.createUserList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/users")));
    }

    @Override
    public User addProjectUser(Object projectIdOrKey, Object userId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("userId", String.valueOf(userId)));
        return this.factory.createUser(this.post(this.buildEndpoint("projects/" + projectIdOrKey + "/users"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public User removeProjectUser(Object projectIdOrKey, Object userId) throws BacklogException {
        return this.factory.createUser(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/users"), new NameValuePair("userId", String.valueOf(userId))));
    }

    @Override
    public User addProjectAdministrator(Object projectIdOrKey, Object userId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("userId", String.valueOf(userId)));
        return this.factory.createUser(this.post(this.buildEndpoint("projects/" + projectIdOrKey + "/administrators"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public ResponseList<User> getProjectAdministrators(Object projectIdOrKey) throws BacklogException {
        return this.factory.createUserList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/administrators")));
    }

    @Override
    public User removeProjectAdministrator(Object projectIdOrKey, Object userId) throws BacklogException {
        return this.factory.createUser(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/administrators"), new NameValuePair("userId", String.valueOf(userId))));
    }

    @Override
    public ResponseList<IssueType> getIssueTypes(Object projectIdOrKey) throws BacklogException {
        return this.factory.createIssueTypeList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/issueTypes")));
    }

    @Override
    public IssueType addIssueType(AddIssueTypeParams params) throws BacklogException {
        return this.factory.createIssueType(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/issueTypes"), params));
    }

    @Override
    public IssueType updateIssueType(UpdateIssueTypeParams params) throws BacklogException {
        return this.factory.createIssueType(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/issueTypes/" + params.getIssueTypeId()), params));
    }

    @Override
    public IssueType removeIssueType(Object projectIdOrKey, Object issueTypeId, Object substituteIssueTypeId) throws BacklogException {
        return this.factory.createIssueType(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/issueTypes/" + issueTypeId), new NameValuePair("substituteIssueTypeId", String.valueOf(substituteIssueTypeId))));
    }

    @Override
    public ResponseList<Status> getStatuses(Object projectIdOrKey) throws BacklogException {
        return this.factory.createStatusList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/statuses")));
    }

    @Override
    public ResponseList<Category> getCategories(Object projectIdOrKey) throws BacklogException {
        return this.factory.createCategoryList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/categories")));
    }

    @Override
    public Category addCategory(AddCategoryParams params) throws BacklogException {
        return this.factory.createCategory(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/categories"), params));
    }

    @Override
    public Category updateCategory(UpdateCategoryParams params) throws BacklogException {
        return this.factory.createCategory(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/categories/" + params.getCategoryId()), params));
    }

    @Override
    public Category removeCategory(Object projectIdOrKey, Object categoryId) throws BacklogException {
        return this.factory.createCategory(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/categories/" + categoryId)));
    }

    @Override
    public ResponseList<Version> getVersions(Object projectIdOrKey) throws BacklogException {
        return this.factory.createVersionList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/versions")));
    }

    @Override
    public Version addVersion(AddVersionParams params) throws BacklogException {
        return this.factory.createVersion(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/versions"), params));
    }

    @Override
    public Version updateVersion(UpdateVersionParams params) throws BacklogException {
        return this.factory.createVersion(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/versions/" + params.getVersionId()), params));
    }

    @Override
    public Version removeVersion(Object projectIdOrKey, Object versionId) throws BacklogException {
        return this.factory.createVersion(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/versions/" + versionId)));
    }

    @Override
    public ResponseList<Milestone> getMilestones(Object projectIdOrKey) throws BacklogException {
        ResponseListImpl<Milestone> list = new ResponseListImpl<Milestone>();
        for (Milestone milestone : this.factory.createMilestoneList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/versions")))) {
            if (milestone.getArchived().booleanValue()) continue;
            list.add(milestone);
        }
        return list;
    }

    @Override
    public Milestone addMilestone(AddMilestoneParams params) throws BacklogException {
        return this.factory.createMilestone(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/versions"), params));
    }

    @Override
    public Milestone updateMilestone(UpdateMilestoneParams params) throws BacklogException {
        return this.factory.createMilestone(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/versions/" + params.getVersionId()), params));
    }

    @Override
    public Milestone removeMilestone(Object projectIdOrKey, Object MilestoneId) throws BacklogException {
        return this.factory.createMilestone(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/versions/" + MilestoneId)));
    }

    @Override
    public ResponseList<CustomFieldSetting> getCustomFields(Object projectIdOrKey) throws BacklogException {
        return this.factory.createCustomFieldList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/customFields")));
    }

    @Override
    public TextCustomFieldSetting addTextCustomField(AddTextCustomFieldParams params) throws BacklogException {
        return (TextCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public TextAreaCustomFieldSetting addTextAreaCustomField(AddTextAreaCustomFieldParams params) throws BacklogException {
        return (TextAreaCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public NumericCustomFieldSetting addNumericCustomField(AddNumericCustomFieldParams params) throws BacklogException {
        return (NumericCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public DateCustomFieldSetting addDateCustomField(AddDateCustomFieldParams params) throws BacklogException {
        return (DateCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public SingleListCustomFieldSetting addSingleListCustomField(AddSingleListCustomFieldParams params) throws BacklogException {
        return (SingleListCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public MultipleListCustomFieldSetting addMultipleListCustomField(AddMultipleListCustomFieldParams params) throws BacklogException {
        return (MultipleListCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public RadioCustomFieldSetting addRadioCustomField(AddRadioCustomFieldParams params) throws BacklogException {
        return (RadioCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public CheckBoxCustomFieldSetting addCheckBoxCustomField(AddCheckBoxCustomFieldParams params) throws BacklogException {
        return (CheckBoxCustomFieldSetting)this.addCustomField(params);
    }

    @Override
    public TextCustomFieldSetting updateTextCustomField(UpdateTextCustomFieldParams params) throws BacklogException {
        return (TextCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public TextAreaCustomFieldSetting updateTextAreaCustomField(UpdateTextAreaCustomFieldParams params) throws BacklogException {
        return (TextAreaCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public NumericCustomFieldSetting updateNumericCustomField(UpdateNumericCustomFieldParams params) throws BacklogException {
        return (NumericCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public DateCustomFieldSetting updateDateCustomField(UpdateDateCustomFieldParams params) throws BacklogException {
        return (DateCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public SingleListCustomFieldSetting updateSingleListCustomField(UpdateSingleListCustomFieldParams params) throws BacklogException {
        return (SingleListCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public MultipleListCustomFieldSetting updateMultipleListCustomField(UpdateMultipleListCustomFieldParams params) throws BacklogException {
        return (MultipleListCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public RadioCustomFieldSetting updateRadioCustomField(UpdateRadioCustomFieldParams params) throws BacklogException {
        return (RadioCustomFieldSetting)this.updateCustomField(params);
    }

    @Override
    public CheckBoxCustomFieldSetting updateCheckBoxCustomField(UpdateCheckBoxCustomFieldParams params) throws BacklogException {
        return (CheckBoxCustomFieldSetting)this.updateCustomField(params);
    }

    private CustomFieldSetting addCustomField(AddCustomFieldParams params) throws BacklogException {
        return this.factory.createCustomField(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/customFields"), params));
    }

    private CustomFieldSetting updateCustomField(UpdateCustomFieldParams params) throws BacklogException {
        return this.factory.createCustomField(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/customFields/" + params.getCustomFiledId()), params));
    }

    @Override
    public CustomFieldSetting removeCustomField(Object projectIdOrKey, Object customFieldId) throws BacklogException {
        return this.factory.createCustomField(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/customFields/" + customFieldId)));
    }

    @Override
    public CustomFieldSetting addListCustomFieldItem(Object projectIdOrKey, Object customFieldId, String name) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("name", name));
        return this.factory.createCustomField(this.post(this.buildEndpoint("projects/" + projectIdOrKey + "/customFields/" + customFieldId + "/items"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public CustomFieldSetting updateListCustomFieldItem(Object projectIdOrKey, Object customFieldId, Object itemId, String name) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("name", name));
        return this.factory.createCustomField(this.patch(this.buildEndpoint("projects/" + projectIdOrKey + "/customFields/" + customFieldId + "/items/" + itemId), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public CustomFieldSetting removeListCustomFieldItem(Object projectIdOrKey, Object customFieldId, Object itemId) throws BacklogException {
        return this.factory.createCustomField(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/customFields/" + customFieldId + "/items/" + itemId)));
    }

    @Override
    public ResponseList<SharedFile> getSharedFiles(Object projectIdOrKey, String path) throws BacklogException {
        return this.getSharedFiles(projectIdOrKey, path, new QueryParams());
    }

    @Override
    public ResponseList<SharedFile> getSharedFiles(Object projectIdOrKey, String path, QueryParams queryParams) throws BacklogException {
        try {
            String encodedPath = URLEncoder.encode(path, "utf-8");
            return this.factory.createSharedFileList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/files/metadata/" + encodedPath), queryParams));
        }
        catch (UnsupportedEncodingException e) {
            throw new BacklogAPIException(e);
        }
    }

    @Override
    public SharedFileData downloadSharedFile(Object projectIdOrKey, Object sharedFileId) throws BacklogException {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getSharedFileEndpoint(projectIdOrKey, sharedFileId));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new SharedFileDataImpl(filename, inputStream);
    }

    @Override
    public DiskUsageDetail getProjectDiskUsage(Object projectIdOrKey) throws BacklogException {
        return this.factory.createDiskUsageDetail(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/diskUsage")));
    }

    @Override
    public ResponseList<Issue> getIssues(GetIssuesParams params) throws BacklogException {
        return this.factory.createIssueList(this.get(this.buildEndpoint("issues"), params));
    }

    @Override
    public int getIssuesCount(GetIssuesCountParams params) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("issues/count"), params)).getCount();
    }

    @Override
    public Issue createIssue(CreateIssueParams params) throws BacklogException {
        return this.factory.createIssue(this.post(this.buildEndpoint("issues"), params));
    }

    @Override
    public Issue updateIssue(UpdateIssueParams params) throws BacklogException {
        return this.factory.createIssue(this.patch(this.buildEndpoint("issues/" + params.getIssueIdOrKeyString()), params));
    }

    @Override
    public Issue deleteIssue(Object issueIdOrKey) throws BacklogException {
        return this.factory.createIssue(this.delete(this.buildEndpoint("issues/" + issueIdOrKey)));
    }

    @Override
    public Issue getIssue(Object issueIdOrKey) throws BacklogException {
        return this.factory.createIssue(this.get(this.buildEndpoint("issues/" + issueIdOrKey)));
    }

    @Override
    public ResponseList<IssueComment> getIssueComments(Object issueIdOrKey) throws BacklogException {
        return this.factory.createIssueCommentList(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/comments")));
    }

    @Override
    public ResponseList<IssueComment> getIssueComments(Object issueIdOrKey, QueryParams queryParams) throws BacklogException {
        return this.factory.createIssueCommentList(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/comments"), queryParams));
    }

    @Override
    public IssueComment addIssueComment(AddIssueCommentParams params) throws BacklogException {
        return this.factory.createIssueComment(this.post(this.buildEndpoint("issues/" + params.getIssueIdOrKeyString() + "/comments"), params));
    }

    @Override
    public int getIssueCommentCount(Object issueIdOrKey) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/comments/count"))).getCount();
    }

    @Override
    public IssueComment getIssueComment(Object issueIdOrKey, Object commentId) throws BacklogException {
        return this.factory.createIssueComment(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/comments/" + commentId)));
    }

    @Override
    public IssueComment updateIssueComment(UpdateIssueCommentParams params) throws BacklogException {
        return this.factory.createIssueComment(this.patch(this.buildEndpoint("issues/" + params.getIssueIdOrKeyString() + "/comments/" + params.getCommentId()), params));
    }

    @Override
    public ResponseList<Notification> getIssueCommentNotifications(Object issueIdOrKey, Object commentId) throws BacklogException {
        return this.factory.createNotificationList(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/comments/" + commentId + "/notifications")));
    }

    @Override
    public IssueComment addIssueCommentNotification(AddIssueCommentNotificationParams params) throws BacklogException {
        return this.factory.createIssueComment(this.post(this.buildEndpoint("issues/" + params.getIssueIdOrKeyString() + "/comments/" + params.getCommentId() + "/notifications"), params));
    }

    @Override
    public ResponseList<Attachment> getIssueAttachments(Object issueIdOrKey) {
        return this.factory.createAttachmentList(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/attachments")));
    }

    @Override
    public AttachmentData downloadIssueAttachment(Object issueIdOrKey, Object attachmentId) {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getIssueAttachmentEndpoint(issueIdOrKey, attachmentId));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new AttachmentDataImpl(filename, inputStream);
    }

    @Override
    public Attachment deleteIssueAttachment(Object issueIdOrKey, Object attachmentId) {
        return this.factory.createAttachment(this.delete(this.buildEndpoint("issues/" + issueIdOrKey + "/attachments/" + attachmentId)));
    }

    @Override
    public ResponseList<SharedFile> getIssueSharedFiles(Object issueIdOrKey) {
        return this.factory.createSharedFileList(this.get(this.buildEndpoint("issues/" + issueIdOrKey + "/sharedFiles")));
    }

    @Override
    public ResponseList<SharedFile> linkIssueSharedFile(Object issueIdOrKey, List fileIds) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Object fileId : fileIds) {
            params.add(new NameValuePair("fileId[]", fileId.toString()));
        }
        return this.factory.createSharedFileList(this.post(this.buildEndpoint("issues/" + issueIdOrKey + "/sharedFiles"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public SharedFile unlinkIssueSharedFile(Object issueIdOrKey, Object fileId) {
        return this.factory.createSharedFile(this.delete(this.buildEndpoint("issues/" + issueIdOrKey + "/sharedFiles/" + fileId)));
    }

    @Override
    public ResponseList<Wiki> getWikis(Object projectIdOrKey) {
        GetWikisParams params = new GetWikisParams(projectIdOrKey);
        return this.factory.createWikiList(this.get(this.buildEndpoint("wikis"), params));
    }

    @Override
    public ResponseList<Wiki> getWikis(GetWikisParams params) {
        ResponseList<Wiki> wikis = this.factory.createWikiList(this.get(this.buildEndpoint("wikis"), params));
        BacklogClientImpl.sortWikis(wikis, params.getSort(), params.getOrder());
        return wikis;
    }

    public static void sortWikis(ResponseList<Wiki> wikis, final GetWikisParams.SortKey sort, final GetWikisParams.Order order) {
        if (sort != null && order != null) {
            Collections.sort(wikis, new Comparator<Wiki>(){

                @Override
                public int compare(Wiki wiki1, Wiki wiki2) {
                    switch (sort) {
                        case Name: {
                            String name1 = wiki1.getName();
                            String name2 = wiki2.getName();
                            return order.equals((Object)GetWikisParams.Order.Asc) ? name1.compareTo(name2) : name2.compareTo(name1);
                        }
                        case Created: {
                            Date created1 = wiki1.getCreated();
                            Date created2 = wiki2.getCreated();
                            return order.equals((Object)GetWikisParams.Order.Asc) ? created1.compareTo(created2) : created2.compareTo(created1);
                        }
                        case Updated: {
                            Date updated1 = wiki1.getUpdated();
                            Date updated2 = wiki2.getUpdated();
                            return order.equals((Object)GetWikisParams.Order.Asc) ? updated1.compareTo(updated2) : updated2.compareTo(updated1);
                        }
                    }
                    return 0;
                }
            });
        }
    }

    @Override
    public int getWikiCount(Object projectIdOrKey) {
        GetWikisParams params = new GetWikisParams(projectIdOrKey);
        return this.factory.createCount(this.get(this.buildEndpoint("wikis/count"), params)).getCount();
    }

    @Override
    public ResponseList<WikiTag> getWikiTags(Object projectIdOrKey) {
        GetWikiTagsParams params = new GetWikiTagsParams(projectIdOrKey);
        return this.factory.createWikiTagList(this.get(this.buildEndpoint("wikis/tags"), params));
    }

    @Override
    public Wiki createWiki(CreateWikiParams params) {
        return this.factory.createWiki(this.post(this.buildEndpoint("wikis"), params));
    }

    @Override
    public Wiki getWiki(Object wikiId) {
        return this.factory.createWiki(this.get(this.buildEndpoint("wikis/" + wikiId)));
    }

    @Override
    public Wiki updateWiki(UpdateWikiParams params) {
        return this.factory.createWiki(this.patch(this.buildEndpoint("wikis/" + params.getWikiId()), params));
    }

    @Override
    public Wiki deleteWiki(Object wikiId, boolean mailNotify) {
        return this.factory.createWiki(this.delete(this.buildEndpoint("wikis/" + wikiId), new NameValuePair("mailNotify", String.valueOf(mailNotify))));
    }

    @Override
    public ResponseList<Attachment> getWikiAttachments(Object wikiId) {
        return this.factory.createAttachmentList(this.get(this.buildEndpoint("wikis/" + wikiId + "/attachments")));
    }

    @Override
    public ResponseList<Attachment> addWikiAttachment(AddWikiAttachmentParams params) {
        return this.factory.createAttachmentList(this.post(this.buildEndpoint("wikis/" + params.getWikiId() + "/attachments"), params));
    }

    @Override
    public AttachmentData downloadWikiAttachment(Object wikiId, Object attachmentId) {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getWikiAttachmentEndpoint(wikiId, attachmentId));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new AttachmentDataImpl(filename, inputStream);
    }

    @Override
    public Attachment deleteWikiAttachment(Object wikiId, Object attachmentId) {
        return this.factory.createAttachment(this.delete(this.buildEndpoint("wikis/" + wikiId + "/attachments/" + attachmentId)));
    }

    @Override
    public ResponseList<SharedFile> getWikiSharedFiles(Object wikiId) {
        return this.factory.createSharedFileList(this.get(this.buildEndpoint("wikis/" + wikiId + "/sharedFiles")));
    }

    @Override
    public ResponseList<SharedFile> linkWikiSharedFile(Object wikiId, List fileIds) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Object fileId : fileIds) {
            params.add(new NameValuePair("fileId[]", fileId.toString()));
        }
        return this.factory.createSharedFileList(this.post(this.buildEndpoint("wikis/" + wikiId + "/sharedFiles"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public SharedFile unlinkWikiSharedFile(Object wikiId, Object fileId) {
        return this.factory.createSharedFile(this.delete(this.buildEndpoint("wikis/" + wikiId + "/sharedFiles/" + fileId)));
    }

    @Override
    public ResponseList<WikiHistory> getWikiHistories(Object wikiId) {
        return this.factory.createWikiHistoryList(this.get(this.buildEndpoint("wikis/" + wikiId + "/history")));
    }

    @Override
    public ResponseList<WikiHistory> getWikiHistories(Object wikiId, QueryParams params) {
        return this.factory.createWikiHistoryList(this.get(this.buildEndpoint("wikis/" + wikiId + "/history"), params));
    }

    @Override
    public ResponseList<Star> getWikiStars(Object wikiId) {
        return this.factory.createStarList(this.get(this.buildEndpoint("wikis/" + wikiId + "/stars")));
    }

    @Override
    public ResponseList<Priority> getPriorities() throws BacklogException {
        return this.factory.createPriorityList(this.get(this.buildEndpoint("priorities")));
    }

    @Override
    public ResponseList<Resolution> getResolutions() throws BacklogException {
        return this.factory.createResolutionList(this.get(this.buildEndpoint("resolutions")));
    }

    @Override
    public ResponseList<Status> getStatuses() throws BacklogException {
        return this.factory.createStatusList(this.get(this.buildEndpoint("statuses")));
    }

    @Override
    public Status addStatus(AddStatusParams params) throws BacklogException {
        return this.factory.createStatus(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/statuses"), params));
    }

    @Override
    public Status updateStatus(UpdateStatusParams params) throws BacklogException {
        return this.factory.createStatus(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/statuses/" + params.getStatusId()), params));
    }

    @Override
    public ResponseList<Status> updateOrderOfStatus(UpdateOrderOfStatusParams params) throws BacklogException {
        return this.factory.createStatusList(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/statuses/updateDisplayOrder"), params));
    }

    @Override
    public Status removeStatus(Object projectIdOrKey, Object statusId, Object substituteStatusId) throws BacklogException {
        return this.factory.createStatus(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/statuses/" + statusId), new NameValuePair("substituteStatusId", String.valueOf(substituteStatusId))));
    }

    @Override
    public Icon getUserIcon(Object numericUserId) {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getUserIconEndpoint(numericUserId));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new IconImpl(filename, inputStream);
    }

    @Override
    public ResponseList<Activity> getUserActivities(Object numericUserId) throws BacklogException {
        return this.factory.createActivityList(this.get(this.buildEndpoint("users/" + numericUserId + "/activities")));
    }

    @Override
    public ResponseList<Activity> getUserActivities(Object numericUserId, ActivityQueryParams queryParams) throws BacklogException {
        return this.factory.createActivityList(this.get(this.buildEndpoint("users/" + numericUserId + "/activities"), queryParams));
    }

    @Override
    public ResponseList<Star> getUserStars(Object numericUserId) throws BacklogException {
        return this.factory.createStarList(this.get(this.buildEndpoint("users/" + numericUserId + "/stars")));
    }

    @Override
    public ResponseList<Star> getUserStars(Object numericUserId, QueryParams queryParams) throws BacklogException {
        return this.factory.createStarList(this.get(this.buildEndpoint("users/" + numericUserId + "/stars"), queryParams));
    }

    @Override
    public int getUserStarCount(Object numericUserId, GetStarsParams params) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("users/" + numericUserId + "/stars/count"), params)).getCount();
    }

    @Override
    public ResponseList<ViewedIssue> getRecentlyViewedIssues() throws BacklogException {
        return this.factory.createViewedIssueList(this.get(this.buildEndpoint("users/myself/recentlyViewedIssues")));
    }

    @Override
    public ResponseList<ViewedIssue> getRecentlyViewedIssues(OffsetParams params) throws BacklogException {
        return this.factory.createViewedIssueList(this.get(this.buildEndpoint("users/myself/recentlyViewedIssues"), params));
    }

    @Override
    public ResponseList<ViewedProject> getRecentlyViewedProjects() throws BacklogException {
        return this.factory.createViewedProjectList(this.get(this.buildEndpoint("users/myself/recentlyViewedProjects")));
    }

    @Override
    public ResponseList<ViewedProject> getRecentlyViewedProjects(OffsetParams params) throws BacklogException {
        return this.factory.createViewedProjectList(this.get(this.buildEndpoint("users/myself/recentlyViewedProjects"), params));
    }

    @Override
    public ResponseList<ViewedWiki> getRecentlyViewedWikis() throws BacklogException {
        return this.factory.createViewedWikiList(this.get(this.buildEndpoint("users/myself/recentlyViewedWikis")));
    }

    @Override
    public ResponseList<ViewedWiki> getRecentlyViewedWikis(OffsetParams params) throws BacklogException {
        return this.factory.createViewedWikiList(this.get(this.buildEndpoint("users/myself/recentlyViewedWikis"), params));
    }

    @Override
    public ResponseList<User> getUsers() throws BacklogException {
        return this.factory.createUserList(this.get(this.buildEndpoint("users")));
    }

    @Override
    public User getUser(Object numericUserId) throws BacklogException {
        return this.factory.createUser(this.get(this.buildEndpoint("users/" + numericUserId)));
    }

    @Override
    public User createUser(CreateUserParams params) throws BacklogException {
        return this.factory.createUser(this.post(this.buildEndpoint("users"), params));
    }

    @Override
    public User deleteUser(Object numericUserId) throws BacklogException {
        return this.factory.createUser(this.delete(this.buildEndpoint("users/" + numericUserId)));
    }

    @Override
    public User getMyself() {
        return this.factory.createUser(this.get(this.buildEndpoint("users/myself")));
    }

    @Override
    public void addStarToIssue(Object issueId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("issueId", String.valueOf(issueId)));
        this.post(this.buildEndpoint("stars"), params, new ArrayList<NameValuePair>());
    }

    @Override
    public void addStarToComment(Object commentId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("commentId", String.valueOf(commentId)));
        this.post(this.buildEndpoint("stars"), params, new ArrayList<NameValuePair>());
    }

    @Override
    public void addStarToWiki(Object wikiId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("wikiId", String.valueOf(wikiId)));
        this.post(this.buildEndpoint("stars"), params, new ArrayList<NameValuePair>());
    }

    @Override
    public void addStarToPullRequest(Object pullRequestId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("pullRequestId", String.valueOf(pullRequestId)));
        this.post(this.buildEndpoint("stars"), params, new ArrayList<NameValuePair>());
    }

    @Override
    public void addStarToPullRequestComment(Object pullRequestCommentId) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("pullRequestCommentId", String.valueOf(pullRequestCommentId)));
        this.post(this.buildEndpoint("stars"), params, new ArrayList<NameValuePair>());
    }

    @Override
    public ResponseList<Notification> getNotifications() throws BacklogException {
        return this.factory.createNotificationList(this.get(this.buildEndpoint("notifications")));
    }

    @Override
    public ResponseList<Notification> getNotifications(QueryParams params) throws BacklogException {
        return this.factory.createNotificationList(this.get(this.buildEndpoint("notifications"), params));
    }

    @Override
    public int getNotificationCount(GetNotificationCountParams params) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("notifications/count"), params)).getCount();
    }

    @Override
    public int resetNotificationCount() throws BacklogException {
        return this.factory.createCount(this.post(this.buildEndpoint("notifications/markAsRead"))).getCount();
    }

    @Override
    public void markAsReadNotification(Object notificationId) throws BacklogException {
        this.post(this.buildEndpoint("notifications/" + notificationId + "/markAsRead"));
    }

    @Override
    public ResponseList<Repository> getGitRepositories(Object projectIdOrKey) throws BacklogException {
        GetRepositoriesParams params = new GetRepositoriesParams(projectIdOrKey.toString());
        return this.factory.createRepositoryList(this.get(this.buildEndpoint("git/repositories"), params));
    }

    @Override
    public Repository getGitRepository(Object projectIdOrKey, Object repoIdOrName) throws BacklogException {
        return this.factory.createRepository(this.get(this.buildEndpoint("projects/" + projectIdOrKey.toString() + "/git/repositories/" + repoIdOrName.toString())));
    }

    @Override
    public ResponseList<PullRequest> getPullRequests(Object projectIdOrKey, Object repoIdOrName) throws BacklogException {
        return this.factory.createPullRequestList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests")));
    }

    @Override
    public ResponseList<PullRequest> getPullRequests(Object projectIdOrKey, Object repoIdOrName, PullRequestQueryParams params) throws BacklogException {
        return this.factory.createPullRequestList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests"), params));
    }

    @Override
    public int getPullRequestCount(Object projectIdOrKey, Object repoIdOrName) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/count"))).getCount();
    }

    @Override
    public int getPullRequestCount(Object projectIdOrKey, Object repoIdOrName, PullRequestQueryParams params) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/count"), params)).getCount();
    }

    @Override
    public PullRequest addPullRequest(AddPullRequestParams params) throws BacklogException {
        return this.factory.createPullRequest(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/git/repositories/" + params.getRepoIdOrNameString() + "/pullRequests"), params));
    }

    @Override
    public PullRequest updatePullRequest(UpdatePullRequestParams params) throws BacklogException {
        return this.factory.createPullRequest(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/git/repositories/" + params.getRepoIdOrNameString() + "/pullRequests/" + params.getNumber()), params));
    }

    @Override
    public PullRequest getPullRequest(Object projectIdOrKey, Object repoIdOrName, Object number) throws BacklogException {
        return this.factory.createPullRequest(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number)));
    }

    @Override
    public ResponseList<PullRequestComment> getPullRequestComments(Object projectIdOrKey, Object repoIdOrName, Object number, QueryParams params) throws BacklogException {
        return this.factory.createPullRequestCommentList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number + "/comments"), params));
    }

    @Override
    public PullRequestComment addPullRequestComment(AddPullRequestCommentParams params) throws BacklogException {
        return this.factory.createPullRequestComment(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/git/repositories/" + params.getRepoIdOrName() + "/pullRequests/" + params.getNumber() + "/comments"), params));
    }

    @Override
    public int getPullRequestCommentCount(Object projectIdOrKey, Object repoIdOrName, Object number) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number + "/comments/count"))).getCount();
    }

    @Override
    public PullRequestComment updatePullRequestComment(UpdatePullRequestCommentParams params) throws BacklogException {
        return this.factory.createPullRequestComment(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/git/repositories/" + params.getRepoIdOrName() + "/pullRequests/" + params.getNumber() + "/comments/" + params.getCommentId()), params));
    }

    @Override
    public ResponseList<Attachment> getPullRequestAttachments(Object projectIdOrKey, Object repoIdOrName, Object number) throws BacklogException {
        return this.factory.createAttachmentList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number + "/attachments")));
    }

    @Override
    public AttachmentData downloadPullRequestAttachment(Object projectIdOrKey, Object repoIdOrName, Object number, Object attachmentId) throws BacklogException {
        BacklogHttpResponse backlogHttpResponse = this.get(this.backlogEndPointSupport.getPullRequestAttachmentEndpoint(projectIdOrKey, repoIdOrName, number, attachmentId));
        String filename = backlogHttpResponse.getFileNameFromContentDisposition();
        InputStream inputStream = backlogHttpResponse.asInputStream();
        return new AttachmentDataImpl(filename, inputStream);
    }

    @Override
    public Attachment deletePullRequestAttachment(Object projectIdOrKey, Object repoIdOrName, Object number, Object attachmentId) throws BacklogException {
        return this.factory.createAttachment(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number + "/attachments/" + attachmentId)));
    }

    @Override
    public ResponseList<Group> getGroups() throws BacklogException {
        return this.factory.createGroupList(this.get(this.buildEndpoint("groups")));
    }

    @Override
    public ResponseList<Group> getGroups(OffsetParams params) throws BacklogException {
        return this.factory.createGroupList(this.get(this.buildEndpoint("groups"), params));
    }

    @Override
    public Group createGroup(CreateGroupParams params) throws BacklogException {
        return this.factory.createGroup(this.post(this.buildEndpoint("groups"), params));
    }

    @Override
    public Group getGroup(Object groupId) throws BacklogException {
        return this.factory.createGroup(this.get(this.buildEndpoint("groups/" + groupId)));
    }

    @Override
    public Group updateGroup(UpdateGroupParams params) throws BacklogException {
        return this.factory.createGroup(this.patch(this.buildEndpoint("groups/" + params.getGroupId()), params));
    }

    @Override
    public Group deleteGroup(Object groupId) throws BacklogException {
        return this.factory.createGroup(this.delete(this.buildEndpoint("groups/" + groupId)));
    }

    @Override
    public ResponseList<Webhook> getWebhooks(Object projectIdOrKey) throws BacklogException {
        return this.factory.createWebhookList(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/webhooks")));
    }

    @Override
    public Webhook createWebhook(CreateWebhookParams params) throws BacklogException {
        return this.factory.createWebhook(this.post(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/webhooks"), params));
    }

    @Override
    public Webhook getWebhook(Object projectIdOrKey, Object webhookId) throws BacklogException {
        return this.factory.createWebhook(this.get(this.buildEndpoint("projects/" + projectIdOrKey + "/webhooks/" + webhookId)));
    }

    @Override
    public Webhook updateWebhook(UpdateWebhookParams params) throws BacklogException {
        return this.factory.createWebhook(this.patch(this.buildEndpoint("projects/" + params.getProjectIdOrKeyString() + "/webhooks/" + params.getWebhookId()), params));
    }

    @Override
    public Webhook deleteWebhook(Object projectIdOrKey, Object webhookId) throws BacklogException {
        return this.factory.createWebhook(this.delete(this.buildEndpoint("projects/" + projectIdOrKey + "/webhooks/" + webhookId)));
    }

    @Override
    public String getPullRequestUrl(Project project, Repository repository, PullRequest pullRequest) {
        return this.configure.getWebAppBaseURL() + "/git/" + project.getProjectKey() + "/" + repository.getName() + "/pullRequests/" + pullRequest.getNumber();
    }

    @Override
    public String getPullRequestCommentUrl(Project project, Repository repository, PullRequest pullRequest, PullRequestComment pullRequestComment) {
        return this.getPullRequestUrl(project, repository, pullRequest) + "#comment-" + pullRequestComment.getId();
    }

    @Override
    public String getIssueUrl(Issue issue) {
        return this.configure.getWebAppBaseURL() + "/view/" + issue.getIssueKey();
    }

    @Override
    public String getIssueCommentUrl(Issue issue, IssueComment issueComment) {
        return this.getIssueUrl(issue) + "#comment-" + issueComment.getId();
    }

    @Override
    public String getWikiUrl(Project project, Wiki wiki) {
        try {
            return this.configure.getWebAppBaseURL() + "/wiki/" + project.getProjectKey() + "/" + URLEncoder.encode(wiki.getName(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Watch getWatch(Long watchingId) throws BacklogException {
        return this.factory.createWatch(this.get(this.buildEndpoint("watchings/" + watchingId)));
    }

    @Override
    public int getUserWatchCount(Object numericUserId, GetWatchesParams params) throws BacklogException {
        return this.factory.createCount(this.get(this.buildEndpoint("users/" + numericUserId + "/watchings/count"), params)).getCount();
    }

    @Override
    public ResponseList<Watch> getUserWatches(Object numericUserId) throws BacklogException {
        return this.factory.createWatchList(this.get(this.buildEndpoint("users/" + numericUserId + "/watchings")));
    }

    @Override
    public Watch addWatchToIssue(Object issueIdOrKey, String note) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("issueIdOrKey", String.valueOf(issueIdOrKey)));
        if (note != null) {
            params.add(new NameValuePair("note", note));
        }
        return this.factory.createWatch(this.post(this.buildEndpoint("watchings"), params, new ArrayList<NameValuePair>()));
    }

    @Override
    public Watch updateWatch(UpdateWatchParams params) throws BacklogException {
        return this.factory.createWatch(this.patch(this.buildEndpoint("watchings/" + params.getWatchingIdString()), params));
    }

    @Override
    public Watch deleteWatch(Object watchingId) throws BacklogException {
        return this.factory.createWatch(this.delete(this.buildEndpoint("watchings/" + watchingId)));
    }

    @Override
    public void markAsCheckedUserWatches(Object numericUserId) throws BacklogException {
        this.post(this.buildEndpoint("users/" + numericUserId + "/watchings/markAsChecked"));
    }
}

