/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.conf.BacklogConfigure;

public class BacklogEndPointSupport {
    private BacklogConfigure configure;

    public BacklogEndPointSupport(BacklogConfigure backlogConfigure) {
        this.configure = backlogConfigure;
    }

    public String getSpaceIconEndpoint() throws BacklogException {
        return this.buildEndpoint("space/image");
    }

    public String getProjectIconEndpoint(Object projectIdOrKey) throws BacklogException {
        return this.buildEndpoint("projects/" + projectIdOrKey + "/image");
    }

    public String getUserIconEndpoint(Object numericUserId) throws BacklogException {
        return this.buildEndpoint("users/" + numericUserId + "/icon");
    }

    public String getSharedFileEndpoint(Object projectIdOrKey, Object sharedFileId) throws BacklogException {
        return this.buildEndpoint("projects/" + projectIdOrKey + "/files/" + sharedFileId);
    }

    public String getIssueAttachmentEndpoint(Object issueIdOrKey, Object attachmentId) throws BacklogException {
        return this.buildEndpoint("issues/" + issueIdOrKey + "/attachments/" + attachmentId);
    }

    public String getWikiAttachmentEndpoint(Object wikiId, Object attachmentId) throws BacklogException {
        return this.buildEndpoint("wikis/" + wikiId + "/attachments/" + attachmentId);
    }

    public String getPullRequestAttachmentEndpoint(Object projectIdOrKey, Object repoIdOrName, Object number, Object attachmentId) {
        return this.buildEndpoint("projects/" + projectIdOrKey + "/git/repositories/" + repoIdOrName + "/pullRequests/" + number + "/attachments/" + attachmentId);
    }

    protected String buildEndpoint(String connection) {
        return this.configure.getRestBaseURL() + "/" + connection;
    }
}

