/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.Category;
import com.nulabinc.backlog4j.CustomField;
import com.nulabinc.backlog4j.IssueType;
import com.nulabinc.backlog4j.Milestone;
import com.nulabinc.backlog4j.Priority;
import com.nulabinc.backlog4j.Resolution;
import com.nulabinc.backlog4j.SharedFile;
import com.nulabinc.backlog4j.Star;
import com.nulabinc.backlog4j.Status;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.Version;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public interface Issue {
    public long getId();

    public String getIdAsString();

    public String getIssueKey();

    public long getKeyId();

    public String getKeyIdAsString();

    public long getProjectId();

    public String getProjectIdAsString();

    public IssueType getIssueType();

    public String getSummary();

    public String getDescription();

    public Resolution getResolution();

    public Priority getPriority();

    public Status getStatus();

    public User getAssignee();

    public List<Category> getCategory();

    public List<Version> getVersions();

    public List<Milestone> getMilestone();

    public Date getStartDate();

    public Date getDueDate();

    public BigDecimal getEstimatedHours();

    public BigDecimal getActualHours();

    public long getParentIssueId();

    public User getCreatedUser();

    public Date getCreated();

    public User getUpdatedUser();

    public Date getUpdated();

    public List<CustomField> getCustomFields();

    public List<Attachment> getAttachments();

    public List<SharedFile> getSharedFiles();

    public List<Star> getStars();

    public static enum PriorityType {
        High(2),
        Normal(3),
        Low(4);

        private int intValue;

        private PriorityType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static PriorityType valueOf(int anIntValue) {
            for (PriorityType d : PriorityType.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return null;
        }
    }

    public static enum ResolutionType {
        NotSet(-1),
        Fixed(0),
        WontFix(1),
        Invalid(2),
        Duplication(3),
        CannotReproduce(4);

        private int intValue;

        private ResolutionType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static ResolutionType valueOf(int anIntValue) {
            for (ResolutionType d : ResolutionType.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return NotSet;
        }
    }

    public static enum StatusType {
        Open(1),
        InProgress(2),
        Resolved(3),
        Closed(4),
        Custom(-1);

        private int intValue;

        private StatusType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static StatusType valueOf(int anIntValue) {
            for (StatusType d : StatusType.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return Custom;
        }
    }
}

