/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j;

import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.IssueComment;
import com.nulabinc.backlog4j.Project;
import com.nulabinc.backlog4j.PullRequest;
import com.nulabinc.backlog4j.PullRequestComment;
import com.nulabinc.backlog4j.User;
import java.util.Date;

public interface Notification {
    public long getId();

    public String getIdAsString();

    public boolean isAlreadyRead();

    public Reason getReason();

    public boolean isResourceAlreadyRead();

    public User getSender();

    public User getUser();

    public Project getProject();

    public Issue getIssue();

    public IssueComment getComment();

    public PullRequest getPullRequest();

    public PullRequestComment getPullRequestComment();

    public Date getCreated();

    public static enum Reason {
        Undefined(-1),
        Assigned(1),
        Commented(2),
        IssueCreated(3),
        IssueUpdated(4),
        FileAttached(5),
        ProjectUserAdded(6),
        Other(9),
        PullRequestAssigned(10),
        PullRequestCommented(11),
        PullRequestAdded(12),
        PullRequestUpdated(13);

        private int intValue;

        private Reason(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static Reason valueOf(int anIntValue) {
            for (Reason d : Reason.values()) {
                if (d.getIntValue() != anIntValue) continue;
                return d;
            }
            return Undefined;
        }
    }
}

