/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.api.option;

import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.api.option.CustomFiledItem;
import com.nulabinc.backlog4j.api.option.CustomFiledItems;
import com.nulabinc.backlog4j.api.option.CustomFiledValue;
import com.nulabinc.backlog4j.api.option.PostParams;
import com.nulabinc.backlog4j.http.NameValuePair;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateIssueParams
extends PostParams {
    public CreateIssueParams(Object projectId, String summary, Object issueTypeId, Issue.PriorityType priority) {
        this.parameters.add(new NameValuePair("projectId", projectId.toString()));
        this.parameters.add(new NameValuePair("summary", summary));
        this.parameters.add(new NameValuePair("issueTypeId", issueTypeId.toString()));
        this.parameters.add(new NameValuePair("priorityId", String.valueOf(priority.getIntValue())));
    }

    public CreateIssueParams parentIssueId(Object parentIssueId) {
        this.parameters.add(new NameValuePair("parentIssueId", parentIssueId.toString()));
        return this;
    }

    public CreateIssueParams description(String description) {
        this.parameters.add(new NameValuePair("description", description));
        return this;
    }

    public CreateIssueParams startDate(String startDate) {
        this.parameters.add(new NameValuePair("startDate", startDate));
        return this;
    }

    public CreateIssueParams dueDate(String dueDate) {
        this.parameters.add(new NameValuePair("dueDate", dueDate));
        return this;
    }

    public CreateIssueParams estimatedHours(float estimatedHours) {
        this.parameters.add(new NameValuePair("estimatedHours", Float.toString(estimatedHours)));
        return this;
    }

    public CreateIssueParams estimatedHours(BigDecimal estimatedHours) {
        if (estimatedHours == null) {
            this.parameters.add(new NameValuePair("estimatedHours", ""));
        } else {
            this.parameters.add(new NameValuePair("estimatedHours", estimatedHours.setScale(2, 4).toPlainString()));
        }
        return this;
    }

    public CreateIssueParams actualHours(float actualHours) {
        this.parameters.add(new NameValuePair("actualHours", Float.toString(actualHours)));
        return this;
    }

    public CreateIssueParams actualHours(BigDecimal actualHours) {
        if (actualHours == null) {
            this.parameters.add(new NameValuePair("actualHours", ""));
        } else {
            this.parameters.add(new NameValuePair("actualHours", actualHours.setScale(2, 4).toPlainString()));
        }
        return this;
    }

    public CreateIssueParams categoryIds(List categoryIds) {
        for (Object categoryId : categoryIds) {
            this.parameters.add(new NameValuePair("categoryId[]", categoryId.toString()));
        }
        return this;
    }

    public CreateIssueParams versionIds(List versionIds) {
        for (Object versionId : versionIds) {
            this.parameters.add(new NameValuePair("versionId[]", versionId.toString()));
        }
        return this;
    }

    public CreateIssueParams milestoneIds(List milestoneIds) {
        for (Object milestoneId : milestoneIds) {
            this.parameters.add(new NameValuePair("milestoneId[]", milestoneId.toString()));
        }
        return this;
    }

    public CreateIssueParams assigneeId(Object assigneeId) {
        this.parameters.add(new NameValuePair("assigneeId", assigneeId.toString()));
        return this;
    }

    public CreateIssueParams notifiedUserIds(List notifiedUserIds) {
        for (Object notifiedUserId : notifiedUserIds) {
            this.parameters.add(new NameValuePair("notifiedUserId[]", notifiedUserId.toString()));
        }
        return this;
    }

    public CreateIssueParams attachmentIds(List attachmentIds) {
        for (Object attachmentId : attachmentIds) {
            this.parameters.add(new NameValuePair("attachmentId[]", attachmentId.toString()));
        }
        return this;
    }

    public CreateIssueParams textCustomField(CustomFiledValue customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + customFieldValue.getCustomFieldId(), customFieldValue.getCustomFieldValue()));
        return this;
    }

    public CreateIssueParams textCustomFields(List<CustomFiledValue> customFieldValueList) {
        for (CustomFiledValue customFiledValue : customFieldValueList) {
            this.textCustomField(customFiledValue);
        }
        return this;
    }

    public CreateIssueParams textAreaCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public CreateIssueParams textAreaCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public CreateIssueParams numericCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public CreateIssueParams numericCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public CreateIssueParams dateCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public CreateIssueParams dateCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public CreateIssueParams singleListCustomField(CustomFiledItem customFiledItem) {
        this.parameters.add(new NameValuePair("customField_" + customFiledItem.getCustomFieldId(), customFiledItem.getCustomFieldItemId()));
        return this;
    }

    public CreateIssueParams singleListCustomFields(List<CustomFiledItem> customFiledItemList) {
        for (CustomFiledItem customFiledItem : customFiledItemList) {
            this.singleListCustomField(customFiledItem);
        }
        return this;
    }

    public CreateIssueParams radioCustomField(CustomFiledItem customFiledItem) {
        return this.singleListCustomField(customFiledItem);
    }

    public CreateIssueParams radioCustomFields(List<CustomFiledItem> customFiledItemList) {
        return this.singleListCustomFields(customFiledItemList);
    }

    public CreateIssueParams multipleListCustomField(CustomFiledItems customFiledItems) {
        for (String id : customFiledItems.getCustomFieldItemIds()) {
            this.parameters.add(new NameValuePair("customField_" + customFiledItems.getCustomFieldId(), id.toString()));
        }
        return this;
    }

    public CreateIssueParams multipleListCustomFields(List<CustomFiledItems> customFiledItemsList) {
        for (CustomFiledItems customFiledItems : customFiledItemsList) {
            this.multipleListCustomField(customFiledItems);
        }
        return this;
    }

    public CreateIssueParams checkBoxCustomField(CustomFiledItems customFiledItems) {
        return this.multipleListCustomField(customFiledItems);
    }

    public CreateIssueParams checkBoxCustomFields(List<CustomFiledItems> customFiledItemsList) {
        return this.multipleListCustomFields(customFiledItemsList);
    }

    public CreateIssueParams customFieldOtherValue(CustomFiledValue customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + customFieldValue.getCustomFieldId() + "_otherValue", customFieldValue.getCustomFieldValue()));
        return this;
    }

    public CreateIssueParams customFieldOtherValues(List<CustomFiledValue> customFieldValueList) {
        for (CustomFiledValue customFiledValue : customFieldValueList) {
            this.customFieldOtherValue(customFiledValue);
        }
        return this;
    }

    public CreateIssueParams textCustomField(long customFieldId, String customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldValue)));
        return this;
    }

    public CreateIssueParams textCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key)));
        }
        return this;
    }

    public CreateIssueParams textAreaCustomField(long customFieldId, String customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldValue)));
        return this;
    }

    public CreateIssueParams textAreaCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key)));
        }
        return this;
    }

    public CreateIssueParams numericCustomField(long customFieldId, float customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), Float.toString(customFieldValue)));
        return this;
    }

    public CreateIssueParams numericCustomField(long customFieldId, BigDecimal customFieldValue) {
        if (customFieldValue == null) {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), ""));
        } else {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), customFieldValue.setScale(4, 4).toPlainString()));
        }
        return this;
    }

    public CreateIssueParams numericCustomFieldMap(Map<Long, Float> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), Float.toString(customFieldMap.get(key).floatValue())));
        }
        return this;
    }

    public CreateIssueParams dateCustomField(long customFieldId, String customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldValue)));
        return this;
    }

    public CreateIssueParams dateCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key)));
        }
        return this;
    }

    public CreateIssueParams singleListCustomField(long customFieldId, long customFieldItemId) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldItemId)));
        return this;
    }

    public CreateIssueParams singleListCustomFieldMap(Map<Long, Long> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key).toString()));
        }
        return this;
    }

    public CreateIssueParams radioCustomField(long customFieldId, long customFieldItemId) {
        return this.singleListCustomField(customFieldId, customFieldItemId);
    }

    public CreateIssueParams radioCustomFieldMap(Map<Long, Long> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key).toString()));
        }
        return this;
    }

    public CreateIssueParams multipleListCustomField(long customFieldId, List<Long> customFieldItemIds) {
        for (Long customFieldItemId : customFieldItemIds) {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldItemId)));
        }
        return this;
    }

    public CreateIssueParams multipleListCustomFieldMap(Map<Long, List<Long>> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            for (Long value : customFieldMap.get(key)) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), value.toString()));
            }
        }
        return this;
    }

    public CreateIssueParams checkBoxCustomField(long customFieldId, List<Long> customFieldItemIds) {
        return this.multipleListCustomField(customFieldId, customFieldItemIds);
    }

    public CreateIssueParams checkBoxCustomFieldMap(Map<Long, List<Long>> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            for (Long value : customFieldMap.get(key)) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), value.toString()));
            }
        }
        return this;
    }

    public CreateIssueParams customFieldOtherValue(long customFieldId, String otherValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId) + "_otherValue", otherValue));
        return this;
    }

    public CreateIssueParams customFieldOtherValueMap(Map<Long, String> customFieldOtherValueMap) {
        Set<Long> keySet = customFieldOtherValueMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString() + "_otherValue", customFieldOtherValueMap.get(key)));
        }
        return this;
    }
}

