/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.api.option;

import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.api.option.GetParams;
import com.nulabinc.backlog4j.http.NameValuePair;
import java.util.List;

public class GetIssuesParams
extends GetParams {
    public GetIssuesParams(List projectIds) {
        for (Object projectId : projectIds) {
            this.parameters.add(new NameValuePair("projectId[]", projectId.toString()));
        }
    }

    public GetIssuesParams issueTypeIds(List issueTypeIds) {
        for (Object issueTypeId : issueTypeIds) {
            this.parameters.add(new NameValuePair("issueTypeId[]", issueTypeId.toString()));
        }
        return this;
    }

    public GetIssuesParams categoryIds(List categoryIds) {
        for (Object categoryId : categoryIds) {
            this.parameters.add(new NameValuePair("categoryId[]", categoryId.toString()));
        }
        return this;
    }

    public GetIssuesParams versionIds(List versionIds) {
        for (Object versionId : versionIds) {
            this.parameters.add(new NameValuePair("versionId[]", versionId.toString()));
        }
        return this;
    }

    public GetIssuesParams milestoneIds(List milestoneIds) {
        for (Object milestoneId : milestoneIds) {
            this.parameters.add(new NameValuePair("milestoneId[]", milestoneId.toString()));
        }
        return this;
    }

    public GetIssuesParams statuses(List<Issue.StatusType> statuses) {
        for (Issue.StatusType status : statuses) {
            this.parameters.add(new NameValuePair("statusId[]", String.valueOf(status.getIntValue())));
        }
        return this;
    }

    public GetIssuesParams statusIds(List statusIds) {
        for (Object statusId : statusIds) {
            this.parameters.add(new NameValuePair("statusId[]", statusId.toString()));
        }
        return this;
    }

    public GetIssuesParams priorities(List<Issue.PriorityType> priorities) {
        for (Issue.PriorityType priority : priorities) {
            this.parameters.add(new NameValuePair("priorityId[]", String.valueOf(priority.getIntValue())));
        }
        return this;
    }

    public GetIssuesParams assigneeIds(List assigneeIds) {
        for (Object assigneeId : assigneeIds) {
            this.parameters.add(new NameValuePair("assigneeId[]", assigneeId.toString()));
        }
        return this;
    }

    public GetIssuesParams createdUserIds(List createdUserIds) {
        for (Object createdUserId : createdUserIds) {
            this.parameters.add(new NameValuePair("createdUserId[]", createdUserId.toString()));
        }
        return this;
    }

    public GetIssuesParams resolutions(List<Issue.ResolutionType> resolutions) {
        for (Issue.ResolutionType resolution : resolutions) {
            this.parameters.add(new NameValuePair("resolutionId[]", String.valueOf(resolution.getIntValue())));
        }
        return this;
    }

    public GetIssuesParams parentChildType(ParentChildType parentChildType) {
        this.parameters.add(new NameValuePair("parentChild", String.valueOf(parentChildType.getIntValue())));
        return this;
    }

    public GetIssuesParams attachment(boolean attachment) {
        this.parameters.add(new NameValuePair("attachment", String.valueOf(attachment)));
        return this;
    }

    public GetIssuesParams sharedFile(boolean sharedFile) {
        this.parameters.add(new NameValuePair("sharedFile", String.valueOf(sharedFile)));
        return this;
    }

    public GetIssuesParams sort(SortKey sort) {
        this.parameters.add(new NameValuePair("sort", sort.getStrValue()));
        return this;
    }

    public GetIssuesParams sortByCustomField(Object customFieldId) {
        this.parameters.add(new NameValuePair("sort", "customField_" + customFieldId.toString()));
        return this;
    }

    public GetIssuesParams order(Order order) {
        this.parameters.add(new NameValuePair("order", order.getStrValue()));
        return this;
    }

    public GetIssuesParams offset(long offset) {
        this.parameters.add(new NameValuePair("offset", String.valueOf(offset)));
        return this;
    }

    public GetIssuesParams count(long count) {
        this.parameters.add(new NameValuePair("count", String.valueOf(count)));
        return this;
    }

    public GetIssuesParams count(int count) {
        this.parameters.add(new NameValuePair("count", String.valueOf(count)));
        return this;
    }

    public GetIssuesParams createdSince(String createdSince) {
        this.parameters.add(new NameValuePair("createdSince", createdSince));
        return this;
    }

    public GetIssuesParams createdUntil(String createdUntil) {
        this.parameters.add(new NameValuePair("createdUntil", createdUntil));
        return this;
    }

    public GetIssuesParams updatedSince(String updatedSince) {
        this.parameters.add(new NameValuePair("updatedSince", updatedSince));
        return this;
    }

    public GetIssuesParams updatedUntil(String updatedUntil) {
        this.parameters.add(new NameValuePair("updatedUntil", updatedUntil));
        return this;
    }

    public GetIssuesParams startDateSince(String startDateSince) {
        this.parameters.add(new NameValuePair("startDateSince", startDateSince));
        return this;
    }

    public GetIssuesParams startDateUntil(String startDateUntil) {
        this.parameters.add(new NameValuePair("startDateUntil", startDateUntil));
        return this;
    }

    public GetIssuesParams dueDateSince(String dueDateSince) {
        this.parameters.add(new NameValuePair("dueDateSince", dueDateSince));
        return this;
    }

    public GetIssuesParams dueDateUntil(String dueDateUntil) {
        this.parameters.add(new NameValuePair("dueDateUntil", dueDateUntil));
        return this;
    }

    public GetIssuesParams ids(List ids) {
        for (Object id : ids) {
            this.parameters.add(new NameValuePair("id[]", id.toString()));
        }
        return this;
    }

    public GetIssuesParams parentIssueIds(List parentIssueIds) {
        for (Object parentIssueId : parentIssueIds) {
            this.parameters.add(new NameValuePair("parentIssueId[]", parentIssueId.toString()));
        }
        return this;
    }

    public GetIssuesParams keyword(String keyword) throws BacklogException {
        this.parameters.add(new NameValuePair("keyword", keyword));
        return this;
    }

    public GetIssuesParams keywordByCustomField(Object customFieldId, String keyword) throws BacklogException {
        this.parameters.add(new NameValuePair("customField_" + customFieldId.toString(), keyword));
        return this;
    }

    public GetIssuesParams minNumOfCustomField(Object customFieldId, float min) throws BacklogException {
        this.parameters.add(new NameValuePair("customField_" + customFieldId.toString() + "_min", String.valueOf(min)));
        return this;
    }

    public GetIssuesParams maxNumOfCustomField(Object customFieldId, float max) throws BacklogException {
        this.parameters.add(new NameValuePair("customField_" + customFieldId.toString() + "_max", String.valueOf(max)));
        return this;
    }

    public GetIssuesParams minDateOfCustomField(Object customFieldId, String min) throws BacklogException {
        this.parameters.add(new NameValuePair("customField_" + customFieldId.toString() + "_min", min));
        return this;
    }

    public GetIssuesParams maxDateOfCustomField(Object customFieldId, String max) throws BacklogException {
        this.parameters.add(new NameValuePair("customField_" + customFieldId.toString() + "_max", max));
        return this;
    }

    public GetIssuesParams itemsOfCustomField(Object customFieldId, List itemIds) {
        for (Object itemId : itemIds) {
            this.parameters.add(new NameValuePair("customField_" + customFieldId.toString() + "[]", itemId.toString()));
        }
        return this;
    }

    public static enum ParentChildType {
        All(0),
        NotChild(1),
        Child(2),
        NotChildNotParent(3),
        Parent(4);

        private int intValue;

        private ParentChildType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }
    }

    public static enum Order {
        Asc("asc"),
        Desc("desc");

        private String value;

        private Order(String value) {
            this.value = value;
        }

        public String getStrValue() {
            return this.value;
        }
    }

    public static enum SortKey {
        IssueType("issueType"),
        Category("category"),
        Version("version"),
        Milestone("milestone"),
        Summary("summary"),
        Status("status"),
        Priority("priority"),
        Attachment("attachment"),
        SharedFile("sharedFile"),
        Created("created"),
        CreatedUser("createdUser"),
        Updated("updated"),
        UpdatedUser("updatedUser"),
        Assignee("assignee"),
        StartDate("startDate"),
        DueDate("dueDate"),
        EstimatedHours("estimatedHours"),
        ActualHours("actualHours"),
        ChildIssue("childIssue");

        private String value;

        private SortKey(String value) {
            this.value = value;
        }

        public String getStrValue() {
            return this.value;
        }
    }
}

