/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.api.option;

import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.api.option.CustomFiledItem;
import com.nulabinc.backlog4j.api.option.CustomFiledItems;
import com.nulabinc.backlog4j.api.option.CustomFiledValue;
import com.nulabinc.backlog4j.api.option.PatchParams;
import com.nulabinc.backlog4j.http.NameValuePair;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateIssueParams
extends PatchParams {
    public static final long PARENT_ISSUE_NOT_SET = -1L;
    private Object issueIdOrKey;

    public UpdateIssueParams(Object issueIdOrKey) {
        this.issueIdOrKey = issueIdOrKey;
    }

    public String getIssueIdOrKeyString() {
        return this.issueIdOrKey.toString();
    }

    public UpdateIssueParams summary(String summary) {
        this.parameters.add(new NameValuePair("summary", summary));
        return this;
    }

    public UpdateIssueParams parentIssueId(long parentIssueId) {
        if (parentIssueId == -1L) {
            this.parameters.add(new NameValuePair("parentIssueId", ""));
        } else {
            this.parameters.add(new NameValuePair("parentIssueId", String.valueOf(parentIssueId)));
        }
        return this;
    }

    public UpdateIssueParams description(String description) {
        this.parameters.add(new NameValuePair("description", String.valueOf(description)));
        return this;
    }

    public UpdateIssueParams status(Issue.StatusType statusType) {
        this.parameters.add(new NameValuePair("statusId", String.valueOf(statusType.getIntValue())));
        return this;
    }

    public UpdateIssueParams statusId(int statusId) {
        this.parameters.add(new NameValuePair("statusId", String.valueOf(statusId)));
        return this;
    }

    public UpdateIssueParams resolution(Issue.ResolutionType resolutionType) {
        if (resolutionType == null || resolutionType.equals((Object)Issue.ResolutionType.NotSet)) {
            this.parameters.add(new NameValuePair("resolutionId", ""));
        } else {
            this.parameters.add(new NameValuePair("resolutionId", String.valueOf(resolutionType.getIntValue())));
        }
        return this;
    }

    public UpdateIssueParams startDate(String startDate) {
        if (startDate == null) {
            this.parameters.add(new NameValuePair("startDate", ""));
        } else {
            this.parameters.add(new NameValuePair("startDate", String.valueOf(startDate)));
        }
        return this;
    }

    public UpdateIssueParams dueDate(String dueDate) {
        if (dueDate == null) {
            this.parameters.add(new NameValuePair("dueDate", ""));
        } else {
            this.parameters.add(new NameValuePair("dueDate", String.valueOf(dueDate)));
        }
        return this;
    }

    public UpdateIssueParams estimatedHours(int estimatedHours) {
        this.parameters.add(new NameValuePair("estimatedHours", String.valueOf(estimatedHours)));
        return this;
    }

    public UpdateIssueParams estimatedHours(float estimatedHours) {
        this.parameters.add(new NameValuePair("estimatedHours", Float.toString(estimatedHours)));
        return this;
    }

    public UpdateIssueParams estimatedHours(BigDecimal estimatedHours) {
        if (estimatedHours == null) {
            this.parameters.add(new NameValuePair("estimatedHours", ""));
        } else {
            this.parameters.add(new NameValuePair("estimatedHours", estimatedHours.setScale(2, 4).toPlainString()));
        }
        return this;
    }

    public UpdateIssueParams actualHours(int actualHours) {
        this.parameters.add(new NameValuePair("actualHours", String.valueOf(actualHours)));
        return this;
    }

    public UpdateIssueParams actualHours(float actualHours) {
        this.parameters.add(new NameValuePair("actualHours", Float.toString(actualHours)));
        return this;
    }

    public UpdateIssueParams actualHours(BigDecimal actualHours) {
        if (actualHours == null) {
            this.parameters.add(new NameValuePair("actualHours", ""));
        } else {
            this.parameters.add(new NameValuePair("actualHours", actualHours.setScale(2, 4).toPlainString()));
        }
        return this;
    }

    public UpdateIssueParams issueTypeId(Object issueTypeId) {
        this.parameters.add(new NameValuePair("issueTypeId", issueTypeId.toString()));
        return this;
    }

    public UpdateIssueParams categoryIds(List categoryIds) {
        if (categoryIds == null) {
            this.parameters.add(new NameValuePair("categoryId[]", ""));
        } else {
            for (Object categoryId : categoryIds) {
                this.parameters.add(new NameValuePair("categoryId[]", categoryId.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams versionIds(List versionIds) {
        if (versionIds == null) {
            this.parameters.add(new NameValuePair("versionId[]", ""));
        } else {
            for (Object versionId : versionIds) {
                this.parameters.add(new NameValuePair("versionId[]", versionId.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams milestoneIds(List milestoneIds) {
        if (milestoneIds == null) {
            this.parameters.add(new NameValuePair("milestoneId[]", ""));
        } else {
            for (Object milestoneId : milestoneIds) {
                this.parameters.add(new NameValuePair("milestoneId[]", milestoneId.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams priority(Issue.PriorityType priority) {
        this.parameters.add(new NameValuePair("priorityId", String.valueOf(priority.getIntValue())));
        return this;
    }

    public UpdateIssueParams assigneeId(Integer assigneeId) {
        return this.assigneeId(new Long(assigneeId.intValue()));
    }

    public UpdateIssueParams assigneeId(Long assigneeId) {
        String assigneeIdStr = "";
        assigneeIdStr = assigneeId <= 0L ? "" : assigneeId.toString();
        this.parameters.add(new NameValuePair("assigneeId", assigneeIdStr));
        return this;
    }

    public UpdateIssueParams assigneeId(String assigneeId) {
        if (assigneeId.equals("")) {
            return this.assigneeId(0L);
        }
        return this.assigneeId(Long.parseLong(assigneeId));
    }

    public UpdateIssueParams notifiedUserIds(List notifiedUserIds) {
        for (Object notifiedUserId : notifiedUserIds) {
            this.parameters.add(new NameValuePair("notifiedUserId[]", notifiedUserId.toString()));
        }
        return this;
    }

    public UpdateIssueParams attachmentIds(List attachmentIds) {
        for (Object attachmentId : attachmentIds) {
            this.parameters.add(new NameValuePair("attachmentId[]", attachmentId.toString()));
        }
        return this;
    }

    public UpdateIssueParams textCustomField(CustomFiledValue customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + customFieldValue.getCustomFieldId(), customFieldValue.getCustomFieldValue()));
        return this;
    }

    public UpdateIssueParams textCustomFields(List<CustomFiledValue> customFieldValueList) {
        for (CustomFiledValue customFiledValue : customFieldValueList) {
            this.textCustomField(customFiledValue);
        }
        return this;
    }

    public UpdateIssueParams textAreaCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public UpdateIssueParams textAreaCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public UpdateIssueParams numericCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public UpdateIssueParams numericCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public UpdateIssueParams dateCustomField(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public UpdateIssueParams dateCustomFields(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public UpdateIssueParams singleListCustomField(CustomFiledItem customFiledItem) {
        this.parameters.add(new NameValuePair("customField_" + customFiledItem.getCustomFieldId(), customFiledItem.getCustomFieldItemId()));
        return this;
    }

    public UpdateIssueParams singleListCustomFields(List<CustomFiledItem> customFiledItemList) {
        for (CustomFiledItem customFiledItem : customFiledItemList) {
            this.singleListCustomField(customFiledItem);
        }
        return this;
    }

    public UpdateIssueParams radioCustomField(CustomFiledItem customFiledItem) {
        return this.singleListCustomField(customFiledItem);
    }

    public UpdateIssueParams radioCustomFields(List<CustomFiledItem> customFiledItemList) {
        return this.singleListCustomFields(customFiledItemList);
    }

    public UpdateIssueParams multipleListCustomField(CustomFiledItems customFiledItems) {
        for (String id : customFiledItems.getCustomFieldItemIds()) {
            this.parameters.add(new NameValuePair("customField_" + customFiledItems.getCustomFieldId(), id.toString()));
        }
        return this;
    }

    public UpdateIssueParams multipleListCustomFields(List<CustomFiledItems> customFiledItemsList) {
        for (CustomFiledItems customFiledItems : customFiledItemsList) {
            this.multipleListCustomField(customFiledItems);
        }
        return this;
    }

    public UpdateIssueParams checkBoxCustomField(CustomFiledItems customFiledItems) {
        return this.multipleListCustomField(customFiledItems);
    }

    public UpdateIssueParams checkBoxCustomFields(List<CustomFiledItems> customFiledItemsList) {
        return this.multipleListCustomFields(customFiledItemsList);
    }

    public UpdateIssueParams customFieldOtherValue(CustomFiledValue customFieldValue) {
        return this.textCustomField(customFieldValue);
    }

    public UpdateIssueParams customFieldOtherValues(List<CustomFiledValue> customFieldValueList) {
        return this.textCustomFields(customFieldValueList);
    }

    public UpdateIssueParams comment(String comment) {
        this.parameters.add(new NameValuePair("comment", comment));
        return this;
    }

    public UpdateIssueParams textCustomField(long customFieldId, String customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldValue)));
        return this;
    }

    public UpdateIssueParams textCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key)));
        }
        return this;
    }

    public UpdateIssueParams textAreaCustomField(long customFieldId, String customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldValue)));
        return this;
    }

    public UpdateIssueParams textAreaCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key)));
        }
        return this;
    }

    public UpdateIssueParams numericCustomField(long customFieldId, float customFieldValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), Float.toString(customFieldValue)));
        return this;
    }

    public UpdateIssueParams numericCustomField(long customFieldId, BigDecimal customFieldValue) {
        if (customFieldValue == null) {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), ""));
        } else {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), customFieldValue.setScale(4, 4).toPlainString()));
        }
        return this;
    }

    public UpdateIssueParams numericCustomFieldMap(Map<Long, Float> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), Float.toString(customFieldMap.get(key).floatValue())));
        }
        return this;
    }

    public UpdateIssueParams dateCustomField(long customFieldId, String customFieldValue) {
        if (customFieldValue == null) {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), ""));
        } else {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), customFieldValue));
        }
        return this;
    }

    public UpdateIssueParams dateCustomFieldMap(Map<Long, String> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            String customFieldValue = customFieldMap.get(key);
            if (customFieldValue == null) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), ""));
                continue;
            }
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldValue));
        }
        return this;
    }

    public UpdateIssueParams singleListCustomField(long customFieldId, long customFieldItemId) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldItemId)));
        return this;
    }

    public UpdateIssueParams singleListCustomFieldMap(Map<Long, Long> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key).toString()));
        }
        return this;
    }

    public UpdateIssueParams radioCustomField(long customFieldId, long customFieldItemId) {
        return this.singleListCustomField(customFieldId, customFieldItemId);
    }

    public UpdateIssueParams radioCustomFieldMap(Map<Long, Long> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString(), customFieldMap.get(key).toString()));
        }
        return this;
    }

    public UpdateIssueParams multipleListCustomField(long customFieldId, List<Long> customFieldItemIds) {
        for (Long customFieldItemId : customFieldItemIds) {
            this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId), String.valueOf(customFieldItemId)));
        }
        return this;
    }

    public UpdateIssueParams multipleListCustomFieldMap(Map<Long, List<Long>> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            for (Long value : customFieldMap.get(key)) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), value.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams checkBoxCustomField(long customFieldId, List<Long> customFieldItemIds) {
        return this.multipleListCustomField(customFieldId, customFieldItemIds);
    }

    public UpdateIssueParams checkBoxCustomFieldMap(Map<Long, List<Long>> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            for (Long value : customFieldMap.get(key)) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), value.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams listCustomFieldMap(Map<Long, List<Long>> customFieldMap) {
        Set<Long> keySet = customFieldMap.keySet();
        for (Long key : keySet) {
            for (Long value : customFieldMap.get(key)) {
                this.parameters.add(new NameValuePair("customField_" + key.toString(), value.toString()));
            }
        }
        return this;
    }

    public UpdateIssueParams customFieldOtherValue(long customFieldId, String otherValue) {
        this.parameters.add(new NameValuePair("customField_" + String.valueOf(customFieldId) + "_otherValue", otherValue));
        return this;
    }

    public UpdateIssueParams customFieldOtherValueMap(Map<Long, String> customFieldOtherValueMap) {
        Set<Long> keySet = customFieldOtherValueMap.keySet();
        for (Long key : keySet) {
            this.parameters.add(new NameValuePair("customField_" + key.toString() + "_otherValue", customFieldOtherValueMap.get(key)));
        }
        return this;
    }
}

