/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.auth;

import com.nulabinc.backlog4j.BacklogAPIException;
import com.nulabinc.backlog4j.BacklogAuthException;
import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.auth.AccessToken;
import com.nulabinc.backlog4j.auth.OAuthSupport;
import com.nulabinc.backlog4j.auth.OnAccessTokenRefreshListener;
import com.nulabinc.backlog4j.conf.BacklogConfigure;
import com.nulabinc.backlog4j.http.BacklogHttpClient;
import com.nulabinc.backlog4j.http.BacklogHttpClientImpl;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import com.nulabinc.backlog4j.http.NameValuePair;
import com.nulabinc.backlog4j.internal.InternalFactory;
import com.nulabinc.backlog4j.internal.json.InternalFactoryJSONImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class BacklogOAuthSupport
implements OAuthSupport {
    private String clientId;
    private String clientSecret;
    private String redirectUrl;
    private BacklogConfigure configure;
    private BacklogHttpClient httpClient;
    private InternalFactory factory = new InternalFactoryJSONImpl();
    private OnAccessTokenRefreshListener listener;

    public BacklogOAuthSupport(BacklogConfigure configure) {
        this.configure = configure;
        this.httpClient = new BacklogHttpClientImpl();
        this.init();
    }

    public BacklogOAuthSupport(BacklogConfigure configure, BacklogHttpClient httpClient) {
        this.configure = configure;
        this.httpClient = httpClient;
        this.init();
    }

    private void init() {
        this.httpClient.setReadTimeout(this.configure.getReadTimeout());
        this.httpClient.setConnectionTimeout(this.configure.getConnectionTimeout());
    }

    @Override
    public void setOAuthClientId(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public void setOAuthRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String getOAuthAuthorizationURL() throws BacklogException {
        String url = this.configure.getOAuthAuthorizationURL() + "?client_id=" + this.clientId + "&response_type=code";
        if (this.redirectUrl != null) {
            try {
                url = url + "&redirect_uri=" + URLEncoder.encode(this.redirectUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BacklogAPIException(e);
            }
        }
        return url;
    }

    @Override
    public AccessToken getOAuthAccessToken(String oauthCode) throws BacklogException {
        if (oauthCode == null) {
            throw new IllegalArgumentException("oauthCode must not be null");
        }
        BacklogHttpResponse httpResponse = this.getAccessTokenResponse(oauthCode);
        this.checkError(httpResponse);
        return this.factory.createAccessToken(httpResponse);
    }

    @Override
    public AccessToken refreshOAuthAccessToken() throws BacklogException {
        if (this.configure.getAccessToken() == null) {
            throw new IllegalArgumentException("AccessToken must not be null");
        }
        BacklogHttpResponse httpResponse = this.getRefreshTokenResponse();
        this.checkError(httpResponse);
        AccessToken accessToken = this.factory.createAccessToken(httpResponse);
        this.configure.accessToken(accessToken);
        this.listener.onAccessTokenRefresh(accessToken);
        return accessToken;
    }

    @Override
    public void setOnAccessTokenRefreshListener(OnAccessTokenRefreshListener listener) {
        this.listener = listener;
    }

    private BacklogHttpResponse getAccessTokenResponse(String oauthCode) throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("code", oauthCode));
        params.add(new NameValuePair("client_id", this.clientId));
        params.add(new NameValuePair("client_secret", this.clientSecret));
        params.add(new NameValuePair("redirect_uri", this.redirectUrl));
        params.add(new NameValuePair("grant_type", "authorization_code"));
        BacklogHttpResponse ires = this.httpClient.post(this.configure.getOAuthAccessTokenURL(), params, new ArrayList<NameValuePair>());
        this.checkError(ires);
        return ires;
    }

    private BacklogHttpResponse getRefreshTokenResponse() throws BacklogException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("client_id", this.clientId));
        params.add(new NameValuePair("client_secret", this.clientSecret));
        params.add(new NameValuePair("refresh_token", this.configure.getAccessToken().getRefresh()));
        params.add(new NameValuePair("grant_type", "refresh_token"));
        BacklogHttpResponse ires = this.httpClient.post(this.configure.getOAuthAccessTokenURL(), params, new ArrayList<NameValuePair>());
        this.checkError(ires);
        return ires;
    }

    private void checkError(BacklogHttpResponse ires) {
        if (ires.getStatusCode() != 200 && ires.getStatusCode() != 201) {
            throw new BacklogAuthException("backlog oauth request failed.", ires);
        }
    }
}

