/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.core;

import java.util.NoSuchElementException;

public class Optional<T> {
    private T value;

    private Optional(T value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean nonEmpty() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static <T> Optional<T> empty() {
        return Optional.of(null);
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }
}

