/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.http;

import com.nulabinc.backlog4j.AttachmentData;
import com.nulabinc.backlog4j.BacklogAPIException;
import com.nulabinc.backlog4j.BacklogException;
import com.nulabinc.backlog4j.api.option.GetParams;
import com.nulabinc.backlog4j.api.option.QueryParams;
import com.nulabinc.backlog4j.http.BacklogHttpClient;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import com.nulabinc.backlog4j.http.BacklogHttpResponseImpl;
import com.nulabinc.backlog4j.http.NameValuePair;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class BacklogHttpClientImpl
implements BacklogHttpClient {
    protected static final String CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    protected static final String CHARSET = "UTF-8";
    protected static final String LINE_FEED = "\r\n";
    protected static final String PACKAGE_VERSION = BacklogHttpClientImpl.class.getPackage().getImplementationVersion();
    protected static final String DEFAULT_USER_AGENT = "backlog4j/" + PACKAGE_VERSION;
    protected String userAgent = DEFAULT_USER_AGENT;
    protected String apiKey;
    protected String bearerToken;
    protected int readTimeout;
    protected int connectionTimeout;

    public BacklogHttpClientImpl() {
        final String proxyUser = System.getProperty("https.proxyUser");
        final String proxyPass = System.getProperty("https.proxyPassword");
        if (proxyUser != null && proxyPass != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                }
            });
        }
    }

    @Override
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public BacklogHttpResponse get(String endpoint, GetParams getParams, QueryParams queryParams) throws BacklogException {
        boolean paramExists;
        String url = this.getUrl(endpoint);
        boolean bl = paramExists = this.apiKey != null;
        if (getParams != null && getParams.getParamList().size() > 0) {
            url = url + this.getParamsString(paramExists, getParams);
            paramExists = true;
        }
        if (queryParams != null && queryParams.getParamList().size() > 0) {
            url = url + this.getParamsString(paramExists, queryParams);
        }
        HttpURLConnection urlConnection = this.openUrlConnection(url, "GET", CONTENT_TYPE);
        return this.handleResponse(urlConnection);
    }

    public String getParamsString(boolean paramExists, GetParams getParams) {
        StringBuffer sb = new StringBuffer();
        if (!paramExists) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(this.getDataString(getParams.getParamList()));
        return sb.toString();
    }

    @Override
    public BacklogHttpResponse post(String endpoint, List<NameValuePair> postParams, List<NameValuePair> headers) throws BacklogException {
        String url = this.getUrl(endpoint);
        HttpURLConnection urlConnection = this.openUrlConnection(url, "POST", CONTENT_TYPE);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        this.setHeaders(urlConnection, headers);
        this.writeParams(urlConnection, postParams);
        return this.handleResponse(urlConnection);
    }

    @Override
    public BacklogHttpResponse patch(String endpoint, List<NameValuePair> patchParams, List<NameValuePair> headers) throws BacklogException {
        String url = this.getUrl(endpoint);
        HttpURLConnection urlConnection = this.openUrlConnection(url, "PATCH", CONTENT_TYPE);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        this.setHeaders(urlConnection, headers);
        this.writeParams(urlConnection, patchParams);
        return this.handleResponse(urlConnection);
    }

    @Override
    public BacklogHttpResponse put(String endpoint, List<NameValuePair> patchParams) throws BacklogException {
        String url = this.getUrl(endpoint);
        HttpURLConnection urlConnection = this.openUrlConnection(url, "PUT", CONTENT_TYPE);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        this.writeParams(urlConnection, patchParams);
        return this.handleResponse(urlConnection);
    }

    @Override
    public BacklogHttpResponse delete(String endpoint, List<NameValuePair> params) throws BacklogException {
        String url = this.getUrl(endpoint);
        HttpURLConnection urlConnection = this.openUrlConnection(url, "DELETE", CONTENT_TYPE);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        this.writeParams(urlConnection, params);
        return this.handleResponse(urlConnection);
    }

    @Override
    public BacklogHttpResponse postMultiPart(String endpoint, Map<String, Object> postParams) throws BacklogException {
        String url = this.getUrl(endpoint);
        String boundary = "*******";
        HttpURLConnection urlConnection = this.openUrlConnection(url, "POST", "multipart/form-data; boundary=" + boundary);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        this.writeMultiPartParams(urlConnection, postParams, boundary);
        return this.handleResponse(urlConnection);
    }

    private String getUrl(String endpoint) {
        if (this.apiKey != null) {
            return endpoint + "?apiKey=" + this.apiKey;
        }
        return endpoint;
    }

    private HttpURLConnection openUrlConnection(String url, String method, String contentType) {
        HttpURLConnection urlConnection;
        try {
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Connection", "Keep-Alive");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            this.setRequestMethodUsingWorkaroundForJREBug(urlConnection, method);
            urlConnection.setReadTimeout(this.readTimeout);
            urlConnection.setConnectTimeout(this.connectionTimeout);
            urlConnection.setRequestProperty("User-Agent", this.userAgent);
            urlConnection.setRequestProperty("Content-Type", contentType);
            if (this.apiKey == null && this.bearerToken != null) {
                urlConnection.setRequestProperty("Authorization", "Bearer " + this.bearerToken);
            }
        }
        catch (IOException e) {
            throw new BacklogAPIException(e);
        }
        return urlConnection;
    }

    private void writeParams(HttpURLConnection urlConnection, List<NameValuePair> params) {
        if (params == null || params.size() == 0) {
            return;
        }
        String query = this.getDataString(params);
        try {
            BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            ((OutputStream)out).write(query.getBytes(CHARSET));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new BacklogAPIException(e);
        }
    }

    private void writeMultiPartParams(HttpURLConnection urlConnection, Map<String, Object> params, String boundary) {
        if (params == null || params.size() == 0) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, CHARSET)));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    writer.append("--" + boundary).append(LINE_FEED);
                    writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
                    writer.append("Content-Type: text/plain; charset=UTF-8").append(LINE_FEED);
                    writer.append(LINE_FEED);
                    writer.append((String)value).append(LINE_FEED);
                    writer.flush();
                    continue;
                }
                if (value instanceof AttachmentData) {
                    AttachmentData attachmentData = (AttachmentData)value;
                    String fileName = attachmentData.getFilename();
                    writer.append("--" + boundary).append(LINE_FEED);
                    writer.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
                    writer.append("Content-Type: application/octet-stream; charset=UTF-8").append(LINE_FEED);
                    writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
                    writer.append(LINE_FEED);
                    writer.flush();
                    InputStream inputStream = attachmentData.getContent();
                    byte[] buffer = new byte[4096];
                    int bytesRead = -1;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    ((OutputStream)out).flush();
                    inputStream.close();
                    writer.flush();
                    continue;
                }
                throw new BacklogAPIException("Illegal parameter type name=" + name + ",value=" + value);
            }
            writer.append(LINE_FEED).flush();
            writer.append("--" + boundary + "--").append(LINE_FEED);
            writer.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new BacklogAPIException(e);
        }
    }

    private String getDataString(List<NameValuePair> pairs) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (NameValuePair pair : pairs) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            try {
                sb.append(URLEncoder.encode(pair.getName(), "utf-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(pair.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new BacklogAPIException(e);
            }
        }
        return sb.toString();
    }

    private void setRequestMethodUsingWorkaroundForJREBug(HttpURLConnection httpURLConnection, String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            Class<?> connectionClass = httpURLConnection.getClass();
            Field delegateField = null;
            try {
                delegateField = connectionClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                HttpURLConnection delegateConnection = (HttpURLConnection)delegateField.get(httpURLConnection);
                this.setRequestMethodUsingWorkaroundForJREBug(delegateConnection, method);
            }
            catch (NoSuchFieldException delegateConnection) {
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            try {
                while (connectionClass != null) {
                    Field methodField;
                    try {
                        methodField = connectionClass.getDeclaredField("method");
                    }
                    catch (NoSuchFieldException e) {
                        connectionClass = connectionClass.getSuperclass();
                        continue;
                    }
                    methodField.setAccessible(true);
                    methodField.set(httpURLConnection, method);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setHeaders(HttpURLConnection connection, List<NameValuePair> headers) {
        if (headers != null) {
            for (NameValuePair pair : headers) {
                connection.setRequestProperty(pair.getName(), pair.getValue());
            }
        }
    }

    private BacklogHttpResponse handleResponse(HttpURLConnection connection) {
        BacklogHttpResponseImpl response = new BacklogHttpResponseImpl(connection);
        return response;
    }
}

