/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.http;

import com.nulabinc.backlog4j.BacklogAPIException;
import com.nulabinc.backlog4j.http.BacklogHttpResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class BacklogHttpResponseImpl
implements BacklogHttpResponse {
    protected HttpURLConnection urlConnection;
    protected InputStream inputStream;
    protected int statusCode;
    protected String responseAsString = null;
    protected int rateLimitLimit;
    protected int rateLimitRemaining;
    protected Date rateLimitResetDate = null;
    protected String rateLimitReset = null;

    public BacklogHttpResponseImpl(HttpURLConnection urlConnection) {
        try {
            this.urlConnection = urlConnection;
            this.statusCode = urlConnection.getResponseCode();
            this.inputStream = this.statusCode < 400 ? new BufferedInputStream(urlConnection.getInputStream()) : new BufferedInputStream(urlConnection.getErrorStream());
            try {
                this.rateLimitLimit = Integer.parseInt(urlConnection.getHeaderField("X-RateLimit-Limit"));
                this.rateLimitRemaining = Integer.parseInt(urlConnection.getHeaderField("X-RateLimit-Remaining"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rateLimitReset = urlConnection.getHeaderField("X-RateLimit-Reset");
            this.setRateLimitResetDate(this.rateLimitReset);
        }
        catch (IOException e) {
            this.inputStream = new BufferedInputStream(urlConnection.getErrorStream());
        }
    }

    @Override
    public int getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    @Override
    public int getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    @Override
    public String getRateLimitReset() {
        return this.rateLimitReset;
    }

    private void setRateLimitResetDate(String rateLimitReset) {
        if (StringUtils.isBlank((CharSequence)rateLimitReset)) {
            return;
        }
        try {
            this.rateLimitResetDate = new Date(Long.parseLong(rateLimitReset) * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Date getRateLimitResetDate() {
        return this.rateLimitResetDate;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public InputStream asInputStream() {
        return this.inputStream;
    }

    @Override
    public String asString() {
        if (this.responseAsString == null && this.inputStream != null) {
            this.responseAsString = this.convertStreamToString();
        }
        return this.responseAsString;
    }

    private String convertStreamToString() {
        BufferedReader reader = null;
        StringBuilder sb = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.inputStream, "utf-8"));
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BacklogAPIException(e);
        }
        catch (IOException e) {
            throw new BacklogAPIException(e);
        }
        finally {
            try {
                this.inputStream.close();
                reader.close();
            }
            catch (IOException e) {
                throw new BacklogAPIException(e);
            }
        }
        return sb.toString();
    }

    @Override
    public String getFileNameFromContentDisposition() {
        String disposition = this.urlConnection.getHeaderField("Content-Disposition");
        if (disposition != null) {
            String encode = disposition.substring(disposition.indexOf("=") + 1, disposition.indexOf("''"));
            String fileName = disposition.substring(disposition.indexOf("''") + 2);
            if (encode != null) {
                try {
                    return URLDecoder.decode(fileName, encode);
                }
                catch (UnsupportedEncodingException e) {
                    throw new BacklogAPIException(e);
                }
            }
            return fileName;
        }
        return null;
    }
}

