/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentJSONImpl
implements Attachment {
    private long id;
    private String name;
    private long size;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isImage() {
        String lowerCase = this.name.toLowerCase();
        return lowerCase.endsWith(".jpg") || lowerCase.endsWith(".jpeg") || lowerCase.endsWith(".png") || lowerCase.endsWith(".gif");
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AttachmentJSONImpl rhs = (AttachmentJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append((Object)this.name, (Object)rhs.name).append(this.size, rhs.size).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.name).append(this.size).append((Object)this.createdUser).append((Object)this.created).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("name", (Object)this.name).append("size", this.size).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).toString();
    }
}

