/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.Category;
import com.nulabinc.backlog4j.CustomField;
import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.IssueType;
import com.nulabinc.backlog4j.Milestone;
import com.nulabinc.backlog4j.Priority;
import com.nulabinc.backlog4j.Resolution;
import com.nulabinc.backlog4j.SharedFile;
import com.nulabinc.backlog4j.Star;
import com.nulabinc.backlog4j.Status;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.Version;
import com.nulabinc.backlog4j.internal.json.AttachmentJSONImpl;
import com.nulabinc.backlog4j.internal.json.CategoryJSONImpl;
import com.nulabinc.backlog4j.internal.json.IssueTypeJSONImpl;
import com.nulabinc.backlog4j.internal.json.JacksonCustomBigdecimalDeserializer;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.MilestoneJSONImpl;
import com.nulabinc.backlog4j.internal.json.PriorityJSONImpl;
import com.nulabinc.backlog4j.internal.json.ResolutionJSONImpl;
import com.nulabinc.backlog4j.internal.json.SharedFileJSONImpl;
import com.nulabinc.backlog4j.internal.json.StarJSONImpl;
import com.nulabinc.backlog4j.internal.json.StatusJSONImpl;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import com.nulabinc.backlog4j.internal.json.VersionJSONImpl;
import com.nulabinc.backlog4j.internal.json.customFields.CustomFieldJSONImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IssueJSONImpl
implements Issue {
    private int id;
    private String issueKey;
    private int keyId;
    private int projectId;
    @JsonDeserialize(as=IssueTypeJSONImpl.class)
    private IssueType issueType;
    private String summary;
    private String description;
    @JsonDeserialize(as=ResolutionJSONImpl.class)
    private Resolution resolution;
    @JsonDeserialize(as=PriorityJSONImpl.class)
    private Priority priority;
    @JsonDeserialize(as=StatusJSONImpl.class)
    private Status status;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User assignee;
    @JsonDeserialize(as=CategoryJSONImpl[].class)
    private Category[] category;
    @JsonDeserialize(as=VersionJSONImpl[].class)
    private Version[] versions;
    @JsonDeserialize(as=MilestoneJSONImpl[].class)
    private Milestone[] milestone;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date startDate;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date dueDate;
    @JsonDeserialize(using=JacksonCustomBigdecimalDeserializer.class)
    private BigDecimal estimatedHours;
    @JsonDeserialize(using=JacksonCustomBigdecimalDeserializer.class)
    private BigDecimal actualHours;
    private long parentIssueId;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User updatedUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date updated;
    @JsonDeserialize(as=CustomFieldJSONImpl[].class)
    private CustomField[] customFields;
    @JsonDeserialize(as=AttachmentJSONImpl[].class)
    private Attachment[] attachments;
    @JsonDeserialize(as=SharedFileJSONImpl[].class)
    private SharedFile[] sharedFiles;
    @JsonDeserialize(as=StarJSONImpl[].class)
    private Star[] stars;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public String getIssueKey() {
        return this.issueKey;
    }

    @Override
    public long getKeyId() {
        return this.keyId;
    }

    @Override
    public String getKeyIdAsString() {
        return String.valueOf(this.keyId);
    }

    @Override
    public long getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectIdAsString() {
        return String.valueOf(this.projectId);
    }

    @Override
    public IssueType getIssueType() {
        return this.issueType;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Resolution getResolution() {
        return this.resolution;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public User getAssignee() {
        return this.assignee;
    }

    @Override
    public List<Category> getCategory() {
        if (this.category == null || this.category.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.category);
    }

    @Override
    public List<Version> getVersions() {
        if (this.versions == null || this.versions.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.versions);
    }

    @Override
    public List<Milestone> getMilestone() {
        if (this.milestone == null || this.milestone.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.milestone);
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public BigDecimal getEstimatedHours() {
        return this.estimatedHours;
    }

    @Override
    public BigDecimal getActualHours() {
        return this.actualHours;
    }

    @Override
    public long getParentIssueId() {
        return this.parentIssueId;
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUpdatedUser() {
        return this.updatedUser;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public List<CustomField> getCustomFields() {
        if (this.customFields == null || this.customFields.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.customFields);
    }

    @Override
    public List<Attachment> getAttachments() {
        if (this.attachments == null || this.attachments.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.attachments);
    }

    @Override
    public List<SharedFile> getSharedFiles() {
        if (this.sharedFiles == null || this.sharedFiles.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.sharedFiles);
    }

    @Override
    public List<Star> getStars() {
        if (this.stars == null || this.stars.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.stars);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IssueJSONImpl rhs = (IssueJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append((Object)this.issueKey, (Object)rhs.issueKey).append(this.keyId, rhs.keyId).append(this.projectId, rhs.projectId).append((Object)this.issueType, (Object)rhs.issueType).append((Object)this.summary, (Object)rhs.summary).append((Object)this.description, (Object)rhs.description).append((Object)this.resolution, (Object)rhs.resolution).append((Object)this.priority, (Object)rhs.priority).append((Object)this.status, (Object)rhs.status).append((Object)this.assignee, (Object)rhs.assignee).append((Object[])this.category, (Object[])rhs.category).append((Object[])this.versions, (Object[])rhs.versions).append((Object[])this.milestone, (Object[])rhs.milestone).append((Object)this.startDate, (Object)rhs.startDate).append((Object)this.dueDate, (Object)rhs.dueDate).append((Object)this.estimatedHours, (Object)rhs.estimatedHours).append((Object)this.actualHours, (Object)rhs.actualHours).append(this.parentIssueId, rhs.parentIssueId).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).append((Object)this.updatedUser, (Object)rhs.updatedUser).append((Object)this.updated, (Object)rhs.updated).append((Object[])this.customFields, (Object[])rhs.customFields).append((Object[])this.attachments, (Object[])rhs.attachments).append((Object[])this.sharedFiles, (Object[])rhs.sharedFiles).append((Object[])this.stars, (Object[])rhs.stars).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.issueKey).append(this.keyId).append(this.projectId).append((Object)this.issueType).append((Object)this.summary).append((Object)this.description).append((Object)this.resolution).append((Object)this.priority).append((Object)this.status).append((Object)this.assignee).append((Object[])this.category).append((Object[])this.versions).append((Object[])this.milestone).append((Object)this.startDate).append((Object)this.dueDate).append((Object)this.estimatedHours).append((Object)this.actualHours).append(this.parentIssueId).append((Object)this.createdUser).append((Object)this.created).append((Object)this.updatedUser).append((Object)this.updated).append((Object[])this.customFields).append((Object[])this.attachments).append((Object[])this.sharedFiles).append((Object[])this.stars).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("issueKey", (Object)this.issueKey).append("keyId", this.keyId).append("projectId", this.projectId).append("issueType", (Object)this.issueType).append("summary", (Object)this.summary).append("description", (Object)this.description).append("resolution", (Object)this.resolution).append("priority", (Object)this.priority).append("status", (Object)this.status).append("assignee", (Object)this.assignee).append("category", (Object[])this.category).append("versions", (Object[])this.versions).append("milestone", (Object[])this.milestone).append("startDate", (Object)this.startDate).append("dueDate", (Object)this.dueDate).append("estimatedHours", (Object)this.estimatedHours).append("actualHours", (Object)this.actualHours).append("parentIssueId", this.parentIssueId).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).append("updatedUser", (Object)this.updatedUser).append("updated", (Object)this.updated).append("customFields", (Object[])this.customFields).append("attachments", (Object[])this.attachments).append("sharedFiles", (Object[])this.sharedFiles).append("stars", (Object[])this.stars).toString();
    }
}

