/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JacksonCustomDateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jsonparser, DeserializationContext deserializationcontext) throws IOException, JsonProcessingException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = jsonparser.getText();
        if (date == null || date.equals("null")) {
            return null;
        }
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

