/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.Issue;
import com.nulabinc.backlog4j.PullRequest;
import com.nulabinc.backlog4j.PullRequestStatus;
import com.nulabinc.backlog4j.Star;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.internal.json.AttachmentJSONImpl;
import com.nulabinc.backlog4j.internal.json.IssueJSONImpl;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.PullRequestStatusJSONImpl;
import com.nulabinc.backlog4j.internal.json.StarJSONImpl;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PullRequestJSONImpl
implements PullRequest {
    private int id;
    private long projectId;
    private long repositoryId;
    private long number;
    private String summary;
    private String description;
    private String base;
    private String branch;
    @JsonDeserialize(as=PullRequestStatusJSONImpl.class)
    private PullRequestStatus status;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User assignee;
    @JsonDeserialize(as=IssueJSONImpl.class)
    private Issue issue;
    private String mergeCommit;
    private String baseCommit;
    private String branchCommit;
    private String closeAt;
    private String mergeAt;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User updatedUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date updated;
    @JsonDeserialize(as=AttachmentJSONImpl[].class)
    private Attachment[] attachments;
    @JsonDeserialize(as=StarJSONImpl[].class)
    private Star[] stars;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public long getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectIdAsString() {
        return String.valueOf(this.projectId);
    }

    @Override
    public long getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public String getRepositoryIdAsString() {
        return String.valueOf(this.repositoryId);
    }

    @Override
    public long getNumber() {
        return this.number;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getBase() {
        return this.base;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public PullRequestStatus getStatus() {
        return this.status;
    }

    @Override
    public User getAssignee() {
        return this.assignee;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public String getMergeCommit() {
        return this.mergeCommit;
    }

    @Override
    public String getBaseCommit() {
        return this.baseCommit;
    }

    @Override
    public String getBranchCommit() {
        return this.branchCommit;
    }

    @Override
    public String getCloseAt() {
        return this.closeAt;
    }

    @Override
    public String getMergeAt() {
        return this.mergeAt;
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUpdatedUser() {
        return this.updatedUser;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public List<Attachment> getAttachments() {
        if (this.attachments == null || this.attachments.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.attachments);
    }

    @Override
    public List<Star> getStars() {
        if (this.stars == null || this.stars.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.stars);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PullRequestJSONImpl rhs = (PullRequestJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append(this.projectId, rhs.projectId).append(this.repositoryId, rhs.repositoryId).append(this.number, rhs.number).append((Object)this.summary, (Object)rhs.summary).append((Object)this.description, (Object)rhs.description).append((Object)this.base, (Object)rhs.base).append((Object)this.branch, (Object)rhs.branch).append((Object)this.status, (Object)rhs.status).append((Object)this.assignee, (Object)rhs.assignee).append((Object)this.issue, (Object)rhs.issue).append((Object)this.mergeCommit, (Object)rhs.mergeCommit).append((Object)this.baseCommit, (Object)rhs.baseCommit).append((Object)this.branchCommit, (Object)rhs.branchCommit).append((Object)this.closeAt, (Object)rhs.closeAt).append((Object)this.mergeAt, (Object)rhs.mergeAt).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).append((Object)this.updatedUser, (Object)rhs.updatedUser).append((Object)this.updated, (Object)rhs.updated).append((Object[])this.attachments, (Object[])rhs.attachments).append((Object[])this.stars, (Object[])rhs.stars).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.projectId).append(this.repositoryId).append(this.number).append((Object)this.summary).append((Object)this.description).append((Object)this.base).append((Object)this.branch).append((Object)this.status).append((Object)this.assignee).append((Object)this.issue).append((Object)this.mergeCommit).append((Object)this.baseCommit).append((Object)this.branchCommit).append((Object)this.closeAt).append((Object)this.mergeAt).append((Object)this.createdUser).append((Object)this.created).append((Object)this.updatedUser).append((Object)this.updated).append((Object[])this.attachments).append((Object[])this.stars).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("projectId", this.projectId).append("repositoryId", this.repositoryId).append("number", this.number).append("summary", (Object)this.summary).append("description", (Object)this.description).append("base", (Object)this.base).append("branch", (Object)this.branch).append("status", (Object)this.status).append("assignee", (Object)this.assignee).append("issue", (Object)this.issue).append("mergeCommit", (Object)this.mergeCommit).append("baseCommit", (Object)this.baseCommit).append("branchCommit", (Object)this.branchCommit).append("closeAt", (Object)this.closeAt).append("mergeAt", (Object)this.mergeAt).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).append("updatedUser", (Object)this.updatedUser).append("updated", (Object)this.updated).append("attachments", (Object[])this.attachments).append("stars", (Object[])this.stars).toString();
    }
}

