/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.SharedFile;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SharedFileJSONImpl
implements SharedFile {
    private long id;
    private String type;
    private String name;
    private String dir;
    private long size;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User updatedUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date updated;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isImage() {
        String lowerCase = this.name.toLowerCase();
        return lowerCase.endsWith(".jpg") || lowerCase.endsWith(".jpeg") || lowerCase.endsWith(".png") || lowerCase.endsWith(".gif");
    }

    @Override
    public String getDir() {
        return this.dir;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUpdatedUser() {
        return this.updatedUser;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SharedFileJSONImpl rhs = (SharedFileJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append((Object)this.type, (Object)rhs.type).append((Object)this.name, (Object)rhs.name).append((Object)this.dir, (Object)rhs.dir).append(this.size, rhs.size).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).append((Object)this.updatedUser, (Object)rhs.updatedUser).append((Object)this.updated, (Object)rhs.updated).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.type).append((Object)this.name).append((Object)this.dir).append(this.size).append((Object)this.createdUser).append((Object)this.created).append((Object)this.updatedUser).append((Object)this.updated).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("type", (Object)this.type).append("name", (Object)this.name).append("dir", (Object)this.dir).append("size", this.size).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).append("updatedUser", (Object)this.updatedUser).append("updated", (Object)this.updated).toString();
    }
}

