/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.Activity;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.Webhook;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WebhookJSONImpl
implements Webhook {
    private long id;
    private String name;
    private String description;
    private String hookUrl;
    private boolean allEvent;
    private int[] activityTypeIds;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User updatedUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date updated;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHookUrl() {
        return this.hookUrl;
    }

    @Override
    public boolean isAllEvent() {
        return this.allEvent;
    }

    @Override
    public List<Activity.Type> getActivityTypeIds() {
        if (this.activityTypeIds == null) {
            return null;
        }
        ArrayList<Activity.Type> typeIds = new ArrayList<Activity.Type>();
        for (int activityTypeId : this.activityTypeIds) {
            typeIds.add(Activity.Type.valueOf(activityTypeId));
        }
        return typeIds;
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUpdatedUser() {
        return this.updatedUser;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WebhookJSONImpl rhs = (WebhookJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append((Object)this.name, (Object)rhs.name).append((Object)this.description, (Object)rhs.description).append((Object)this.hookUrl, (Object)rhs.hookUrl).append(this.allEvent, rhs.allEvent).append(this.activityTypeIds, rhs.activityTypeIds).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).append((Object)this.updatedUser, (Object)rhs.updatedUser).append((Object)this.updated, (Object)rhs.updated).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.name).append((Object)this.description).append((Object)this.hookUrl).append(this.allEvent).append(this.activityTypeIds).append((Object)this.createdUser).append((Object)this.created).append((Object)this.updatedUser).append((Object)this.updated).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("hookUrl", (Object)this.hookUrl).append("allEvent", this.allEvent).append("activityTypeIds", this.activityTypeIds).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).append("updatedUser", (Object)this.updatedUser).append("updated", (Object)this.updated).toString();
    }
}

