/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.backlog4j.internal.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nulabinc.backlog4j.Attachment;
import com.nulabinc.backlog4j.SharedFile;
import com.nulabinc.backlog4j.Star;
import com.nulabinc.backlog4j.User;
import com.nulabinc.backlog4j.Wiki;
import com.nulabinc.backlog4j.WikiTag;
import com.nulabinc.backlog4j.internal.json.AttachmentJSONImpl;
import com.nulabinc.backlog4j.internal.json.JacksonCustomDateDeserializer;
import com.nulabinc.backlog4j.internal.json.SharedFileJSONImpl;
import com.nulabinc.backlog4j.internal.json.StarJSONImpl;
import com.nulabinc.backlog4j.internal.json.UserJSONImpl;
import com.nulabinc.backlog4j.internal.json.WikiTagJSONImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WikiJSONImpl
implements Wiki {
    private long id;
    private long projectId;
    private String name;
    private String content;
    @JsonDeserialize(as=WikiTagJSONImpl[].class)
    private WikiTag[] tags;
    @JsonDeserialize(as=AttachmentJSONImpl[].class)
    private Attachment[] attachments;
    @JsonDeserialize(as=SharedFileJSONImpl[].class)
    private SharedFile[] sharedFiles;
    @JsonDeserialize(as=StarJSONImpl[].class)
    private Star[] stars;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User createdUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date created;
    @JsonDeserialize(as=UserJSONImpl.class)
    private User updatedUser;
    @JsonDeserialize(using=JacksonCustomDateDeserializer.class)
    private Date updated;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public List<WikiTag> getTags() {
        return Arrays.asList(this.tags);
    }

    @Override
    public List<Attachment> getAttachments() {
        return Arrays.asList(this.attachments);
    }

    @Override
    public List<SharedFile> getSharedFiles() {
        return Arrays.asList(this.sharedFiles);
    }

    @Override
    public List<Star> getStars() {
        return Arrays.asList(this.stars);
    }

    @Override
    public long getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectIdAsString() {
        return String.valueOf(this.projectId);
    }

    @Override
    public User getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUpdatedUser() {
        return this.updatedUser;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WikiJSONImpl rhs = (WikiJSONImpl)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append(this.projectId, rhs.projectId).append((Object)this.name, (Object)rhs.name).append((Object)this.content, (Object)rhs.content).append((Object[])this.tags, (Object[])rhs.tags).append((Object[])this.attachments, (Object[])rhs.attachments).append((Object[])this.sharedFiles, (Object[])rhs.sharedFiles).append((Object[])this.stars, (Object[])rhs.stars).append((Object)this.createdUser, (Object)rhs.createdUser).append((Object)this.created, (Object)rhs.created).append((Object)this.updatedUser, (Object)rhs.updatedUser).append((Object)this.updated, (Object)rhs.updated).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.projectId).append((Object)this.name).append((Object)this.content).append((Object[])this.tags).append((Object[])this.attachments).append((Object[])this.sharedFiles).append((Object[])this.stars).append((Object)this.createdUser).append((Object)this.created).append((Object)this.updatedUser).append((Object)this.updated).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("projectId", this.projectId).append("name", (Object)this.name).append("content", (Object)this.content).append("tags", (Object[])this.tags).append("attachments", (Object[])this.attachments).append("sharedFiles", (Object[])this.sharedFiles).append("stars", (Object[])this.stars).append("createdUser", (Object)this.createdUser).append("created", (Object)this.created).append("updatedUser", (Object)this.updatedUser).append("updated", (Object)this.updated).toString();
    }
}

