/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Pattern;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.guesses.EstimateGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Scoring {
    public static final int REFERENCE_YEAR = 2016;
    public static final int MIN_GUESSES_BEFORE_GROWING_SEQUENCE = 10000;

    public static double log10(double n) {
        return Math.log(n) / Math.log(10.0);
    }

    public static Strength mostGuessableMatchSequence(String password, List<Match> matches) {
        return Scoring.mostGuessableMatchSequence(password, matches, false);
    }

    public static Strength mostGuessableMatchSequence(String password, List<Match> matches, boolean excludeAdditive) {
        int n = password.length();
        ArrayList matchesByJ = new ArrayList();
        for (int i = 0; i < n; ++i) {
            matchesByJ.add(new ArrayList());
        }
        for (Match m : matches) {
            ((List)matchesByJ.get(m.j)).add(m);
        }
        Optimal optimal = new Optimal(n);
        for (int k = 0; k < n; ++k) {
            for (Match m : (List)matchesByJ.get(k)) {
                if (m.i > 0) {
                    for (Map.Entry<Integer, Match> entry : optimal.m.get(m.i - 1).entrySet()) {
                        int l = entry.getKey();
                        Scoring.update(password, m, l + 1, optimal, excludeAdditive);
                    }
                    continue;
                }
                Scoring.update(password, m, 1, optimal, excludeAdditive);
            }
            Scoring.bruteforceUpdate(password, k, optimal, excludeAdditive);
        }
        List<Match> optimalMatchSequence = Scoring.unwind(n, optimal);
        double guesses = password.length() == 0 ? 1.0 : optimal.g.get(n - 1);
        Strength strength = new Strength();
        strength.setPassword(password);
        strength.setGuesses(guesses);
        strength.setGuessesLog10(Scoring.log10(guesses));
        strength.setSequence(optimalMatchSequence);
        return strength;
    }

    private static void update(String password, Match m, int l, Optimal optimal, boolean excludeAdditive) {
        int k = m.j;
        double pi = new EstimateGuess(password).exec(m);
        if (l > 1) {
            pi *= optimal.pi.get(m.i - 1).get(l - 1).doubleValue();
        }
        double g = (double)Scoring.factorial(l) * pi;
        if (!excludeAdditive) {
            g += Math.pow(10000.0, l - 1);
        }
        if (g < optimal.g.get(k)) {
            optimal.g.set(k, g);
            optimal.l.set(k, l);
            optimal.m.get(k).put(l, m);
            optimal.pi.get(k).put(l, pi);
        }
    }

    private static void bruteforceUpdate(String password, int k, Optimal optimal, boolean excludeAdditive) {
        Match m = Scoring.makeBruteforceMatch(password, 0, k);
        Scoring.update(password, m, 1, optimal, excludeAdditive);
        if (k == 0) {
            return;
        }
        for (Map.Entry<Integer, Match> entry : optimal.m.get(k - 1).entrySet()) {
            int l = entry.getKey();
            Match last_m = entry.getValue();
            if (last_m.pattern == Pattern.Bruteforce) {
                m = Scoring.makeBruteforceMatch(password, last_m.i, k);
                Scoring.update(password, m, l, optimal, excludeAdditive);
                continue;
            }
            m = Scoring.makeBruteforceMatch(password, k, k);
            Scoring.update(password, m, l + 1, optimal, excludeAdditive);
        }
    }

    private static List<Match> unwind(int n, Optimal optimal) {
        ArrayList<Match> optimalMatchSequence = new ArrayList<Match>();
        int k = n - 1;
        if (0 <= k) {
            int l = optimal.l.get(k);
            while (k >= 0) {
                Match m = optimal.m.get(k).get(l);
                optimalMatchSequence.add(0, m);
                k = m.i - 1;
                --l;
            }
        }
        return optimalMatchSequence;
    }

    private static Match makeBruteforceMatch(String password, int i, int j) {
        return MatchFactory.createBruteforceMatch(i, j, password.substring(i, j + 1));
    }

    private static int factorial(int n) {
        if (n < 2) {
            return 1;
        }
        int f = 1;
        for (int i = 2; i <= n; ++i) {
            f *= i;
        }
        return f;
    }

    private static class Optimal {
        public final List<Map<Integer, Match>> m = new ArrayList<Map<Integer, Match>>();
        public final List<Map<Integer, Double>> pi = new ArrayList<Map<Integer, Double>>();
        public final List<Double> g = new ArrayList<Double>();
        public final List<Integer> l = new ArrayList<Integer>();

        public Optimal(int n) {
            for (int i = 0; i < n; ++i) {
                this.m.add(new HashMap());
                this.pi.add(new HashMap());
                this.g.add(Double.POSITIVE_INFINITY);
                this.l.add(0);
            }
        }
    }
}

