/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.guesses;

import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.guesses.BaseGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import java.util.HashMap;
import java.util.Map;

public class RegexGuess
extends BaseGuess {
    private static final Map<String, Integer> CHAR_CLASS_BASES = new HashMap<String, Integer>();

    @Override
    public double exec(Match match) {
        if (CHAR_CLASS_BASES.containsKey(match.regexName)) {
            return Math.pow(CHAR_CLASS_BASES.get(match.regexName).intValue(), match.tokenLength());
        }
        if ("recent_year".equals(match.regexName)) {
            double yearSpace = Math.abs(RegexGuess.parseInt(match.token) - 2000);
            yearSpace = Math.max(yearSpace, 20.0);
            return yearSpace;
        }
        return 0.0;
    }

    private static final int parseInt(CharSequence s) {
        int result = 0;
        try {
            result = WipeableString.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.out.println(e.getStackTrace());
        }
        return result;
    }

    static {
        CHAR_CLASS_BASES.put("alpha_lower", 26);
        CHAR_CLASS_BASES.put("alpha_upper", 26);
        CHAR_CLASS_BASES.put("alpha", 52);
        CHAR_CLASS_BASES.put("alphanumeric", 62);
        CHAR_CLASS_BASES.put("digits", 10);
        CHAR_CLASS_BASES.put("symbols", 33);
    }
}

