/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.stats.metrics.MetricPointImpl;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.stats.metrics.MetricPoint;
import com.nuodb.stats.metrics.MetricSeries;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MetricSeriesImpl
implements MetricSeries {
    private static final String KV_SEP = ",";
    private static final String MP_SEP = ";";
    private List<MetricPoint> data = new ArrayList<MetricPoint>();
    private String breakdownValue = null;

    public MetricSeriesImpl() {
    }

    public MetricSeriesImpl(List<MetricPoint> data) {
        this.data = data;
    }

    public MetricSeriesImpl(List<MetricPoint> data, String breakdownValue) {
        this.data = data;
        this.breakdownValue = breakdownValue;
    }

    public MetricSeriesImpl(Tag tag) throws XmlException {
        Preconditions.checkArgument("MetricSeries".equals(tag.getName()), "not a MetricSeries tag: %s", tag);
        this.breakdownValue = tag.getAttribute("breakdownValue", null);
        String csv = tag.getAttribute("points", null);
        this.fromCsv(csv);
    }

    private void fromCsv(String csv) {
        StringTokenizer t = new StringTokenizer(csv, MP_SEP);
        while (t.hasMoreElements()) {
            StringTokenizer kv = new StringTokenizer((String)t.nextElement(), KV_SEP);
            long ts = Long.parseLong((String)kv.nextElement());
            double val = Double.parseDouble((String)kv.nextElement());
            this.data.add(new MetricPointImpl(val, ts));
        }
    }

    @Override
    public MetricSeries encode(Tag tag) {
        if (this.breakdownValue != null) {
            tag.addAttribute("breakdownValue", this.breakdownValue);
        }
        tag.addAttribute("points", this.asCsv());
        return this;
    }

    private String asCsv() {
        StringBuffer b = new StringBuffer();
        Iterator<MetricPoint> iter = this.data.iterator();
        MetricPoint mp = null;
        if (iter.hasNext()) {
            mp = iter.next();
        }
        while (mp != null) {
            b.append(mp.getTimestamp()).append(KV_SEP).append(mp.getValue());
            mp = null;
            if (!iter.hasNext()) continue;
            b.append(MP_SEP);
            mp = iter.next();
        }
        return b.toString();
    }

    @Override
    public Tag toTag() {
        Tag t = TagFactory.createTag("MetricSeries");
        this.encode(t);
        return t;
    }

    @Override
    public String getBreakdownValue() {
        return this.breakdownValue;
    }

    @Override
    public MetricSeries setBreakdownValue(String name) {
        this.breakdownValue = name;
        return this;
    }

    @Override
    public List<MetricPoint> getData() {
        return this.data;
    }

    @Override
    public MetricSeries setData(List<MetricPoint> data) {
        this.data = data;
        return this;
    }

    @Override
    public MetricSeries addData(MetricPoint item) {
        this.data.add(item);
        return this;
    }
}

