/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.SocketListener;
import com.nuodb.impl.security.RemotePassword;
import com.nuodb.impl.security.SessionCiphersInfo;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;

public final class AuthUtil {
    private static final Logger logger = Logger.getLogger(AuthUtil.class.getName());
    public static final String CIPHER_RC4 = "RC4";
    public static final String CIPHER_AES256CTR = "AES-256-CTR";
    public static final String DEFAULT_CIPHER = "RC4";
    public static final List<String> SUPPORTED_CIPHERS;
    public static final String SUPPORTED_CIPHERS_CSV;

    public static String selectCipher(String clientCiphers) throws GeneralSecurityException {
        String cipher = AuthUtil.selectCipherOrNull(SUPPORTED_CIPHERS, clientCiphers);
        if (cipher == null) {
            throw new GeneralSecurityException("No common cipher");
        }
        return cipher;
    }

    public static String selectCipherOrNull(List<String> serverCiphers, String clientCiphers) {
        if (clientCiphers == null || clientCiphers.isEmpty()) {
            return "RC4";
        }
        for (String serverCipher : serverCiphers) {
            for (String clientCipher : Arrays.asList(clientCiphers.split(","))) {
                if (!serverCipher.equals(clientCipher)) continue;
                return serverCipher;
            }
        }
        return null;
    }

    public static void initiateAuthorizedSession(SocketListener listener, String serviceName, String authzType) throws IOException {
        Tag tag = TagFactory.createTag("Authorize");
        tag.addAttribute("TargetService", serviceName);
        tag.addAttribute("Type", authzType);
        listener.send(tag);
    }

    public static Tag makeSRPRequestMsg(String username, RemotePassword rp) {
        return AuthUtil.makeSRPRequestMsg(username, rp, SUPPORTED_CIPHERS_CSV);
    }

    public static Tag makeSRPRequestMsg(String username, RemotePassword rp, String ciphers) {
        Tag tag = TagFactory.createTag("SRPRequest");
        tag.addAttribute("ClientKey", rp.genClientKey());
        tag.addAttribute("Cipher", "RC4");
        tag.addAttribute("Username", username);
        tag.addAttribute("Ciphers", ciphers);
        return tag;
    }

    public static Tag makeSRPResponseMsg(String serverKey, String salt, String cipherAlgorithm, byte[] outgoingIV, byte[] incomingIV) {
        Tag tag = TagFactory.createTag("SRPResponse");
        tag.addAttribute("ServerKey", serverKey);
        tag.addAttribute("Salt", salt);
        tag.addAttribute("Cipher", cipherAlgorithm);
        if (outgoingIV != null && incomingIV != null) {
            tag.addAttribute("OutgoingIV", RemotePassword.getHex(outgoingIV));
            tag.addAttribute("IncomingIV", RemotePassword.getHex(incomingIV));
        }
        return tag;
    }

    public static SessionCiphersInfo parseSRPResponse(Tag srpResponse, String username, String password, RemotePassword rp) throws XmlException {
        String cipherName = srpResponse.getAttribute("Cipher", "RC4");
        String outgoingIVString = srpResponse.getAttribute("OutgoingIV", null);
        String incomingIVString = srpResponse.getAttribute("IncomingIV", null);
        byte[] outgoingIV = null;
        byte[] incomingIV = null;
        if (outgoingIVString != null && incomingIVString != null) {
            outgoingIV = RemotePassword.getBytes(outgoingIVString);
            incomingIV = RemotePassword.getBytes(incomingIVString);
        }
        byte[] sessionKey = rp.computeSessionKey(username, password, srpResponse.getAttribute("Salt"), srpResponse.getAttribute("ServerKey"), cipherName);
        return new SessionCiphersInfo(cipherName, sessionKey, outgoingIV, incomingIV);
    }

    public static SessionCiphersInfo runSRPExchange(SocketListener listener, String serviceName, String username, String password) throws IOException {
        AuthUtil.initiateAuthorizedSession(listener, serviceName, "SRP");
        RemotePassword rp = new RemotePassword();
        Tag tag = AuthUtil.makeSRPRequestMsg(username, rp);
        listener.send(tag);
        try {
            tag = listener.getXmlMessage();
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Login credentials were rejected", ioe);
        }
        try {
            return AuthUtil.parseSRPResponse(tag, username, password, rp);
        }
        catch (XmlException e) {
            throw new IOException("Invalid response message", e);
        }
    }

    static {
        LinkedList<String> supportedCiphers = new LinkedList<String>();
        try {
            if (Cipher.getMaxAllowedKeyLength("AES/CTR/NOPADDING") >= 256) {
                supportedCiphers.add(CIPHER_AES256CTR);
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, "No such algorithm: cipherName={0}, error=[{1}]", new Object[]{"AES/CTR/NOPADDING", e.toString()});
        }
        supportedCiphers.add("RC4");
        SUPPORTED_CIPHERS = Collections.unmodifiableList(supportedCiphers);
        StringBuilder builder = new StringBuilder(SUPPORTED_CIPHERS.get(0));
        for (int i = 1; i != SUPPORTED_CIPHERS.size(); ++i) {
            builder.append(',').append(SUPPORTED_CIPHERS.get(i));
        }
        SUPPORTED_CIPHERS_CSV = builder.toString();
    }
}

