/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats;

import com.nuodb.impl.stats.Alarm;
import com.nuodb.impl.stats.AlarmDef;
import com.nuodb.impl.stats.IAverage;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;

public class AlarmWatch
extends Alarm {
    int breachCnt = -1;
    long breachEnd = 0L;
    double breachValue;

    public AlarmWatch(AlarmDef def, String entityId) {
        super(def, entityId);
        Preconditions.checkArgument(!StringUtils.isBlank(entityId), "empty entityId for %s", this);
    }

    public AlarmWatch(Tag t) throws XmlException {
        super(t, new AlarmDef(t.findChild("AlarmDefinition")));
        this.breachValue = Double.parseDouble(t.getAttribute("breachValue", "0"));
        this.breachEnd = t.getLongAttribute("breachEnd", 0L);
        this.breachCnt = t.getIntAttribute("breachCnt", -1);
    }

    public AlarmWatch(AlarmWatch other) {
        this(other.getDef(), other.getEntity());
        Preconditions.checkArgument(other.getSignalTime() > -1L, "AlarmWatch not signaled %s", other);
        this.breachCnt = this.def.getRepeat() == AlarmDef.Repeat.Reset ? -1 : other.getBreachCount();
    }

    @Override
    public Tag toTag() {
        Tag tag = TagFactory.createTag("AlarmWatch");
        this.encode(tag);
        return tag;
    }

    @Override
    public void encode(Tag tag) {
        super.encode(tag);
        tag.addAttribute("breachValue", String.format("%.2f", this.breachValue));
        tag.addAttribute("breachEnd", this.breachEnd);
        tag.addAttribute("breachCnt", this.breachCnt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean evalBreach(Double value) {
        if (value == null) {
            return false;
        }
        if (this.op(value)) {
            ++this.breachCnt;
            if (this.breachCnt != 0) return this.evalEnd(System.currentTimeMillis(), value);
            this.breachEnd = System.currentTimeMillis() + this.def.getBreachDuration();
            return false;
        } else {
            this.breachCnt = -1;
            this.signalTime = -1L;
            this.breachEnd = 0L;
        }
        return false;
    }

    boolean op(Double value) {
        AlarmDef.Operator op = this.def.getOperator();
        double threshold = this.def.getThresold();
        if (op == AlarmDef.Operator.EQ) {
            return this.eq(value);
        }
        if (op == AlarmDef.Operator.GT) {
            return !this.eq(value) && value > threshold;
        }
        if (op == AlarmDef.Operator.GE) {
            return this.eq(value) || value > threshold;
        }
        if (op == AlarmDef.Operator.LT) {
            return !this.eq(value) && value < threshold;
        }
        if (op == AlarmDef.Operator.LE) {
            return this.eq(value) || value < threshold;
        }
        if (op == AlarmDef.Operator.NE) {
            return !this.eq(value);
        }
        throw new IllegalStateException(this.def.getName() + ": unknown operator " + op.name());
    }

    boolean eq(double value) {
        return AlarmWatch.equals(value, this.def.getThresold(), 1.0E-4f);
    }

    public boolean evalBreach(IAverage value) {
        if (value == null) {
            return false;
        }
        return this.evalBreach(this.avgFunc(value));
    }

    double avgFunc(IAverage value) {
        if (this.def.getAggrFunc() == AlarmDef.AggrFunc.Average) {
            return value.getAvg();
        }
        if (this.def.getAggrFunc() == AlarmDef.AggrFunc.Sum) {
            return value.getSum();
        }
        throw new IllegalStateException(this.def.getName() + ": illegal function AggrFunc.None");
    }

    boolean evalEnd(long now, Double value) {
        if (now > this.breachEnd) {
            this.breachValue = value;
            this.signal(now);
            return true;
        }
        return false;
    }

    public boolean isBreach() {
        return this.signalTime > -1L && this.breachCnt > 0;
    }

    public double getBreachValue() {
        return this.breachValue;
    }

    public int getBreachCount() {
        return this.breachCnt;
    }

    public long getBreachEnd() {
        return this.breachEnd;
    }

    @Override
    public String toString() {
        if (this.signalTime > -1L) {
            return String.format("AlarmWatch breach %.2f cnt=%d id=%s entity=[%s] def=[%s]", this.breachValue, this.breachCnt, this.id, this.entityId, this.def);
        }
        return String.format("AlarmWatch id=%s entity=[%s] def=[%s]", this.id, this.entityId, this.def);
    }

    static boolean equals(double x, double y, double eps) {
        return AlarmWatch.equals(x, y) || AlarmWatch.fastAbs(y - x) <= eps;
    }

    static boolean equals(double x, double y) {
        return Double.isNaN(x) && Double.isNaN(y) || x == y;
    }

    static double fastAbs(double x) {
        return x < 0.0 ? -x : (x == 0.0 ? 0.0 : x);
    }
}

