/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.DataSource;
import com.nuodb.jdbc.RemXAConnection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class NuoXADataSource
extends DataSource
implements XADataSource {
    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.url == null) {
            throw new SQLException("Must call setUrl before creating a connection.");
        }
        Properties properties = new Properties();
        if (this.user != null) {
            properties.put("user", this.user);
        }
        if (this.password != null) {
            properties.put("password", this.password);
        }
        if (this.schema != null) {
            properties.put("schema", this.schema);
        }
        if (this.sqlEngine != null) {
            properties.put("SQLEngine", this.sqlEngine);
        }
        return new RemXAConnection(this.url, properties);
    }

    @Override
    public XAConnection getXAConnection(String user, String pwd) throws SQLException {
        if (this.url == null) {
            throw new SQLException("Must call setUrl before creating a connection.");
        }
        Properties properties = new Properties();
        if (user != null) {
            properties.put("user", user);
        }
        if (pwd != null) {
            properties.put("password", pwd);
        }
        if (this.schema != null) {
            properties.put("schema", this.schema);
        }
        if (this.sqlEngine != null) {
            properties.put("SQLEngine", this.sqlEngine);
        }
        return new RemXAConnection(this.url, properties);
    }
}

