/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemResultSet;
import com.nuodb.jdbc.Utils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;

public class RemResultSetMetaData
implements ResultSetMetaData {
    RemConnection connection;
    RemResultSet resultSet;
    int columnCount;
    Column[] columns;
    String[] columnNames;

    RemResultSetMetaData(RemResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.connection = resultSet.getConnection();
        this.columnCount = resultSet.getColumnCount();
        this.columnNames = resultSet.getColumnNames();
    }

    RemResultSetMetaData(EncodedDataStream dataStream) throws SQLException {
        this.connection = null;
        this.resultSet = null;
        this.decodeColumns(dataStream);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumn((int)column).catalogName;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumn((int)column).displaySize;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn((int)column).columnLabel;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn((int)column).columnName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn((int)column).columnType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn((int)column).columnTypeName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn((int)column).precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn((int)column).scale;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumn((int)column).schemaName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumn((int)column).tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 4) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 8) != 0;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x10) != 0;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x20) != 0;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x200) != 0 ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x80) != 0;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 2) != 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x100) != 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return (this.getColumn((int)column).flags & 0x40) != 0;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Utils.notYetImplemented();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    void checkColumn(int column) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw new SQLException(MessageFormat.format("ResultSet column index {0} is out of bounds. Valid range 1-{1}", column, this.columnCount));
        }
    }

    Column getColumn(int column) throws SQLException {
        this.checkColumn(column);
        return this.getColumns()[column - 1];
    }

    void decodeColumns(EncodedDataStream dataStream) throws SQLException {
        this.columnCount = dataStream.getInt();
        this.columns = new Column[this.columnCount];
        for (int n = 0; n < this.columnCount; ++n) {
            this.columns[n] = new Column(dataStream);
        }
    }

    Column[] getColumns() throws SQLException {
        if (this.columns == null && this.resultSet != null && this.connection != null) {
            EncodedDataStream dataStream = new EncodedDataStream();
            dataStream.startMessage(26);
            dataStream.encodeInt(this.resultSet.getHandle());
            this.connection.sendAndReceive(dataStream);
            this.decodeColumns(dataStream);
        }
        return this.columns;
    }

    class Column {
        String catalogName;
        String schemaName;
        String tableName;
        String columnName;
        String columnLabel;
        String collationSequence;
        String columnTypeName;
        int columnType;
        int displaySize;
        int precision;
        int scale;
        int flags;

        Column(EncodedDataStream dataStream) throws SQLException {
            this.catalogName = dataStream.getString();
            this.schemaName = dataStream.getString();
            this.tableName = dataStream.getString();
            this.columnName = dataStream.getString();
            this.columnLabel = dataStream.getString();
            this.collationSequence = dataStream.getString();
            this.columnTypeName = dataStream.getString();
            this.columnType = dataStream.getInt();
            this.displaySize = dataStream.getInt();
            this.precision = dataStream.getInt();
            this.scale = dataStream.getInt();
            this.flags = dataStream.getInt();
        }
    }
}

