/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EmptyResultSet;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemResultSet;
import com.nuodb.jdbc.RemSQLUtils;
import com.nuodb.jdbc.ResourceLock;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.SQLStateException;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.logger.Logger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class RemStatement
implements Statement {
    protected static final long MICROSECONDS_PER_SECOND = 1000000L;
    protected final RemConnection connection;
    protected final Logger logger;
    protected int handle;
    protected int updateCount;
    protected ResultSet generatedKeys;
    protected Collection<String> batchSql;
    protected SQLWarning warnings;
    protected RemResultSet lastResultSet;
    private int maxRows = 0;
    protected int fetchSize = 0;
    private final Collection<RemResultSet> resultSets = new LinkedList<RemResultSet>();
    protected long queryTimeoutMicros;
    private int fetchDirection = 1000;
    private boolean closed;
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private static final AtomicReferenceFieldUpdater<RemStatement, StatementCancelState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RemStatement.class, StatementCancelState.class, "statementState");

    RemStatement(RemConnection connection, int handle) {
        this.connection = connection;
        this.logger = connection.getLogger();
        this.handle = handle;
        this.updateCount = -1;
        this.queryTimeoutMicros = 0L;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Created statement #%d", handle));
        }
    }

    @Override
    public void addBatch(String sql) throws java.sql.SQLException {
        this.checkOpen();
        if (this.batchSql == null) {
            this.batchSql = new LinkedList<String>();
        }
        this.batchSql.add(sql);
    }

    @Override
    public void cancel() throws java.sql.SQLException {
        if (this.statementState == StatementCancelState.IDLE) {
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            return;
        }
        try (ResourceLock connectionLock = this.connection.obtainLock();){
            try {
                this.connection.cancelQuery();
            }
            finally {
                STATE_UPDATER.set(this, StatementCancelState.CANCELLED);
            }
        }
    }

    @Override
    public void clearBatch() throws java.sql.SQLException {
        this.checkOpen();
        if (this.batchSql != null) {
            this.batchSql.clear();
        }
    }

    @Override
    public void clearWarnings() throws java.sql.SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws java.sql.SQLException {
        RemStatement remStatement = this;
        synchronized (remStatement) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.cancel();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Closing statement #%d", this.handle));
        }
        this.closeResultSets();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(15);
        dataStream.encodeInt(this.handle);
        this.connection.sendAsync(dataStream);
        this.connection.statementClosed(this);
    }

    protected void closeResultSets() {
        ArrayList<RemResultSet> resultSetsCopy = new ArrayList<RemResultSet>(this.resultSets);
        this.resultSets.clear();
        for (RemResultSet resultSet : resultSetsCopy) {
            RemSQLUtils.close(resultSet, this.logger);
        }
        this.lastResultSet = null;
    }

    @Override
    public boolean execute(String sql) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(18);
        this.encodeLastTxnIds(dataStream);
        return this.execute(dataStream, sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void communicateWithServer(EncodedDataStream dataStream) throws java.sql.SQLException {
        try {
            STATE_UPDATER.set(this, StatementCancelState.IN_QUERY);
            this.connection.sendAndReceive(dataStream);
        }
        finally {
            if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
                boolean interrupted = false;
                try (ResourceLock connectionLock = this.connection.obtainLock();){
                    while (!STATE_UPDATER.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
                        try {
                            this.connection.lockCondition().await(10L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private boolean execute(EncodedDataStream dataStream, String sql, boolean generatingKeys) throws java.sql.SQLException {
        this.lastResultSet = null;
        dataStream.encodeInt(this.handle);
        dataStream.encodeString(sql);
        this.communicateWithServer(dataStream);
        boolean ret = dataStream.getInt() != 0;
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, generatingKeys);
        return ret;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        this.checkOpen();
        RemConnection.validateAutoGenFlag(autoGeneratedKeys);
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(91);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(autoGeneratedKeys);
        return this.execute(dataStream, sql, autoGeneratedKeys == 1);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(93);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(columnIndexes.length);
        for (int index : columnIndexes) {
            dataStream.encodeInt(index);
        }
        return this.execute(dataStream, sql, true);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(92);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(columnNames.length);
        for (String name : columnNames) {
            dataStream.encodeString(name);
        }
        return this.execute(dataStream, sql, true);
    }

    @Override
    public int[] executeBatch() throws java.sql.SQLException {
        this.checkOpen();
        if (this.batchSql == null) {
            return new int[1];
        }
        int[] batchUpdateResults = new int[Math.max(1, this.batchSql.size())];
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(83);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        dataStream.encodeInt(this.batchSql.size());
        for (String sql : this.batchSql) {
            dataStream.encodeString(sql);
        }
        this.communicateWithServer(dataStream);
        String batchUpdateMessage = null;
        SQLState batchUpdateState = null;
        java.sql.SQLException batchUpdateException = null;
        for (int n = 0; n < this.batchSql.size(); ++n) {
            batchUpdateResults[n] = dataStream.getInt();
            if (batchUpdateResults[n] != -3) continue;
            int stateCode = dataStream.getInt();
            SQLState state = SQLState.getSQLState(stateCode);
            String message = dataStream.getString();
            java.sql.SQLException exception = SQLStateException.fromStateClass(state.getStateClass()).create(message, state.getState(), stateCode);
            if (batchUpdateException == null) {
                batchUpdateMessage = message;
                batchUpdateState = state;
                batchUpdateException = exception;
                continue;
            }
            batchUpdateException.setNextException(exception);
        }
        this.updateTimeZone(dataStream);
        long transactionId = dataStream.getLong();
        int nodeId = dataStream.getInt();
        long commitSequence = dataStream.getLong();
        this.connection.setLastTransaction(transactionId, nodeId, commitSequence);
        this.batchSql.clear();
        if (batchUpdateException != null) {
            BatchUpdateException exception = new BatchUpdateException(batchUpdateMessage, batchUpdateState.getState(), batchUpdateState.getCode(), batchUpdateResults);
            exception.setNextException(batchUpdateException);
            throw exception;
        }
        return batchUpdateResults;
    }

    @Override
    public ResultSet executeQuery(String arg0) throws java.sql.SQLException {
        this.lastResultSet = null;
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(19);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        dataStream.encodeString(arg0);
        this.communicateWithServer(dataStream);
        this.lastResultSet = this.createResultSet(dataStream);
        return this.lastResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(20);
        this.encodeLastTxnIds(dataStream);
        return this.executeUpdate(dataStream, sql, false);
    }

    private int executeUpdate(EncodedDataStream dataStream, String sql, boolean generatingKeys) throws java.sql.SQLException {
        this.lastResultSet = null;
        dataStream.encodeInt(this.handle);
        dataStream.encodeString(sql);
        this.communicateWithServer(dataStream);
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, generatingKeys);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        RemConnection.validateAutoGenFlag(autoGeneratedKeys);
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(94);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(autoGeneratedKeys);
        return this.executeUpdate(dataStream, sql, autoGeneratedKeys == 1);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(96);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(columnIndexes.length);
        for (int index : columnIndexes) {
            dataStream.encodeInt(index);
        }
        return this.executeUpdate(dataStream, sql, true);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(95);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(columnNames.length);
        for (String name : columnNames) {
            dataStream.encodeString(name);
        }
        return this.executeUpdate(dataStream, sql, true);
    }

    @Override
    public Connection getConnection() throws java.sql.SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws java.sql.SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws java.sql.SQLException {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws java.sql.SQLException {
        this.checkOpen();
        return this.generatedKeys == null ? new EmptyResultSet() : this.generatedKeys;
    }

    @Override
    public int getMaxFieldSize() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws java.sql.SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws java.sql.SQLException {
        this.checkOpen();
        RemSQLUtils.close(this.lastResultSet);
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(46);
        dataStream.encodeInt(this.handle);
        this.communicateWithServer(dataStream);
        return dataStream.getInt() == 1;
    }

    @Override
    public boolean getMoreResults(int arg0) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return false;
    }

    @Override
    public int getQueryTimeout() throws java.sql.SQLException {
        return (int)(this.queryTimeoutMicros / 1000000L);
    }

    public long getQueryTimeoutMicros() throws java.sql.SQLException {
        return this.queryTimeoutMicros;
    }

    @Override
    public ResultSet getResultSet() throws java.sql.SQLException {
        this.checkOpen();
        if (this.lastResultSet == null) {
            RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
            dataStream.startMessage(13);
            dataStream.encodeInt(this.handle);
            this.communicateWithServer(dataStream);
            this.lastResultSet = this.createResultSet(dataStream);
        }
        return this.lastResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws java.sql.SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws java.sql.SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws java.sql.SQLException {
        return 1003;
    }

    @Override
    public int getUpdateCount() throws java.sql.SQLException {
        int retval = this.updateCount;
        this.updateCount = -1;
        return retval;
    }

    @Override
    public SQLWarning getWarnings() throws java.sql.SQLException {
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws java.sql.SQLException {
        return false;
    }

    @Override
    public void setCursorName(String cursorName) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(21);
        dataStream.encodeInt(this.handle);
        dataStream.encodeString(cursorName);
        this.communicateWithServer(dataStream);
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws java.sql.SQLException {
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws java.sql.SQLException {
        if (fetchDirection != 1000) {
            throw new SQLFeatureNotSupportedException("Unsupported fetch direction: " + fetchDirection);
        }
        this.fetchDirection = fetchDirection;
    }

    @Override
    public void setFetchSize(int fetchSize) throws java.sql.SQLException {
        if (fetchSize < 0) {
            throw new SQLException("Fetch size must be equal to or greater than 0", SQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.protocolVersion >= 19) {
            this.checkOpen();
            RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
            dataStream.startMessage(124);
            dataStream.encodeInt(this.handle);
            dataStream.encodeInt(fetchSize);
            this.communicateWithServer(dataStream);
        } else if (fetchSize != 0) {
            throw new SQLFeatureNotSupportedException("Non-default fetch size value is not supported");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws java.sql.SQLException {
        if (maxFieldSize != 0) {
            Utils.notYetImplemented();
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws java.sql.SQLException {
        if (maxRows < 0) {
            throw new SQLException("Max rows must be equal to or greater than 0", SQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setPoolable(boolean poolable) throws java.sql.SQLException {
    }

    @Override
    public void setQueryTimeout(int seconds) throws java.sql.SQLException {
        this.setQueryTimeoutMicros((long)seconds * 1000000L);
    }

    public void setQueryTimeoutMicros(long microSeconds) throws java.sql.SQLException {
        long newSetting = microSeconds;
        if (newSetting == this.queryTimeoutMicros) {
            return;
        }
        if (this.queryTimeoutMicros > 0L || newSetting > 0L) {
            this.checkOpen();
            if (this.connection.protocolVersion < 12) {
                Utils.notYetImplemented();
            }
            RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
            dataStream.startMessage(105);
            dataStream.encodeInt(this.handle);
            dataStream.encodeLong(newSetting);
            this.communicateWithServer(dataStream);
            this.queryTimeoutMicros = newSetting;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws java.sql.SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws java.sql.SQLException {
        return iface.cast(this);
    }

    public void checkOpen() throws java.sql.SQLException {
        if (this.closed || this.connection.isClosed()) {
            throw new SQLException("Statement is closed", SQLState.APPLICATION_ERROR);
        }
    }

    RemResultSet createResultSet(EncodedDataStream dataStream) throws java.sql.SQLException {
        return this.createResultSet(dataStream, true);
    }

    RemResultSet createResultSet(EncodedDataStream dataStream, boolean readColumnNames) throws java.sql.SQLException {
        int handle = dataStream.getInt();
        if (handle == -1) {
            return null;
        }
        RemResultSet resultSet = new RemResultSet(this.connection, handle, dataStream, this, readColumnNames);
        this.resultSets.add(resultSet);
        return resultSet;
    }

    void resultSetClosed(RemResultSet resultSet) {
        this.resultSets.remove(resultSet);
        this.lastResultSet = null;
    }

    protected void updateRecordsUpdated(EncodedDataStream dataStream) throws java.sql.SQLException {
        int count = dataStream.getInt();
        this.updateCount = count >= -1 ? count : 0;
    }

    protected void encodeLastTxnIds(EncodedDataStream dataStream) {
        if (this.connection.protocolVersion >= 17) {
            this.connection.encodeCommitInfo(dataStream);
        }
    }

    protected void updateLastCommitInfo(EncodedDataStream dataStream, boolean generatingKeys) throws java.sql.SQLException {
        this.generatedKeys = null;
        long transactionId = dataStream.getLong();
        int nodeId = dataStream.getInt();
        long commitSequence = dataStream.getLong();
        this.connection.setLastTransaction(transactionId, nodeId, commitSequence);
        if (generatingKeys) {
            this.generatedKeys = this.createResultSet(dataStream);
        }
    }

    protected void updateTimeZone(EncodedDataStream dataStream) throws java.sql.SQLException {
        if (this.connection.protocolVersion < 25) {
            return;
        }
        boolean tzChanged = dataStream.getBoolean();
        if (tzChanged) {
            String timeZone = dataStream.getString();
            TimeZone tz = TimeZone.getTimeZone(timeZone);
            this.connection.getSQLContext().setTimeZone(tz);
        }
    }

    @Override
    public void closeOnCompletion() throws java.sql.SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws java.sql.SQLException {
        return false;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String toString() {
        return "[Statement - handle " + this.handle + " (Connection ID - " + this.connection.getGlobalConnectionId() + ")]";
    }

    static enum StatementCancelState {
        IDLE,
        IN_QUERY,
        CANCELING,
        CANCELLED;

    }
}

