/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.ChunkedInputStream;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemResultSet;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import com.nuodb.jdbc.ValueTime;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class ValueStream
extends Value {
    private int handle;
    private int streamType;
    private long chunkSize;
    private long streamSize;
    private int chunksCount;
    private EncodedDataStream dataStream;
    private RemResultSet resultSet;

    public ValueStream(int handle, int streamType, long chunkSize, long streamSize) {
        this.handle = handle;
        this.streamType = streamType;
        this.chunkSize = chunkSize;
        this.streamSize = streamSize;
        this.chunksCount = (int)Math.ceil((double)streamSize / (double)chunkSize);
        this.dataStream = new RemEncodedStream(26);
    }

    @Override
    int getType() {
        return 23;
    }

    @Override
    Object getObject() throws SQLException {
        return this.isClob() ? this.getString() : (Object)this.getBytes();
    }

    boolean isBlob() {
        return this.streamType == 2;
    }

    @Override
    public void setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSet = (RemResultSet)resultSet;
    }

    boolean isClob() {
        return this.streamType == 4;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeInt(this.handle);
    }

    private Value getChunk(int index) throws SQLException {
        this.resultSet.checkOpen();
        this.dataStream.reset();
        this.dataStream.startMessage(120);
        this.dataStream.encodeInt(this.resultSet.getHandle());
        this.dataStream.encodeInt(this.handle);
        this.dataStream.encodeInt(index);
        this.resultSet.getConnection().sendAndReceive(this.dataStream);
        return this.dataStream.getValue();
    }

    protected byte[] getChunkBytes(int index) throws SQLException {
        return this.getChunk(index).getBytes();
    }

    protected String getChunkString(int index) throws SQLException {
        return this.getChunk(index).getString();
    }

    @Override
    public String getString() throws SQLException {
        StringBuilder result = new StringBuilder((int)this.streamSize);
        for (int i = 0; i < this.chunksCount; ++i) {
            result.append(this.getChunkString(i));
        }
        return result.toString();
    }

    @Override
    public byte[] getBytes(SQLContext context) throws SQLException {
        return this.getBytes();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        byte[] result = new byte[(int)this.streamSize];
        int offset = 0;
        for (int chunk = 0; chunk < this.chunksCount; ++chunk) {
            byte[] bytes = this.getChunkBytes(chunk);
            System.arraycopy(bytes, 0, result, offset, bytes.length);
            offset += bytes.length;
        }
        return result;
    }

    @Override
    public InputStream getInputStream() throws SQLException {
        return new ChunkedInputStream(this, false);
    }

    @Override
    public InputStream getAsciiStream(SQLContext context) throws SQLException {
        return new ChunkedInputStream(this, true);
    }

    @Override
    public Reader getCharacterStream(SQLContext context) throws SQLException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    byte getByte() throws SQLException {
        byte result = 0;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Byte.parseByte(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "byte", exception);
            }
        } else {
            this.throwConversionNotImplemented("byte");
        }
        return result;
    }

    @Override
    short getShort() throws SQLException {
        short result = 0;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Short.parseShort(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "short", exception);
            }
        } else {
            this.throwConversionNotImplemented("short");
        }
        return result;
    }

    @Override
    int getInt() throws SQLException {
        int result = 0;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "int", exception);
            }
        } else {
            this.throwConversionNotImplemented("int");
        }
        return result;
    }

    @Override
    long getLong() throws SQLException {
        long result = 0L;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "long", exception);
            }
        } else {
            this.throwConversionNotImplemented("long");
        }
        return result;
    }

    @Override
    float getFloat() throws SQLException {
        float result = 0.0f;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "float", exception);
            }
        } else {
            this.throwConversionNotImplemented("float");
        }
        return result;
    }

    @Override
    double getDouble() throws SQLException {
        double result = 0.0;
        if (this.isClob()) {
            String value = this.getString();
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException exception) {
                ValueStream.throwConversionFailed(value, "double", exception);
            }
        } else {
            this.throwConversionNotImplemented("double");
        }
        return result;
    }

    @Override
    Date getDate(SQLContext context) throws SQLException {
        Date result = null;
        if (this.isClob()) {
            String value = this.getString();
            try {
                DateTimeFormatter format = ValueStream.getDateFormatter(context.getTimeZone());
                result = Date.valueOf(LocalDate.from(format.parse(value)));
            }
            catch (DateTimeParseException exception) {
                ValueStream.throwConversionFailed(value, "date", exception);
            }
        } else {
            this.throwConversionNotImplemented("date");
        }
        return result;
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        Timestamp result = null;
        if (this.isClob()) {
            String value = this.getString();
            try {
                DateTimeFormatter format = ValueStream.getTimestampFormatter(context.getTimeZone());
                result = Timestamp.from(Instant.from(format.parse(value)));
            }
            catch (DateTimeParseException exception) {
                ValueStream.throwConversionFailed(value, "timestamp", exception);
            }
        } else {
            this.throwConversionNotImplemented("timestamp");
        }
        return result;
    }

    @Override
    Time getTime(SQLContext context) throws SQLException {
        if (this.isClob()) {
            String value = this.getString();
            try {
                return ValueTime.parseTime(context, value);
            }
            catch (DateTimeParseException exception) {
                ValueStream.throwConversionFailed(value, "time", exception);
            }
        } else {
            this.throwConversionNotImplemented("time");
        }
        return null;
    }

    @Override
    boolean getBoolean() throws SQLException {
        boolean result = false;
        if (this.isClob()) {
            String value = this.getString();
            result = value != null && value.equalsIgnoreCase("true");
        } else {
            this.throwConversionNotImplemented("boolean");
        }
        return result;
    }

    private static void throwConversionFailed(String value, String type, Exception exception) throws SQLException {
        throw new SQLException(MessageFormat.format("Unable to convert \"{0}\" into {1}", value, type), exception);
    }

    public int getStreamType() {
        return this.streamType;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public long getStreamSize() {
        return this.streamSize;
    }

    public int getChunksCount() {
        return this.chunksCount;
    }
}

