/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.impl.util.StackFrameInfo;
import com.nuodb.jdbc.logger.Level;
import com.nuodb.jdbc.logger.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;

public class Jdk14Logger
implements Logger {
    private static Map<Level, java.util.logging.Level> LEVELS = new HashMap<Level, java.util.logging.Level>();
    private final java.util.logging.Logger logger;
    private final String loggerName;
    private static final String CALLER_CLASS_NAME;
    private String callerClassName;

    public Jdk14Logger(java.util.logging.Logger logger) {
        this(logger, CALLER_CLASS_NAME);
    }

    public Jdk14Logger(java.util.logging.Logger logger, String callerClassName) {
        this.logger = logger;
        this.loggerName = logger.getName();
        this.callerClassName = callerClassName;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return this.isLevelEnabled(LEVELS.get((Object)level));
    }

    @Override
    public void error(String message) {
        this.log(java.util.logging.Level.SEVERE, this.callerClassName, message, null);
    }

    @Override
    public void error(String message, Throwable failure) {
        this.log(java.util.logging.Level.SEVERE, this.callerClassName, message, failure);
    }

    @Override
    public void warn(String message) {
        this.log(java.util.logging.Level.WARNING, this.callerClassName, message, null);
    }

    @Override
    public void warn(String message, Throwable failure) {
        this.log(java.util.logging.Level.WARNING, this.callerClassName, message, failure);
    }

    @Override
    public void info(String message) {
        this.log(java.util.logging.Level.INFO, this.callerClassName, message, null);
    }

    @Override
    public void info(String message, Throwable failure) {
        this.log(java.util.logging.Level.INFO, this.callerClassName, message, failure);
    }

    @Override
    public void debug(String message) {
        this.log(java.util.logging.Level.FINE, this.callerClassName, message, null);
    }

    @Override
    public void debug(String message, Throwable failure) {
        this.log(java.util.logging.Level.FINE, this.callerClassName, message, failure);
    }

    @Override
    public void trace(String message) {
        this.log(java.util.logging.Level.FINEST, this.callerClassName, message, null);
    }

    @Override
    public void trace(String message, Throwable failure) {
        this.log(java.util.logging.Level.FINEST, this.callerClassName, message, failure);
    }

    @Override
    public void log(Level level, String message, Throwable failure) {
        this.log(level, this.callerClassName, message, failure);
    }

    @Override
    public void log(Level level, String callerClassName, String message, Throwable failure) {
        this.log(LEVELS.get((Object)level), callerClassName, message, failure);
    }

    protected boolean isLevelEnabled(java.util.logging.Level level) {
        return level != null && this.logger.isLoggable(level);
    }

    protected void log(java.util.logging.Level level, String callerClassName, String message, Throwable failure) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, message);
        record.setLoggerName(this.loggerName);
        record.setThrown(failure);
        StackFrameInfo stackFrameInfo = new StackFrameInfo(callerClassName);
        record.setSourceClassName(stackFrameInfo.getClassName());
        record.setSourceMethodName(stackFrameInfo.getMethodName());
        this.logger.log(record);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jdk14Logger that = (Jdk14Logger)o;
        return !(this.loggerName != null ? !this.loggerName.equals(that.loggerName) : that.loggerName != null);
    }

    public int hashCode() {
        return this.loggerName != null ? this.loggerName.hashCode() : 0;
    }

    public String toString() {
        return "Jdk14Logger{loggerName='" + this.loggerName + "'}";
    }

    static {
        LEVELS.put(Level.OFF, java.util.logging.Level.OFF);
        LEVELS.put(Level.ERROR, java.util.logging.Level.SEVERE);
        LEVELS.put(Level.WARN, java.util.logging.Level.WARNING);
        LEVELS.put(Level.INFO, java.util.logging.Level.INFO);
        LEVELS.put(Level.DEBUG, java.util.logging.Level.FINE);
        LEVELS.put(Level.TRACE, java.util.logging.Level.FINEST);
        CALLER_CLASS_NAME = Jdk14Logger.class.getName();
    }
}

