/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryJob;
import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.RetryExecutor;
import com.nurkiewicz.asyncretry.RetryJob;
import com.nurkiewicz.asyncretry.SyncRetryJob;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.BoundedMaxBackoff;
import com.nurkiewicz.asyncretry.backoff.BoundedMinBackoff;
import com.nurkiewicz.asyncretry.backoff.ExponentialDelayBackoff;
import com.nurkiewicz.asyncretry.backoff.FixedIntervalBackoff;
import com.nurkiewicz.asyncretry.backoff.ProportionalRandomBackoff;
import com.nurkiewicz.asyncretry.backoff.UniformRandomBackoff;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import com.nurkiewicz.asyncretry.function.RetryRunnable;
import com.nurkiewicz.asyncretry.policy.RetryPolicy;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AsyncRetryExecutor
implements RetryExecutor {
    private final ScheduledExecutorService scheduler;
    private final boolean fixedDelay;
    private final RetryPolicy retryPolicy;
    private final Backoff backoff;

    public AsyncRetryExecutor(ScheduledExecutorService scheduler) {
        this(scheduler, RetryPolicy.DEFAULT, Backoff.DEFAULT);
    }

    public AsyncRetryExecutor(ScheduledExecutorService scheduler, Backoff backoff) {
        this(scheduler, RetryPolicy.DEFAULT, backoff);
    }

    public AsyncRetryExecutor(ScheduledExecutorService scheduler, RetryPolicy retryPolicy) {
        this(scheduler, retryPolicy, Backoff.DEFAULT);
    }

    public AsyncRetryExecutor(ScheduledExecutorService scheduler, RetryPolicy retryPolicy, Backoff backoff) {
        this(scheduler, retryPolicy, backoff, false);
    }

    public AsyncRetryExecutor(ScheduledExecutorService scheduler, RetryPolicy retryPolicy, Backoff backoff, boolean fixedDelay) {
        this.scheduler = Objects.requireNonNull(scheduler);
        this.retryPolicy = Objects.requireNonNull(retryPolicy);
        this.backoff = Objects.requireNonNull(backoff);
        this.fixedDelay = fixedDelay;
    }

    @Override
    public ListenableFuture<Void> doWithRetry(final RetryRunnable action) {
        return this.getWithRetry(new RetryCallable<Void>(){

            @Override
            public Void call(RetryContext context) throws Exception {
                action.run(context);
                return null;
            }
        });
    }

    @Override
    public <V> ListenableFuture<V> getWithRetry(final Callable<V> task) {
        return this.getWithRetry(new RetryCallable<V>(){

            @Override
            public V call(RetryContext context) throws Exception {
                return task.call();
            }
        });
    }

    @Override
    public <V> ListenableFuture<V> getWithRetry(RetryCallable<V> task) {
        return this.scheduleImmediately(this.createTask(task));
    }

    @Override
    public <V> ListenableFuture<V> getFutureWithRetry(RetryCallable<ListenableFuture<V>> task) {
        return this.scheduleImmediately(this.createFutureTask(task));
    }

    private <V> ListenableFuture<V> scheduleImmediately(RetryJob<V> job) {
        this.scheduler.schedule(job, 0L, TimeUnit.MILLISECONDS);
        return job.getFuture();
    }

    protected <V> RetryJob<V> createTask(RetryCallable<V> function) {
        return new SyncRetryJob<V>(function, this);
    }

    protected <V> RetryJob<V> createFutureTask(RetryCallable<ListenableFuture<V>> function) {
        return new AsyncRetryJob<V>(function, this);
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public boolean isFixedDelay() {
        return this.fixedDelay;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Backoff getBackoff() {
        return this.backoff;
    }

    public AsyncRetryExecutor withScheduler(ScheduledExecutorService scheduler) {
        return new AsyncRetryExecutor(scheduler, this.retryPolicy, this.backoff, this.fixedDelay);
    }

    public AsyncRetryExecutor withRetryPolicy(RetryPolicy retryPolicy) {
        return new AsyncRetryExecutor(this.scheduler, retryPolicy, this.backoff, this.fixedDelay);
    }

    public AsyncRetryExecutor withExponentialBackoff(long initialDelayMillis, double multiplier) {
        ExponentialDelayBackoff backoff = new ExponentialDelayBackoff(initialDelayMillis, multiplier);
        return new AsyncRetryExecutor(this.scheduler, this.retryPolicy, backoff, this.fixedDelay);
    }

    public AsyncRetryExecutor withFixedBackoff(long delayMillis) {
        FixedIntervalBackoff backoff = new FixedIntervalBackoff(delayMillis);
        return new AsyncRetryExecutor(this.scheduler, this.retryPolicy, backoff, this.fixedDelay);
    }

    public AsyncRetryExecutor withBackoff(Backoff backoff) {
        return new AsyncRetryExecutor(this.scheduler, this.retryPolicy, backoff, this.fixedDelay);
    }

    public AsyncRetryExecutor withFixedRate() {
        return new AsyncRetryExecutor(this.scheduler, this.retryPolicy, this.backoff, true);
    }

    public AsyncRetryExecutor withFixedRate(boolean fixedDelay) {
        return new AsyncRetryExecutor(this.scheduler, this.retryPolicy, this.backoff, fixedDelay);
    }

    @SafeVarargs
    public final AsyncRetryExecutor retryOn(Class<? extends Throwable> ... retryOnThrowables) {
        return this.withRetryPolicy(this.retryPolicy.retryOn(retryOnThrowables));
    }

    @SafeVarargs
    public final AsyncRetryExecutor abortOn(Class<? extends Throwable> ... abortOnThrowable) {
        return this.withRetryPolicy(this.retryPolicy.abortOn(abortOnThrowable));
    }

    public AsyncRetryExecutor retryIf(Predicate<Throwable> retryPredicate) {
        return this.withRetryPolicy(this.retryPolicy.retryIf(retryPredicate));
    }

    public AsyncRetryExecutor abortIf(Predicate<Throwable> abortPredicate) {
        return this.withRetryPolicy(this.retryPolicy.abortIf(abortPredicate));
    }

    public AsyncRetryExecutor withUniformJitter() {
        return this.withBackoff(new UniformRandomBackoff(this.backoff));
    }

    public AsyncRetryExecutor withUniformJitter(long range) {
        return this.withBackoff(new UniformRandomBackoff(this.backoff, range));
    }

    public AsyncRetryExecutor withProportionalJitter() {
        return this.withBackoff(new ProportionalRandomBackoff(this.backoff));
    }

    public AsyncRetryExecutor withProportionalJitter(double multiplier) {
        return this.withBackoff(new ProportionalRandomBackoff(this.backoff, multiplier));
    }

    public AsyncRetryExecutor withMinDelay(long minDelayMillis) {
        return this.withBackoff(new BoundedMinBackoff(this.backoff, minDelayMillis));
    }

    public AsyncRetryExecutor withMaxDelay(long maxDelayMillis) {
        return this.withBackoff(new BoundedMaxBackoff(this.backoff, maxDelayMillis));
    }

    public AsyncRetryExecutor withMaxRetries(int times) {
        return this.withRetryPolicy(this.retryPolicy.withMaxRetries(times));
    }

    public AsyncRetryExecutor dontRetry() {
        return this.withRetryPolicy(this.retryPolicy.dontRetry());
    }

    public AsyncRetryExecutor withNoDelay() {
        return this.withBackoff(new FixedIntervalBackoff(0L));
    }
}

