/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.policy.AbortRetryException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryJob<V>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RetryJob.class);
    protected final SettableFuture<V> future;
    protected final AsyncRetryContext context;
    protected final AsyncRetryExecutor parent;

    public RetryJob(AsyncRetryContext context, AsyncRetryExecutor parent, SettableFuture<V> future) {
        this.context = context;
        this.parent = parent;
        this.future = future;
    }

    protected void logSuccess(RetryContext context, V result, long duration) {
        log.trace("Successful after {} retries, took {}ms and returned: {}", new Object[]{context.getRetryCount(), duration, result});
    }

    protected void handleManualAbort(AbortRetryException abortEx) {
        this.logAbort(this.context);
        if (this.context.getLastThrowable() != null) {
            this.future.setException(this.context.getLastThrowable());
        } else {
            this.future.setException((Throwable)abortEx);
        }
    }

    protected void logAbort(RetryContext context) {
        log.trace("Aborted by user after {} retries", (Object)(context.getRetryCount() + 1));
    }

    protected void handleThrowable(Throwable t, long duration) {
        if (t instanceof AbortRetryException) {
            this.handleManualAbort((AbortRetryException)t);
        } else {
            this.handleUserThrowable(t, duration);
        }
    }

    protected void handleUserThrowable(Throwable t, long duration) {
        AsyncRetryContext nextRetryContext = this.context.nextRetry(t);
        if (this.parent.getRetryPolicy().shouldContinue(nextRetryContext)) {
            long delay = this.calculateNextDelay(duration, nextRetryContext, this.parent.getBackoff());
            this.retryWithDelay(nextRetryContext, delay, duration);
        } else {
            this.logFailure(nextRetryContext, duration);
            this.future.setException(t);
        }
    }

    protected void logFailure(AsyncRetryContext nextRetryContext, long duration) {
        log.trace("Giving up after {} retries, last run took: {}ms, last exception: ", new Object[]{this.context.getRetryCount(), duration, nextRetryContext.getLastThrowable()});
    }

    private long calculateNextDelay(long taskDurationMillis, AsyncRetryContext nextRetryContext, Backoff backoff) {
        long delay = backoff.delayMillis(nextRetryContext);
        return delay - (this.parent.isFixedDelay() ? taskDurationMillis : 0L);
    }

    private void retryWithDelay(AsyncRetryContext nextRetryContext, long delay, long duration) {
        RetryJob<V> nextTask = this.nextTask(nextRetryContext);
        this.parent.getScheduler().schedule(nextTask, delay, TimeUnit.MILLISECONDS);
        this.logRetry(nextRetryContext, delay, duration);
    }

    protected void logRetry(AsyncRetryContext nextRetryContext, long delay, long duration) {
        Date nextRunDate = new Date(System.currentTimeMillis() + delay);
        log.trace("Retry {} failed after {}ms, scheduled next retry in {}ms ({})", new Object[]{this.context.getRetryCount(), duration, delay, nextRunDate, nextRetryContext.getLastThrowable()});
    }

    @Override
    public void run() {
        this.run(System.currentTimeMillis());
    }

    protected abstract void run(long var1);

    protected abstract RetryJob<V> nextTask(AsyncRetryContext var1);

    protected void complete(V result, long duration) {
        this.logSuccess(this.context, result, duration);
        this.future.set(result);
    }

    public ListenableFuture<V> getFuture() {
        return this.future;
    }
}

