/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.RetryExecutor;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import com.nurkiewicz.asyncretry.function.RetryRunnable;
import com.nurkiewicz.asyncretry.policy.RetryPolicy;
import java.util.concurrent.Callable;

public enum SyncRetryExecutor implements RetryExecutor
{
    INSTANCE;

    private static final AsyncRetryContext RETRY_CONTEXT;

    @Override
    public ListenableFuture<Void> doWithRetry(RetryRunnable action) {
        try {
            action.run(RETRY_CONTEXT);
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public <V> ListenableFuture<V> getWithRetry(Callable<V> task) {
        try {
            return Futures.immediateFuture(task.call());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public <V> ListenableFuture<V> getWithRetry(RetryCallable<V> task) {
        try {
            return Futures.immediateFuture(task.call(RETRY_CONTEXT));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public <V> ListenableFuture<V> getFutureWithRetry(RetryCallable<ListenableFuture<V>> task) {
        try {
            return task.call(RETRY_CONTEXT);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    static {
        RETRY_CONTEXT = new AsyncRetryContext(RetryPolicy.DEFAULT);
    }
}

