/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.hybrid;

import com.nvidia.spark.rapids.hybrid.HybridPluginWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HybridPluginWrapper$
implements Logging {
    public static HybridPluginWrapper$ MODULE$;
    private final String LOAD_BACKEND_KEY;
    private final String LIB_NAME;
    private final String osReleasePath;
    private final String GLUTEN_BUILD_FILE;
    private final String GLUTEN_SESSION_EXTENSION_NAME;
    private final boolean preserveDepsAfterLoad;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HybridPluginWrapper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String LOAD_BACKEND_KEY() {
        return this.LOAD_BACKEND_KEY;
    }

    private String LIB_NAME() {
        return this.LIB_NAME;
    }

    private String osReleasePath() {
        return this.osReleasePath;
    }

    private String GLUTEN_BUILD_FILE() {
        return this.GLUTEN_BUILD_FILE;
    }

    public String GLUTEN_SESSION_EXTENSION_NAME() {
        return this.GLUTEN_SESSION_EXTENSION_NAME;
    }

    private boolean preserveDepsAfterLoad() {
        return this.preserveDepsAfterLoad;
    }

    public void loadNativeDeps() {
        ClassLoader clzLoader = HybridPluginWrapper.class.getClassLoader();
        String libPathInJar = this.getHybridLibPath();
        ObjectRef tmpLibFile = ObjectRef.create(null);
        try (InputStream is = null;){
            try {
                is = clzLoader.getResourceAsStream(libPathInJar);
                tmpLibFile.elem = File.createTempFile(this.LIB_NAME(), ".so");
                ((File)tmpLibFile.elem).deleteOnExit();
                Files.copy(is, ((File)tmpLibFile.elem).toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.load(((File)tmpLibFile.elem).getAbsolutePath());
                Object object = !this.preserveDepsAfterLoad() ? BoxesRunTime.boxToBoolean((boolean)((File)tmpLibFile.elem).delete()) : BoxedUnit.UNIT;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Successfully loaded Library: ").append(((File)tmpLibFile$1.elem).getAbsolutePath()).toString());
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(70).append("Failed to load library ").append(this.LIB_NAME()).append(", ").append("path in Hybrid jar is ").append(libPathInJar).append(", ").append("installation path is ").append(((File)tmpLibFile.elem).getAbsolutePath()).toString(), e);
            }
        }
    }

    private String getHybridLibPath() {
        String string;
        try (FileInputStream inputStream = null;){
            try {
                inputStream = new FileInputStream(this.osReleasePath());
                Properties properties = new Properties();
                properties.load(inputStream);
                String arch = System.getProperty("os.arch");
                String osId = properties.getProperty("ID").replace("\"", "");
                String osVersion = properties.getProperty("VERSION_ID").replace("\"", "");
                string = new StringBuilder(3).append(arch).append("/").append(osId).append("/").append(osVersion).append("/").append(System.mapLibraryName(this.LIB_NAME())).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(103).append("Reading OS version file failed, path is ").append(this.osReleasePath()).append(", ").append("Hybrid feature requires OS is Ubuntu or CentOS, please check.").toString(), e);
            }
        }
        return string;
    }

    public void checkGlutenJarVersion(String sparkVersion) {
        block7: {
            InputStream buildFileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.GLUTEN_BUILD_FILE());
            if (buildFileStream == null) {
                throw new RuntimeException(new StringBuilder(118).append("Can not load the Gluten build file: ").append(this.GLUTEN_BUILD_FILE()).append(", ").append("Please provide the Gluten bundle jar and Gluten third party jar in the classpath").toString());
            }
            Properties props = new Properties();
            try {
                props.load(buildFileStream);
                String sparkVersionGlutenBuilt = props.getProperty("spark_version", "unknown");
                String[] expected = new StringOps(Predef$.MODULE$.augmentString(sparkVersion)).split('.');
                String[] inGluten = new StringOps(Predef$.MODULE$.augmentString(sparkVersionGlutenBuilt)).split('.');
                if (expected.length == 3 && inGluten.length == 3) {
                    String string = expected[0];
                    String string2 = inGluten[0];
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String string3 = expected[1];
                        String string4 = inGluten[1];
                        if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block7;
                    }
                }
                throw new RuntimeException(new StringBuilder(166).append("Picked wrong Gluten jars, Gluten is built against: ").append(sparkVersionGlutenBuilt).append(", current Spark version is ").append(sparkVersion).append(", the major ").append("and minor version should be equal, the version is in format major.minor.fix.").toString());
            }
            finally {
                buildFileStream.close();
            }
        }
    }

    private HybridPluginWrapper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LOAD_BACKEND_KEY = "spark.rapids.sql.hybrid.loadBackend";
        this.LIB_NAME = "rapids_hybrid";
        this.osReleasePath = "/etc/os-release";
        this.GLUTEN_BUILD_FILE = "gluten-build-info.properties";
        this.GLUTEN_SESSION_EXTENSION_NAME = "org.apache.gluten.GlutenSessionExtensions";
        this.preserveDepsAfterLoad = Boolean.getBoolean("com.nvidia.spark.rapids.hybrid.preserve-dependencies");
    }
}

