/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostMemoryBuffer;
import com.nvidia.spark.rapids.HttpBackendType$;
import com.nvidia.spark.rapids.PerfIOConf;
import com.nvidia.spark.rapids.RangeCopier;
import com.nvidia.spark.rapids.RangeWithOffset;
import com.nvidia.spark.rapids.SuffixRangeWithOffset;
import com.nvidia.spark.rapids.internal.Arm$;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PerfIO$
implements Logging {
    public static PerfIO$ MODULE$;
    private long suffixPrefetchLength;
    private final int FOOTER_LENGTH_SIZE;
    private volatile PerfIOConf s3ApiConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new PerfIO$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int FOOTER_LENGTH_SIZE() {
        return this.FOOTER_LENGTH_SIZE;
    }

    private PerfIOConf s3ApiConf() {
        return this.s3ApiConf;
    }

    private void s3ApiConf_$eq(PerfIOConf x$1) {
        this.s3ApiConf = x$1;
    }

    private long suffixPrefetchLength$lzycompute() {
        PerfIO$ perfIO$ = this;
        synchronized (perfIO$) {
            if (!this.bitmap$0) {
                this.suffixPrefetchLength = Math.max(this.s3ApiConf().s3perfSuffixPrefetchSize(), (long)(this.FOOTER_LENGTH_SIZE() + ParquetFileWriter.MAGIC.length));
                this.bitmap$0 = true;
            }
        }
        return this.suffixPrefetchLength;
    }

    private long suffixPrefetchLength() {
        return !this.bitmap$0 ? this.suffixPrefetchLength$lzycompute() : this.suffixPrefetchLength;
    }

    public void initS3Client(PerfIOConf s3ApiConf) {
        block0: {
            this.s3ApiConf_$eq(s3ApiConf);
            if (!s3ApiConf.s3PerfEnabled()) break block0;
            Enumeration.Value value = s3ApiConf.httpBackendType();
            Enumeration.Value value2 = HttpBackendType$.MODULE$.NETTY();
            RangeCopier.useNetty = !(value != null ? !value.equals(value2) : value2 != null);
        }
    }

    public void shutdownS3Client() {
        block0: {
            if (!this.s3ApiConf().s3PerfEnabled()) break block0;
            RangeCopier.shutdown();
        }
    }

    public Option<HostMemoryBuffer> readParquetFooterBuffer(Path filePath, Configuration conf, Function2<Path, byte[], BoxedUnit> verifyFn) {
        return this.s3ApiConf().s3PerfEnabled() && filePath.toUri().getScheme().startsWith("s3") ? new Some((Object)this.readFooterBufUsingSuffixRange(filePath, conf, verifyFn)) : None$.MODULE$;
    }

    public Option<Object> readToHostMemory(Configuration hadoopConf, HostMemoryBuffer dest, URI fromUri, Function0<Seq<RangeWithOffset>> ranges) {
        return this.s3ApiConf().s3PerfEnabled() && fromUri.getScheme().startsWith("s3") ? new Some((Object)BoxesRunTime.boxToLong((long)RangeCopier.copyToHMB(hadoopConf, dest, fromUri, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ranges.apply()).asJava()))) : None$.MODULE$;
    }

    private HostMemoryBuffer readFooterBufUsingSuffixRange(Path filePath, Configuration conf, Function2<Path, byte[], BoxedUnit> verifyFn) {
        HostMemoryBuffer hmb = (HostMemoryBuffer)Arm$.MODULE$.withResource(this.prefetchFileSuffix(conf, filePath), (Function1 & Serializable & scala.Serializable)prefetchHmb -> {
            HostMemoryBuffer hostMemoryBuffer;
            long footerLengthPos = prefetchHmb.getLength() - (long)(MODULE$.FOOTER_LENGTH_SIZE() + ParquetFileWriter.MAGIC.length);
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            prefetchHmb.getBytes(magic, 0L, prefetchHmb.getLength() - (long)ParquetFileWriter.MAGIC.length, (long)ParquetFileWriter.MAGIC.length);
            verifyFn.apply((Object)filePath, (Object)magic);
            int footerLength = prefetchHmb.getInt(footerLengthPos);
            int resultHmbLength = ParquetFileWriter.MAGIC.length + footerLength + MODULE$.FOOTER_LENGTH_SIZE() + ParquetFileWriter.MAGIC.length;
            if ((long)footerLength <= footerLengthPos) {
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Footer length %d bytes is within prefetch size %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)footerLength), BoxesRunTime.boxToLong((long)prefetchHmb.getLength())})));
                long footerStartPos = footerLengthPos - (long)footerLength;
                if (footerStartPos >= (long)ParquetFileWriter.MAGIC.length) {
                    long magicStartPos = footerStartPos - (long)ParquetFileWriter.MAGIC.length;
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Enough space to fit MAGIC before footerStartPos %d at %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)footerStartPos), BoxesRunTime.boxToLong((long)magicStartPos)})));
                    hostMemoryBuffer = prefetchHmb.slice(magicStartPos, prefetchHmb.getLength() - magicStartPos);
                } else {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Not enough space to fit MAGIC before footerStartPos %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)footerStartPos)})));
                    hostMemoryBuffer = (HostMemoryBuffer)Arm$.MODULE$.withResource(HostMemoryBuffer.allocate((long)resultHmbLength), (Function1 & Serializable & scala.Serializable)resultHmb -> {
                        resultHmb.copyFromHostBuffer((long)ParquetFileWriter.MAGIC.length, prefetchHmb, footerStartPos, prefetchHmb.getLength() - (long)ParquetFileWriter.MAGIC.length);
                        return resultHmb;
                    });
                }
            } else {
                long prefixFooterLength = (long)footerLength - footerLengthPos;
                hostMemoryBuffer = (HostMemoryBuffer)Arm$.MODULE$.closeOnExcept(HostMemoryBuffer.allocate((long)resultHmbLength), (Function1 & Serializable & scala.Serializable)resultHmb -> {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("secondary-fetch of %d + %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)prefixFooterLength), BoxesRunTime.boxToLong((long)prefetchHmb.getLength())})));
                    MODULE$.readToHostMemory(conf, (HostMemoryBuffer)resultHmb, filePath.toUri(), (Function0<Seq<RangeWithOffset>>)(Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)new SuffixRangeWithOffset(resultHmbLength - ParquetFileWriter.MAGIC.length, ParquetFileWriter.MAGIC.length), (List)Nil$.MODULE$));
                    return resultHmb;
                });
            }
            return hostMemoryBuffer;
        });
        return (HostMemoryBuffer)Arm$.MODULE$.closeOnExcept(hmb, (Function1 & Serializable & scala.Serializable)resultHmb -> {
            resultHmb.setBytes(0L, ParquetFileWriter.MAGIC, 0L, (long)ParquetFileWriter.MAGIC.length);
            return resultHmb;
        });
    }

    /*
     * WARNING - void declaration
     */
    private HostMemoryBuffer prefetchFileSuffix(Configuration conf, Path filePath) {
        void var3_3;
        HostMemoryBuffer prefetchHmb = (HostMemoryBuffer)Arm$.MODULE$.withResource(HostMemoryBuffer.allocate((long)this.suffixPrefetchLength()), (Function1 & Serializable & scala.Serializable)hmb -> {
            HostMemoryBuffer hostMemoryBuffer;
            ArrayList<RangeWithOffset> javaList = new ArrayList<RangeWithOffset>();
            ((IterableLike)new .colon.colon((Object)new SuffixRangeWithOffset(MODULE$.suffixPrefetchLength(), 0L), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)javaList.add(r)));
            long actualPrefetchSize = RangeCopier.copyToHMB(conf, hmb, filePath.toUri(), javaList);
            if (actualPrefetchSize < MODULE$.suffixPrefetchLength()) {
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Prefetch of %d bytes yielded only %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)MODULE$.suffixPrefetchLength()), BoxesRunTime.boxToLong((long)actualPrefetchSize)})));
                hostMemoryBuffer = hmb.slice(0L, actualPrefetchSize);
            } else {
                hmb.incRefCount();
                hostMemoryBuffer = hmb;
            }
            return hostMemoryBuffer;
        });
        return var3_3;
    }

    private PerfIO$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.FOOTER_LENGTH_SIZE = 4;
    }
}

