/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.filecache;

import com.nvidia.spark.rapids.filecache.FileCacheConf;
import com.nvidia.spark.rapids.internal.ConfBuilder;
import com.nvidia.spark.rapids.internal.ConfEntryWithDefault;
import com.nvidia.spark.rapids.internal.Configurable;
import com.nvidia.spark.rapids.internal.OptionalConfEntry;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.network.util.ByteUnit;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class FileCacheConf$
implements Configurable {
    public static FileCacheConf$ MODULE$;
    private final OptionalConfEntry<Object> FILECACHE_MAX_BYTES;
    private final ConfEntryWithDefault<Integer> FILECACHE_MAX_BYTES_PERCENT;
    private final ConfEntryWithDefault<Object> FILECACHE_ENABLED;
    private final ConfEntryWithDefault<Object> FILECACHE_MAX_WRITE_BYTES_PENDING;
    private final ConfEntryWithDefault<Object> FILECACHE_SKIP_ON_EXCESS_PENDING;
    private final ConfEntryWithDefault<Object> FILECACHE_TIMESTAMP_UPDATE_DELTA_MSEC;
    private final ConfEntryWithDefault<Object> FILECACHE_FOOTER_TIMESTAMP_ADJUST_MSEC;
    private final ConfEntryWithDefault<Integer> FILECACHE_NUM_THREADS;
    private final ConfEntryWithDefault<Object> FILECACHE_CHECK_STALE;
    private final ConfEntryWithDefault<Object> FILECACHE_USE_CHECKSUMS;
    private final ConfEntryWithDefault<Object> FILECACHE_FOOTERS_ONLY;
    private final OptionalConfEntry<Object> FILECACHE_MAX_CACHE_ENTRY_BYTES;
    private final ConfEntryWithDefault<Integer> FILECACHE_STAT_CACHE_SIZE;
    private final ConfEntryWithDefault<Object> FILECACHE_STAT_CACHE_TIMEOUT_MILLIS;
    private final ConfEntryWithDefault<Object> FILECACHE_FREE_SPACE_MINIMUM_FREE_SPACE_SIZE;
    private final ConfEntryWithDefault<Object> FILECACHE_FREE_SPACE_CHECK_INTERVAL;
    private final OptionalConfEntry<String> FILECACHE_ALLOW_PATH_REGEXP;
    private final OptionalConfEntry<String> FILECACHE_BLOCK_PATH_REGEXP;

    static {
        new FileCacheConf$();
    }

    @Override
    public ConfBuilder conf(String key) {
        return Configurable.conf$(this, key);
    }

    public FileCacheConf apply(SparkConf sparkConf) {
        return new FileCacheConf((Map<String, String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAll())).toMap(Predef$.MODULE$.$conforms()));
    }

    public OptionalConfEntry<Object> FILECACHE_MAX_BYTES() {
        return this.FILECACHE_MAX_BYTES;
    }

    public ConfEntryWithDefault<Integer> FILECACHE_MAX_BYTES_PERCENT() {
        return this.FILECACHE_MAX_BYTES_PERCENT;
    }

    public ConfEntryWithDefault<Object> FILECACHE_ENABLED() {
        return this.FILECACHE_ENABLED;
    }

    public ConfEntryWithDefault<Object> FILECACHE_MAX_WRITE_BYTES_PENDING() {
        return this.FILECACHE_MAX_WRITE_BYTES_PENDING;
    }

    public ConfEntryWithDefault<Object> FILECACHE_SKIP_ON_EXCESS_PENDING() {
        return this.FILECACHE_SKIP_ON_EXCESS_PENDING;
    }

    public ConfEntryWithDefault<Object> FILECACHE_TIMESTAMP_UPDATE_DELTA_MSEC() {
        return this.FILECACHE_TIMESTAMP_UPDATE_DELTA_MSEC;
    }

    public ConfEntryWithDefault<Object> FILECACHE_FOOTER_TIMESTAMP_ADJUST_MSEC() {
        return this.FILECACHE_FOOTER_TIMESTAMP_ADJUST_MSEC;
    }

    public ConfEntryWithDefault<Integer> FILECACHE_NUM_THREADS() {
        return this.FILECACHE_NUM_THREADS;
    }

    public ConfEntryWithDefault<Object> FILECACHE_CHECK_STALE() {
        return this.FILECACHE_CHECK_STALE;
    }

    public ConfEntryWithDefault<Object> FILECACHE_USE_CHECKSUMS() {
        return this.FILECACHE_USE_CHECKSUMS;
    }

    public ConfEntryWithDefault<Object> FILECACHE_FOOTERS_ONLY() {
        return this.FILECACHE_FOOTERS_ONLY;
    }

    public OptionalConfEntry<Object> FILECACHE_MAX_CACHE_ENTRY_BYTES() {
        return this.FILECACHE_MAX_CACHE_ENTRY_BYTES;
    }

    public ConfEntryWithDefault<Integer> FILECACHE_STAT_CACHE_SIZE() {
        return this.FILECACHE_STAT_CACHE_SIZE;
    }

    public ConfEntryWithDefault<Object> FILECACHE_STAT_CACHE_TIMEOUT_MILLIS() {
        return this.FILECACHE_STAT_CACHE_TIMEOUT_MILLIS;
    }

    public ConfEntryWithDefault<Object> FILECACHE_FREE_SPACE_MINIMUM_FREE_SPACE_SIZE() {
        return this.FILECACHE_FREE_SPACE_MINIMUM_FREE_SPACE_SIZE;
    }

    public ConfEntryWithDefault<Object> FILECACHE_FREE_SPACE_CHECK_INTERVAL() {
        return this.FILECACHE_FREE_SPACE_CHECK_INTERVAL;
    }

    public OptionalConfEntry<String> FILECACHE_ALLOW_PATH_REGEXP() {
        return this.FILECACHE_ALLOW_PATH_REGEXP;
    }

    public OptionalConfEntry<String> FILECACHE_BLOCK_PATH_REGEXP() {
        return this.FILECACHE_BLOCK_PATH_REGEXP;
    }

    private FileCacheConf$() {
        MODULE$ = this;
        Configurable.$init$(this);
        this.FILECACHE_MAX_BYTES = this.conf("spark.rapids.filecache.maxBytes").doc("Controls the maximum amount of data that will be cached locally. If left unspecified, it will use half of the available disk space detected on startup for the configured Spark local disks.").startupOnly().bytesConf(ByteUnit.BYTE).createOptional();
        this.FILECACHE_MAX_BYTES_PERCENT = this.conf("spark.rapids.filecache.maxBytesPercent").doc("This configures the maximum size of the cached data as a percentage of available disk space as a value between 1-100. Default value is 50, i.e.: use half of the available disk space for the cache. If spark.rapids.filecache.maxBytes is set, that supersedes this config.").startupOnly().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(50));
        this.FILECACHE_ENABLED = this.conf("spark.rapids.filecache.enabled").doc(new StringBuilder(339).append("Controls whether the caching of input files is enabled. When enabled, input datais cached to the same local directories configured for the Spark application. The cache will use up to half the available space by default. To set an absolute cache ").append("size limit, see the ").append(this.FILECACHE_MAX_BYTES()).append(" configuration setting. Currently only ").append("data from Parquet files are cached.").toString()).startupOnly().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.FILECACHE_MAX_WRITE_BYTES_PENDING = this.conf("spark.rapids.filecache.maxWriteBytesPending").doc("Controls the amount of queued memory in bytes for background cache writes.").startupOnly().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)ByteUnit.GiB.toBytes(1L)));
        this.FILECACHE_SKIP_ON_EXCESS_PENDING = this.conf("spark.rapids.filecache.skipOnExcessPending").doc("Controls the behavior when a task tries to schedule caching of a file when there is too much data pending to be cached. If true, the excess data will not be cached. If false, the requesting task will block until there is sufficient headroom.").startupOnly().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.FILECACHE_TIMESTAMP_UPDATE_DELTA_MSEC = this.conf("spark.rapids.filecache.timestampUpdateDeltaMsec").doc("Controls the minimum difference in milliseconds between the recorded access timestamp of a cache file and a new access timestamp before the new timestamp will be recorded.").startupOnly().longConf().createWithDefault(BoxesRunTime.boxToLong((long)1000L));
        this.FILECACHE_FOOTER_TIMESTAMP_ADJUST_MSEC = this.conf("spark.rapids.filecache.footerTimestampAdjustMsec").doc("Controls the amount of time in milliseconds a footer access timestamp is adjusted into the future to artificially prioritize preservation of footers in the cache.").startupOnly().longConf().createWithDefault(BoxesRunTime.boxToLong((long)10000L));
        this.FILECACHE_NUM_THREADS = this.conf("spark.rapids.filecache.numThreads").doc("Controls the number of threads that will be used for writing cached files.").startupOnly().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(8));
        this.FILECACHE_CHECK_STALE = this.conf("spark.rapids.filecache.checkStale").doc("Controls whether the cached is checked for being out of date with respect to the input file. When enabled, the data that has been cached locally for a file will be invalidated if the file is updated after being cached. This feature is only necessary if an input file for a Spark application can be changed during the lifetime of the application. If an individual input file will not be overwritten during the Spark application then performance may be improved by setting this to false.").startupOnly().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.FILECACHE_USE_CHECKSUMS = this.conf("spark.rapids.filecache.useChecksums").doc("Whether to write out and verify checksums for the cached local files.").startupOnly().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.FILECACHE_FOOTERS_ONLY = this.conf("spark.rapids.filecache.footersOnly").doc("Controls whether the cache only caches footers.").startupOnly().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.FILECACHE_MAX_CACHE_ENTRY_BYTES = this.conf("spark.rapids.filecache.maxCacheEntryBytes").doc("Controls the maximum size of a single entry in the cache. Data entries larger than this size will not be cached.").startupOnly().bytesConf(ByteUnit.BYTE).createOptional();
        this.FILECACHE_STAT_CACHE_SIZE = this.conf("spark.rapids.filecache.statcache.size").doc("Specifies the maximum number of entries in the file statistics cache").startupOnly().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(10000));
        this.FILECACHE_STAT_CACHE_TIMEOUT_MILLIS = this.conf("spark.rapids.filecache.statcache.timeoutMillis").doc("The amount of time in milliseconds that remote file statistics are cached to avoid redundantly gathering statistics of remote files that have been recently examined.").startupOnly().longConf().createWithDefault(BoxesRunTime.boxToLong((long)TimeUnit.SECONDS.toMillis(10L)));
        this.FILECACHE_FREE_SPACE_MINIMUM_FREE_SPACE_SIZE = this.conf("spark.rapids.filecache.minimumFreeSpace.bytes").doc("Specify the minimum amount of free space in the Spark local disks. When the amount of free space on the Spark local disks drops below this value, cache data will be removed automatically to free disk space. A zero or negative value will disable this feature. Note if multiple Spark applications running on the same node, or there are other applications running with heavy disk writing, the filecache may not drop caches in time and may cause full disk errors. Please increase this value for this case.").startupOnly().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)ByteUnit.GiB.toBytes(30L)));
        this.FILECACHE_FREE_SPACE_CHECK_INTERVAL = this.conf("spark.rapids.filecache.minimumFreeSpace.checkInterval").doc("Specifies the time interval, in seconds, between checks for free disk space.").startupOnly().longConf().createWithDefault(BoxesRunTime.boxToLong((long)5L));
        this.FILECACHE_ALLOW_PATH_REGEXP = this.conf("spark.rapids.filecache.allowPathRegexp").doc("A regular expression to decide which paths will be cached when the file cache is enabled. If this is not set, then all paths are allowed to cache. If a path is allowed by this regexp but blocked by spark.rapids.filecache.blockPathRegexp, then the path is blocked to cache.").startupOnly().stringConf().createOptional();
        this.FILECACHE_BLOCK_PATH_REGEXP = this.conf("spark.rapids.filecache.blockPathRegexp").doc("A regular expression to decide which paths will not be cached when the file cache is enabled. If a path is blocked by this regexp but is allowed by spark.rapids.filecache.allowPathRegexp, then the path is blocked.").startupOnly().stringConf().createOptional();
    }
}

