/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.filecache;

import com.nvidia.spark.rapids.filecache.ExecutorRegisterMsg;
import com.nvidia.spark.rapids.filecache.FileCacheConf;
import com.nvidia.spark.rapids.filecache.FileCacheConst$;
import com.nvidia.spark.rapids.filecache.FileCacheLocalityManager;
import com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$;
import com.nvidia.spark.rapids.filecache.FileCacheLocalityMsg;
import com.nvidia.spark.rapids.filecache.FileCachedMsg;
import com.nvidia.spark.rapids.filecache.FileRemovedMsg;
import com.nvidia.spark.rapids.filecache.OptimizedByteArrayOutputStream;
import com.nvidia.spark.rapids.internal.Arm$;
import com.nvidia.spark.rapids.internal.ThreadFactoryBuilder;
import com.nvidia.spark.rapids.internal.UTF8Utils$;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.filecache.FileCacheLocalDirsManager;
import org.apache.spark.sql.rapids.internal.TrampolineUtils$;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u000e\u001c\u0001\u0019B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")q\t\u0001C\u0001\u0011\"9A\n\u0001b\u0001\n\u0013i\u0005BB2\u0001A\u0003%a\nC\u0004e\u0001\t\u0007I\u0011B3\t\r9\u0004\u0001\u0015!\u0003g\u0011\u001dy\u0007A1A\u0005\nADa!\u001f\u0001!\u0002\u0013\t\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003}\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\u0006\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002&\u0001!I!!\u0016\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u001d\t\t\n\u0001C!\u0003'Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002$\u0002!\t%!*\u00039\u0019KG.Z\"bG\",Gj\\2bY&$\u00180T1oC\u001e,'/S7qY*\u0011A$H\u0001\nM&dWmY1dQ\u0016T!AH\u0010\u0002\rI\f\u0007/\u001b3t\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051aN^5eS\u0006T\u0011\u0001J\u0001\u0004G>l7\u0001A\n\u0005\u0001\u001dz3\u0007\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005!A.\u00198h\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\r=\u0013'.Z2u!\t\u0001\u0014'D\u0001\u001c\u0013\t\u00114D\u0001\rGS2,7)Y2iK2{7-\u00197jifl\u0015M\\1hKJ\u0004\"\u0001\u000e\u001f\u000e\u0003UR!AN\u001c\u0002\u0011%tG/\u001a:oC2T!\u0001\t\u001d\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0005\u0003{U\u0012q\u0001T8hO&tw-\u0001\u0003d_:4\u0007C\u0001\u0019A\u0013\t\t5DA\u0007GS2,7)Y2iK\u000e{gNZ\u0001\ngB\f'o[\"p]\u001a\u0004\"\u0001R#\u000e\u0003]J!AR\u001c\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\bF\u0002J\u0015.\u0003\"\u0001\r\u0001\t\u000by\u001a\u0001\u0019A \t\u000b\t\u001b\u0001\u0019A\"\u0002-\r,(O]3oi\u0006\u001bG/\u001b<f\u000bb,7-\u001e;peN,\u0012A\u0014\t\u0004\u001fZCV\"\u0001)\u000b\u0005E\u0013\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003'R\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005)\u0016!B:dC2\f\u0017BA,Q\u0005\r\u0019V\r\u001e\t\u00033\u0002t!A\u00170\u0011\u0005m#V\"\u0001/\u000b\u0005u+\u0013A\u0002\u001fs_>$h(\u0003\u0002`)\u00061\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF+A\fdkJ\u0014XM\u001c;BGRLg/Z#yK\u000e,Ho\u001c:tA\u0005AQ\r_3dkR|'/F\u0001g!\t9G.D\u0001i\u0015\tI'.\u0001\u0006d_:\u001cWO\u001d:f]RT!a[\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003[\"\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\nKb,7-\u001e;pe\u0002\nA\u0002\\8dC2$\u0015N]:NOJ,\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u00039QT!AH;\u000b\u0005Y<\u0014aA:rY&\u0011\u0001p\u001d\u0002\u001a\r&dWmQ1dQ\u0016dunY1m\t&\u00148/T1oC\u001e,'/A\u0007m_\u000e\fG\u000eR5sg6;'\u000fI\u0001\ngR|'/\u001a)bi\",\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}\\\u0013AA5p\u0013\r\t\u0019A \u0002\u0005\r&dW-\u0001\u0006ti>\u0014X\rU1uQ\u0002\nQa\u001d;pe\u0016,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005;\u0003\u001d\u0011xnY6tI\nLA!!\u0006\u0002\u0010\t9!k\\2lg\u0012\u0013\u0015AB:u_J,\u0007%A\u0005xe&$Xm\u00149ugV\u0011\u0011Q\u0004\t\u0005\u0003\u001b\ty\"\u0003\u0003\u0002\"\u0005=!\u0001D,sSR,w\n\u001d;j_:\u001c\u0018AC<sSR,w\n\u001d;tA\u0005aq-\u001a;M_\u000e\fG/[8ogR!\u0011\u0011FA\u001e!\u0015\tY#!\u000eY\u001d\u0011\ti#!\r\u000f\u0007m\u000by#C\u0001V\u0013\r\t\u0019\u0004V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9$!\u000f\u0003\u0007M+\u0017OC\u0002\u00024QCa!!\u0010\u0011\u0001\u0004A\u0016\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0002\u0013!\fg\u000e\u001a7f\u001bN<G\u0003BA\"\u0003\u0017\u0002B!!\u0012\u0002H5\tA+C\u0002\u0002JQ\u0013a!\u00118z%\u00164\u0007bBA'#\u0001\u0007\u0011qJ\u0001\u0004[N<\u0007c\u0001\u0019\u0002R%\u0019\u00111K\u000e\u0003)\u0019KG.Z\"bG\",Gj\\2bY&$\u00180T:h)\u0011\tI#a\u0016\t\u000f\u0005e#\u00031\u0001\u0002\\\u0005\u00191.Z=\u0011\r\u0005\u0015\u0013QLA1\u0013\r\ty\u0006\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000b\n\u0019'C\u0002\u0002fQ\u0013AAQ=uK\u0006yA-Z2pI\u0016dunY1uS>t7\u000f\u0006\u0003\u0002*\u0005-\u0004bBA7'\u0001\u0007\u00111L\u0001\te\u0006<()\u001f;fg\u0006Y\u0011\r\u001a3M_\u000e\fG/[8o)\u0019\t\u0019(!\u001f\u0002|A!\u0011QIA;\u0013\r\t9\b\u0016\u0002\u0005+:LG\u000f\u0003\u0004\u0002>Q\u0001\r\u0001\u0017\u0005\u0007\u0003{\"\u0002\u0019\u0001-\u0002\u00111|7-\u0019;j_:\faB]3n_Z,Gj\\2bi&|g\u000e\u0006\u0004\u0002t\u0005\r\u0015Q\u0011\u0005\u0007\u0003{)\u0002\u0019\u0001-\t\r\u0005uT\u00031\u0001Y\u000399(/\u001b;f\u0019>\u001c\u0017\r^5p]N$b!a\u001d\u0002\f\u00065\u0005bBA--\u0001\u0007\u00111\f\u0005\b\u0003\u001f3\u0002\u0019AA\u0015\u0003%awnY1uS>t7/A\u0003dY>\u001cX\r\u0006\u0002\u0002t\u0005Y\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0019>\u001c\u0017\r^5p]N$\u0002\"a\u001d\u0002\u001a\u0006m\u0015q\u0014\u0005\b\u00033B\u0002\u0019AA.\u0011\u001d\ti\n\u0007a\u0001\u0003S\t\u0011c\u001c:jO&t\u0017\r\u001c'pG\u0006$\u0018n\u001c8t\u0011\u0019\t\t\u000b\u0007a\u00011\u0006QQ\r_3dkR|'/\u00133\u0002\u001dI,Wn\u001c<f\u000bb,7-\u001e;peR!\u00111OAT\u0011\u0019\t\t+\u0007a\u00011\u0002")
public class FileCacheLocalityManagerImpl
implements FileCacheLocalityManager,
Logging {
    private final Set<String> com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors;
    private final ExecutorService executor;
    private final FileCacheLocalDirsManager localDirsMgr;
    private final File storePath;
    private final RocksDB com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store;
    private final WriteOptions writeOpts;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Set<String> com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors() {
        return this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private FileCacheLocalDirsManager localDirsMgr() {
        return this.localDirsMgr;
    }

    private File storePath() {
        return this.storePath;
    }

    public RocksDB com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store() {
        return this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store;
    }

    private WriteOptions writeOpts() {
        return this.writeOpts;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<String> getLocations(String filePath) {
        void var3_3;
        String normalizedFilePathString = new Path(filePath).toString();
        Seq<String> locations = this.getLocations(UTF8Utils$.MODULE$.toUTF8(normalizedFilePathString));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Locations for ").append(filePath).append(" = ").append(locations).toString());
        return var3_3;
    }

    @Override
    public Object handleMsg(FileCacheLocalityMsg msg) {
        Set<String> set;
        FileCacheLocalityMsg fileCacheLocalityMsg = msg;
        if (fileCacheLocalityMsg instanceof FileCachedMsg) {
            FileCachedMsg fileCachedMsg = (FileCachedMsg)fileCacheLocalityMsg;
            this.executor().submit(new Runnable(this, fileCachedMsg, msg){
                private final /* synthetic */ FileCacheLocalityManagerImpl $outer;
                private final FileCachedMsg x3$1;
                private final FileCacheLocalityMsg msg$1;

                public void run() {
                    try {
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Adding location ").append($this.x3$1.location()).append(" for ").append($this.x3$1.filePath()).toString());
                        this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$addLocation(this.x3$1.filePath(), this.x3$1.location());
                    }
                    catch (Exception e) {
                        this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Handing message ").append($this.msg$1).append(" failed").toString(), e);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.x3$1 = x3$1;
                    this.msg$1 = msg$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$1 ), $anonfun$run$2(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$1 )}, serializedLambda);
                }
            });
            set = null;
        } else if (fileCacheLocalityMsg instanceof FileRemovedMsg) {
            FileRemovedMsg fileRemovedMsg = (FileRemovedMsg)fileCacheLocalityMsg;
            this.executor().submit(new Runnable(this, fileRemovedMsg, msg){
                private final /* synthetic */ FileCacheLocalityManagerImpl $outer;
                private final FileRemovedMsg x4$1;
                private final FileCacheLocalityMsg msg$1;

                public void run() {
                    try {
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Removing location ").append($this.x4$1.location()).append(" for ").append($this.x4$1.filePath()).toString());
                        this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$removeLocation(this.x4$1.filePath(), this.x4$1.location());
                    }
                    catch (Exception e) {
                        this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Handing message ").append($this.msg$1).append(" failed").toString(), e);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.x4$1 = x4$1;
                    this.msg$1 = msg$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$2 ), $anonfun$run$4(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$2 )}, serializedLambda);
                }
            });
            set = null;
        } else if (fileCacheLocalityMsg instanceof ExecutorRegisterMsg) {
            ExecutorRegisterMsg executorRegisterMsg = (ExecutorRegisterMsg)fileCacheLocalityMsg;
            String executorId = executorRegisterMsg.executorId();
            this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors().add((Object)executorId);
            set = this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors();
        } else {
            throw new MatchError((Object)fileCacheLocalityMsg);
        }
        return set;
    }

    private Seq<String> getLocations(byte[] key) {
        return this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$decodeLocations(this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().get(key));
    }

    public Seq<String> com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$decodeLocations(byte[] rawBytes) {
        if (rawBytes == null) {
            return Nil$.MODULE$;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(rawBytes));
        int numEntries = in.readInt();
        ArrayBuffer entries = new ArrayBuffer(numEntries);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numEntries).foreach((Function1 & Serializable & scala.Serializable)x$1 -> FileCacheLocalityManagerImpl.$anonfun$decodeLocations$1(in, entries, BoxesRunTime.unboxToInt((Object)x$1)));
        return entries.toSeq();
    }

    public void com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$addLocation(String filePath, String location) {
        block0: {
            byte[] key = UTF8Utils$.MODULE$.toUTF8(filePath);
            Seq<String> allLocations = this.getLocations(key);
            if (allLocations.contains((Object)location)) break block0;
            String string = location;
            this.writeLocations(key, (Seq<String>)((Seq)allLocations.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        }
    }

    public void com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$removeLocation(String filePath, String location) {
        byte[] key = UTF8Utils$.MODULE$.toUTF8(filePath);
        Seq allLocations = (Seq)this.getLocations(key).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileCacheLocalityManagerImpl.$anonfun$removeLocation$1(location, x$3)));
        if (allLocations.isEmpty()) {
            this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().delete(this.writeOpts(), key);
        } else {
            this.writeLocations(key, (Seq<String>)allLocations);
        }
    }

    private void writeLocations(byte[] key, Seq<String> locations) {
        int count = locations.length();
        int rawBytesSize = 4 * (count + 1) + BoxesRunTime.unboxToInt((Object)((TraversableOnce)locations.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OptimizedByteArrayOutputStream obaos = new OptimizedByteArrayOutputStream(rawBytesSize);
        DataOutputStream out = new DataOutputStream(obaos);
        out.writeInt(count);
        locations.foreach((Function1 & Serializable & scala.Serializable)s -> {
            FileCacheLocalityManagerImpl.$anonfun$writeLocations$2(out, s);
            return BoxedUnit.UNIT;
        });
        this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().put(this.writeOpts(), key, obaos.exposeByteArray());
    }

    @Override
    public void close() {
        block0: {
            this.executor().shutdown();
            if (!this.executor().awaitTermination(60L, TimeUnit.SECONDS)) break block0;
            this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().close();
        }
    }

    public void com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$removeExecutorFromLocations(byte[] key, Seq<String> originalLocations, String executorId) {
        block1: {
            Seq newLocations;
            block0: {
                newLocations = (Seq)originalLocations.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileCacheLocalityManagerImpl.$anonfun$removeExecutorFromLocations$1(executorId, x$5)));
                if (!newLocations.isEmpty()) break block0;
                this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().delete(this.writeOpts(), key);
                break block1;
            }
            if (newLocations.size() == originalLocations.size()) break block1;
            this.writeLocations(key, (Seq<String>)newLocations);
        }
    }

    @Override
    public void removeExecutor(String executorId) {
        this.executor().submit(new Runnable(this, executorId){
            private final /* synthetic */ FileCacheLocalityManagerImpl $outer;
            private final String executorId$2;

            public void run() {
                try {
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Begin remove executor ").append($this.executorId$2).append(" from locations").toString());
                    long start = System.nanoTime();
                    this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors().remove((Object)this.executorId$2);
                    Arm$.MODULE$.withResource(this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store().newIterator(), (Function1 & Serializable & scala.Serializable)dbIter -> {
                        $anon$3.$anonfun$run$6(this, dbIter);
                        return BoxedUnit.UNIT;
                    });
                    long usedNS = System.nanoTime() - start;
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removing executor ").append($this.executorId$2).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(usedNS)).append(" MS").toString());
                }
                catch (Exception e) {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Remove executor ").append($this.executorId$2).append(" failed").toString(), e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$6($anon$3 $this, RocksIterator dbIter) {
                dbIter.seekToFirst();
                while (dbIter.isValid()) {
                    byte[] keyBytes = dbIter.key();
                    Seq<String> locations = $this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$decodeLocations(dbIter.value());
                    $this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removing executor ").append($this.executorId$2).append(" for file cache key: ").append(UTF8Utils$.MODULE$.fromUTF8(keyBytes)).toString());
                    $this.$outer.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$removeExecutorFromLocations(keyBytes, locations, $this.executorId$2);
                    dbIter.next();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorId$2 = executorId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$3 ), $anonfun$run$6$adapted(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$3 org.rocksdb.RocksIterator ), $anonfun$run$8(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$3 long ), $anonfun$run$9(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$3 ), $anonfun$run$7(com.nvidia.spark.rapids.filecache.FileCacheLocalityManagerImpl$$anon$3 byte[] )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$decodeLocations$1(DataInputStream in$1, ArrayBuffer entries$1, int x$1) {
        int numBytes = in$1.readInt();
        byte[] stringBytes = new byte[numBytes];
        in$1.readFully(stringBytes);
        return entries$1.$plus$eq((Object)UTF8Utils$.MODULE$.fromUTF8(stringBytes));
    }

    public static final /* synthetic */ boolean $anonfun$removeLocation$1(String location$1, String x$3) {
        String string = x$3;
        String string2 = location$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$writeLocations$2(DataOutputStream out$1, String s) {
        byte[] rawStringBytes = UTF8Utils$.MODULE$.toUTF8(s);
        out$1.writeInt(rawStringBytes.length);
        out$1.write(rawStringBytes);
    }

    public static final /* synthetic */ boolean $anonfun$removeExecutorFromLocations$1(String executorId$1, String x$5) {
        String string = TrampolineUtils$.MODULE$.getExecutorIdFromExecutorTaskLocationStr(x$5);
        String string2 = executorId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public FileCacheLocalityManagerImpl(FileCacheConf conf, SparkConf sparkConf) {
        Logging.$init$((Logging)this);
        this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$currentActiveExecutors = (Set)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TrampolineUtils$.MODULE$.getSparkDriverExecutorId()}));
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("filecache-locality-%d").setDaemon(true).build());
        RocksDB.loadLibrary();
        this.localDirsMgr = new FileCacheLocalDirsManager(FileCacheConst$.MODULE$.cacheDirOnDriverPrefix(), sparkConf);
        this.localDirsMgr().initForDriver();
        this.storePath = this.localDirsMgr().getFile("rapids-filecache-locality-db");
        int bloomFilterBitsPerKey = 10;
        BloomFilter bloomFilter = new BloomFilter((double)bloomFilterBitsPerKey, false);
        BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)bloomFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(10).setFormatVersion(5);
        Options options = new Options().setCreateIfMissing(true).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setCompressionType(CompressionType.LZ4_COMPRESSION).setTableFormatConfig((TableFormatConfig)tableFormatConfig);
        this.com$nvidia$spark$rapids$filecache$FileCacheLocalityManagerImpl$$store = RocksDB.open((Options)options, (String)this.storePath().toString());
        this.writeOpts = new WriteOptions().setSync(false);
    }
}

