/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.filecache;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.filecache.FileCacheDeadDirsUtils$;
import org.apache.spark.sql.rapids.filecache.FileCacheLocalDirsManager$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class FileCacheDeadDirsUtils$
implements Logging {
    public static FileCacheDeadDirsUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileCacheDeadDirsUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Future<?> asyncRemoveDeadFileCacheDirs(ScheduledExecutorService threadPool, Tuple2<String, File>[] executorIdCacheDirList, Set<String> activeExecutorIds) {
        return threadPool.submit(new Runnable(executorIdCacheDirList, activeExecutorIds){
            private final Tuple2[] executorIdCacheDirList$1;
            private final Set activeExecutorIds$1;

            public void run() {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.executorIdCacheDirList$1)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    anon.1.$anonfun$run$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(anon.1 $this, Tuple2 x0$1) {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String executorId = (String)tuple2._1();
                    File cacheDir = (File)tuple2._2();
                    if (!$this.activeExecutorIds$1.contains((Object)executorId)) {
                        FileCacheDeadDirsUtils$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Begin to remove dead dir ").append(cacheDir).append(" for executor ").append(executorId).toString());
                        FileCacheDeadDirsUtils$.MODULE$.org$apache$spark$sql$rapids$filecache$FileCacheDeadDirsUtils$$removeCache(cacheDir);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.executorIdCacheDirList$1 = executorIdCacheDirList$1;
                this.activeExecutorIds$1 = activeExecutorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.sql.rapids.filecache.FileCacheDeadDirsUtils$$anon$1 scala.Tuple2 ), $anonfun$run$2(java.io.File java.lang.String )}, serializedLambda);
            }
        });
    }

    public Tuple2<String, File>[] getExecutorAndCacheDirList(String[] sparkLocalDirs, String searchPrefixOfCacheDir) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkLocalDirs)).flatMap((Function1 & Serializable & scala.Serializable)sparkLocalDir -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileCacheDeadDirsUtils$.MODULE$.listFilesSafely(new File(sparkLocalDir), f -> f.isDirectory() && f.getName().startsWith(searchPrefixOfCacheDir$1)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).flatMap((Function1 & Serializable & scala.Serializable)filecacheDir -> Option$.MODULE$.option2Iterable(FileCacheLocalDirsManager$.MODULE$.readExecutorIDFile((File)filecacheDir).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e, filecacheDir))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void org$apache$spark$sql$rapids$filecache$FileCacheDeadDirsUtils$$removeCache(File cacheDir) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listFilesSafely(cacheDir, f -> f.isDirectory()))).foreach((Function1 & Serializable & scala.Serializable)child -> {
            FileCacheDeadDirsUtils$.MODULE$.deleteRecursively(child);
            return BoxedUnit.UNIT;
        });
        this.deleteRecursively(cacheDir);
    }

    private void deleteRecursively(File f) {
        if (f.isDirectory()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listFilesSafely(f, this.listFilesSafely$default$2()))).foreach((Function1 & Serializable & scala.Serializable)child -> {
                FileCacheDeadDirsUtils$.MODULE$.deleteRecursively(child);
                return BoxedUnit.UNIT;
            });
        }
        f.delete();
    }

    /*
     * WARNING - void declaration
     */
    private File[] listFilesSafely(File f, FileFilter filter) {
        void var3_3;
        File[] subFiles = f.listFiles(filter);
        return subFiles == null ? (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)) : var3_3;
    }

    private FileFilter listFilesSafely$default$2() {
        return null;
    }

    private FileCacheDeadDirsUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

