/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.filecache;

import com.nvidia.spark.rapids.filecache.ExecutorRegisterMsg;
import com.nvidia.spark.rapids.filecache.FileCacheConst$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.rapids.filecache.FileCacheDeadDirsUtils$;
import org.apache.spark.sql.rapids.filecache.FileCacheLocalDirsManager$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0011\"\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")A\n\u0001C\u0001\u001b\"I!\u000b\u0001a\u0001\u0002\u0004%Ia\u0015\u0005\n/\u0002\u0001\r\u00111A\u0005\naC\u0011B\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0007\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0003n\u0011%y\u0007\u00011A\u0001B\u0003&\u0011\rC\u0005q\u0001\u0001\u0007\t\u0019!C\tc\"I1\u000f\u0001a\u0001\u0002\u0004%\t\u0002\u001e\u0005\nm\u0002\u0001\r\u0011!Q!\nIDqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004z\u0001\u0001\u0006Ia\f\u0005\u0006u\u0002!\ta\u001f\u0005\t\u0003C\u0001A\u0011A\u0011\u0002$!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003\u0002CA+\u0001\u0011\u0005\u0011%a\u0016\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!!%\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\u0014\u0002!I!a\u0015\b\u000f\u0005U\u0015\u0005#\u0001\u0002\u0018\u001a1\u0001%\tE\u0001\u00033Ca\u0001T\u000e\u0005\u0002\u0005m\u0005\u0002CAO7\u0011\u0005\u0011%a(\t\u0011\u0005\u001d6\u0004\"\u0001\"\u0003SC\u0001\"a-\u001c\t\u0003\t\u0013Q\u0017\u0002\u001a\r&dWmQ1dQ\u0016dunY1m\t&\u00148/T1oC\u001e,'O\u0003\u0002#G\u0005Ia-\u001b7fG\u0006\u001c\u0007.\u001a\u0006\u0003I\u0015\naA]1qS\u0012\u001c(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0014\u0002\u0011%tG/\u001a:oC2L!AO\u001c\u0003\u000f1{wmZ5oO\u0006Qa.Y7f!J,g-\u001b=\u0011\u0005u\"eB\u0001 C!\ty\u0014'D\u0001A\u0015\t\tU&\u0001\u0004=e>|GOP\u0005\u0003\u0007F\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111)M\u0001\u0005G>tg\r\u0005\u0002J\u00156\tq%\u0003\u0002LO\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0003\u0016\u000b\u0005\u0002P\u00015\t\u0011\u0005C\u0003<\u0007\u0001\u0007A\bC\u0003H\u0007\u0001\u0007\u0001*\u0001\ntk\n$\u0015N]:QKJdunY1m\t&\u0014X#\u0001+\u0011\u0005A*\u0016B\u0001,2\u0005\rIe\u000e^\u0001\u0017gV\u0014G)\u001b:t!\u0016\u0014Hj\\2bY\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003aiK!aW\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b;\u0016\t\t\u00111\u0001U\u0003\rAH%M\u0001\u0014gV\u0014G)\u001b:t!\u0016\u0014Hj\\2bY\u0012K'\u000fI\u0001\nY>\u001c\u0017\r\u001c#jeN,\u0012!\u0019\t\u0004a\t$\u0017BA22\u0005\u0015\t%O]1z!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0002j_*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u00111\u0015\u000e\\3\u0002\u001b1|7-\u00197ESJ\u001cx\fJ3r)\tIf\u000eC\u0004^\u0011\u0005\u0005\t\u0019A1\u0002\u00151|7-\u00197ESJ\u001c\b%A\u0004tk\n$\u0015N]:\u0016\u0003I\u00042\u0001\r2b\u0003-\u0019XO\u0019#jeN|F%Z9\u0015\u0005e+\bbB/\f\u0003\u0003\u0005\rA]\u0001\tgV\u0014G)\u001b:tA\u0005a1\u000f[;uI><h\u000eS8pWV\tq&A\u0007tQV$Hm\\<o\u0011>|7\u000eI\u0001\u0010S:LGOR8s\u000bb,7-\u001e;peR!\u0011\f`A\u0007\u0011\u0015ix\u00021\u0001\u007f\u0003)!\bN]3bIB{w\u000e\u001c\t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\b!\fA!\u001e;jY&!\u00111BA\u0001\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\b\u0003\u001fy\u0001\u0019AA\t\u00035\u0001H.^4j]\u000e{g\u000e^3yiB!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011A\u00029mk\u001eLgNC\u0002\u0002\u001c\u001d\n1!\u00199j\u0013\u0011\ty\"!\u0006\u0003\u001bAcWoZ5o\u0007>tG/\u001a=u\u0003I\u0011X-\\8wK\u0012+\u0017\rZ\"bG\",G)\u001b:\u0015\u0015\u0005\u0015\u00121IA#\u0003\u000f\ni\u0005\r\u0003\u0002(\u0005E\u0002#B@\u0002*\u00055\u0012\u0002BA\u0016\u0003\u0003\u0011aAR;ukJ,\u0007\u0003BA\u0018\u0003ca\u0001\u0001B\u0006\u00024A\t\t\u0011!A\u0003\u0002\u0005U\"aA0%cE!\u0011qGA\u001f!\r\u0001\u0014\u0011H\u0005\u0004\u0003w\t$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005}\u0012bAA!c\t\u0019\u0011I\\=\t\u000bu\u0004\u0002\u0019\u0001@\t\u000f\u0005=\u0001\u00031\u0001\u0002\u0012!9\u0011\u0011\n\tA\u0002\u0005-\u0013AD:qCJ\\Gj\\2bY\u0012K'o\u001d\t\u0004a\td\u0004BBA(!\u0001\u0007A(A\u0007baBd\u0017nY1uS>t\u0017\nZ\u0001\u000eS:LGOR8s\tJLg/\u001a:\u0015\u0003e\u000b\u0001C]3hSN$XM]#yK\u000e,Ho\u001c:\u0015\t\u0005e\u0013\u0011\u000e\t\u0006\u00037\n)\u0007P\u0007\u0003\u0003;RA!a\u0018\u0002b\u00059Q.\u001e;bE2,'bAA2c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0004'\u0016$\bbBA\b%\u0001\u0007\u0011\u0011C\u0001\u000bGJ,\u0017\r^3ESJ\u001cH#B-\u0002p\u0005E\u0004bBA%'\u0001\u0007\u00111\n\u0005\u0007\u0003\u001f\u001a\u0002\u0019\u0001\u001f\u0002\u000f\u001d,GOR5mKR\u0019A-a\u001e\t\r\u0005eD\u00031\u0001=\u0003!1\u0017\u000e\\3oC6,\u0017AD4fiV\u001b\u0018M\u00197f'B\f7-Z\u000b\u0003\u0003\u007f\u00022\u0001MAA\u0013\r\t\u0019)\r\u0002\u0005\u0019>tw-A\bde\u0016\fG/\u001a'pG\u0006dG)\u001b:t)\u0015\t\u0017\u0011RAF\u0011\u001d\tIE\u0006a\u0001\u0003\u0017Ba!a\u0014\u0017\u0001\u0004a\u0014aD1eINCW\u000f\u001e3po:Dun\\6\u0015\u0003=\nAa\u001d;pa\u00061Am\\*u_B\f\u0011DR5mK\u000e\u000b7\r[3M_\u000e\fG\u000eR5sg6\u000bg.Y4feB\u0011qjG\n\u00047=*DCAAL\u0003U9W\r\u001e$jY\u0016\u001c\u0015m\u00195f\t&\u0014\bK]3gSb$R\u0001PAQ\u0003KCa!a)\u001e\u0001\u0004a\u0014AD2bG\",G)\u001b:Qe\u00164\u0017\u000e\u001f\u0005\u0007\u0003\u001fj\u0002\u0019\u0001\u001f\u0002)\r\u0014X-\u0019;f\u000bb,7-\u001e;pe&#g)\u001b7f)\u0015I\u00161VAX\u0011\u0019\tiK\ba\u0001I\u0006aa-\u001b7fG\u0006\u001c\u0007.\u001a#je\"1\u0011\u0011\u0017\u0010A\u0002q\n!\"\u001a=fGV$xN]%e\u0003I\u0011X-\u00193Fq\u0016\u001cW\u000f^8s\u0013\u00123\u0015\u000e\\3\u0015\t\u0005]\u0016Q\u0018\t\u0005a\u0005eF(C\u0002\u0002<F\u0012aa\u00149uS>t\u0007BBA`?\u0001\u0007A-\u0001\u0005dC\u000eDW\rR5s\u0001")
public class FileCacheLocalDirsManager
implements Logging {
    private final String namePrefix;
    private final SparkConf conf;
    private int subDirsPerLocalDir;
    private File[] localDirs;
    private File[][] subDirs;
    private final Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    private void subDirsPerLocalDir_$eq(int x$1) {
        this.subDirsPerLocalDir = x$1;
    }

    private File[] localDirs() {
        return this.localDirs;
    }

    private void localDirs_$eq(File[] x$1) {
        this.localDirs = x$1;
    }

    public File[][] subDirs() {
        return this.subDirs;
    }

    public void subDirs_$eq(File[][] x$1) {
        this.subDirs = x$1;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    public void initForExecutor(ScheduledExecutorService threadPool, PluginContext pluginContext) {
        String[] sparkLocalDirs = Utils$.MODULE$.getConfiguredLocalDirs(this.conf);
        String applicationId = this.conf.get("spark.app.id", FileCacheConst$.MODULE$.emptyApplicationId());
        this.removeDeadCacheDir(threadPool, pluginContext, sparkLocalDirs, applicationId);
        this.createDirs(sparkLocalDirs, applicationId);
    }

    public Future<?> removeDeadCacheDir(ScheduledExecutorService threadPool, PluginContext pluginContext, String[] sparkLocalDirs, String applicationId) {
        Future<Object> future;
        String string = applicationId;
        String string2 = FileCacheConst$.MODULE$.emptyApplicationId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            String searchPrefix = FileCacheLocalDirsManager$.MODULE$.getFileCacheDirPrefix(this.namePrefix, applicationId);
            Tuple2<String, File>[] appIdExecutorIdCacheDirList = FileCacheDeadDirsUtils$.MODULE$.getExecutorAndCacheDirList(sparkLocalDirs, searchPrefix);
            Set<String> activeExecutorIds = this.registerExecutor(pluginContext);
            future = FileCacheDeadDirsUtils$.MODULE$.asyncRemoveDeadFileCacheDirs(threadPool, appIdExecutorIdCacheDirList, activeExecutorIds);
        } else {
            this.registerExecutor(pluginContext);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No application ID found, skipping dead filecache dir cleanup.");
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    public void initForDriver() {
        String[] sparkLocalDirs = Utils$.MODULE$.getConfiguredLocalDirs(this.conf);
        String applicationId = this.conf.get("spark.app.id", FileCacheConst$.MODULE$.emptyApplicationId());
        this.createDirs(sparkLocalDirs, applicationId);
    }

    public Set<String> registerExecutor(PluginContext pluginContext) {
        return (Set)pluginContext.ask((Object)new ExecutorRegisterMsg(SparkEnv$.MODULE$.get().executorId()));
    }

    private void createDirs(String[] sparkLocalDirs, String applicationId) {
        this.subDirsPerLocalDir_$eq(BoxesRunTime.unboxToInt((Object)this.conf.get(package$.MODULE$.DISKSTORE_SUB_DIRECTORIES())));
        this.localDirs_$eq(this.createLocalDirs(sparkLocalDirs, applicationId));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.subDirs_$eq((File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable & scala.Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class))));
        String executorId = SparkEnv$.MODULE$.get().executorId();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            FileCacheLocalDirsManager$.MODULE$.createExecutorIdFile(x$1, executorId);
            return BoxedUnit.UNIT;
        });
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash((Object)filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                Object object;
                File newDir = new File(this.localDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                if (!newDir.exists()) {
                    Path path = newDir.toPath();
                    object = Files.createDirectory(path, new FileAttribute[0]);
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public long getUsableSpace() {
        scala.collection.immutable.Set fileStoreSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).map((Function1 & Serializable & scala.Serializable)f -> Files.getFileStore(f.toPath()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStore.class))))).toSet();
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)fileStoreSet.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getUsableSpace()), Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private File[] createLocalDirs(String[] sparkLocalDirs, String applicationId) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkLocalDirs)).flatMap((Function1 & Serializable & scala.Serializable)rootDir -> {
            Iterable iterable;
            try {
                File localDir = Utils$.MODULE$.createDirectory(rootDir, FileCacheLocalDirsManager$.MODULE$.getFileCacheDirPrefix($this.namePrefix, applicationId));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)localDir));
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        if (this.localDirs() == null) {
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)localDir -> {
            FileCacheLocalDirsManager.$anonfun$doStop$1(this, localDir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$doStop$1(FileCacheLocalDirsManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public FileCacheLocalDirsManager(String namePrefix, SparkConf conf) {
        this.namePrefix = namePrefix;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.shutdownHook = this.addShutdownHook();
    }
}

