/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.internal;

import com.nvidia.spark.rapids.internal.PlanUtils$;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.ExecSubqueryExpression;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.ReusedSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ExecutionPlanCaptureCallback$ {
    public static ExecutionPlanCaptureCallback$ MODULE$;
    private boolean shouldCapture;
    private final ArrayBuffer<SparkPlan> execPlans;

    static {
        new ExecutionPlanCaptureCallback$();
    }

    public synchronized void org$apache$spark$sql$rapids$internal$ExecutionPlanCaptureCallback$$captureIfNeeded(QueryExecution qe) {
        block0: {
            if (!this.shouldCapture) break block0;
            this.execPlans.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{qe.executedPlan()}));
        }
    }

    public void startCapture() {
        this.startCapture(10000L);
    }

    public void startCapture(long timeoutMillis) {
        SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable & scala.Serializable)spark -> {
            ExecutionPlanCaptureCallback$.$anonfun$startCapture$1(timeoutMillis, spark);
            return BoxedUnit.UNIT;
        });
        ExecutionPlanCaptureCallback$ executionPlanCaptureCallback$ = this;
        synchronized (executionPlanCaptureCallback$) {
            this.execPlans.clear();
            this.shouldCapture = true;
        }
    }

    public SparkPlan[] getResultsWithTimeout(long timeoutMs) {
        SparkPlan[] sparkPlanArray;
        try {
            SparkSession spark = SparkSession$.MODULE$.active();
            spark.sparkContext().listenerBus().waitUntilEmpty(timeoutMs);
            ExecutionPlanCaptureCallback$ executionPlanCaptureCallback$ = this;
            synchronized (executionPlanCaptureCallback$) {
                SparkPlan[] sparkPlanArray2 = (SparkPlan[])this.execPlans.toArray(ClassTag$.MODULE$.apply(SparkPlan.class));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var4_3
                sparkPlanArray = sparkPlanArray2;
            }
        }
        catch (Throwable throwable) {
            ExecutionPlanCaptureCallback$ executionPlanCaptureCallback$ = this;
            synchronized (executionPlanCaptureCallback$) {
                this.shouldCapture = false;
                this.execPlans.clear();
            }
            throw throwable;
        }
        ExecutionPlanCaptureCallback$ executionPlanCaptureCallback$ = this;
        synchronized (executionPlanCaptureCallback$) {
            this.shouldCapture = false;
            this.execPlans.clear();
        }
        return sparkPlanArray;
    }

    public long getResultsWithTimeout$default$1() {
        return 10000L;
    }

    public SparkPlan extractExecutedPlan(SparkPlan plan) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = plan;
        if (sparkPlan2 instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan2;
            sparkPlan = adaptiveSparkPlanExec.executedPlan();
        } else if (sparkPlan2 instanceof CommandResultExec) {
            CommandResultExec commandResultExec = (CommandResultExec)sparkPlan2;
            sparkPlan = commandResultExec.commandPhysicalPlan();
        } else {
            sparkPlan = plan;
        }
        return sparkPlan;
    }

    public void assertCapturedAndGpuFellBack(ArrayList<String> fallbackCpuClassList, long timeoutMs) {
        SparkPlan[] gpuPlans = this.getResultsWithTimeout(timeoutMs);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gpuPlans)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Did not capture a plan");
        fallbackCpuClassList.forEach(fallbackCpuClass -> MODULE$.assertDidFallBack(gpuPlans, (String)fallbackCpuClass));
    }

    public void assertCapturedAndGpuFellBack(String fallbackCpuClass, long timeoutMs) {
        SparkPlan[] gpuPlans = this.getResultsWithTimeout(timeoutMs);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gpuPlans)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Did not capture a plan");
        this.assertDidFallBack(gpuPlans, fallbackCpuClass);
    }

    public long assertCapturedAndGpuFellBack$default$2() {
        return 2000L;
    }

    public void assertDidFallBack(SparkPlan[] gpuPlans, String fallbackCpuClass) {
        SparkPlan[] executedPlans = (SparkPlan[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gpuPlans)).map((Function1 & Serializable & scala.Serializable)plan -> MODULE$.extractExecutedPlan((SparkPlan)plan), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkPlan.class)));
        boolean found = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedPlans)).exists((Function1 & Serializable & scala.Serializable)executedPlan -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.$anonfun$assertDidFallBack$2(fallbackCpuClass, executedPlan)));
        Predef$.MODULE$.assert(found, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Could not find ").append(fallbackCpuClass).append(" in the GPU plans:\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedPlans)).mkString("\n")).toString());
    }

    public void assertDidFallBack(SparkPlan gpuPlan, String fallbackCpuClass) {
        SparkPlan executedPlan = this.extractExecutedPlan(gpuPlan);
        Predef$.MODULE$.assert(executedPlan.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$2, fallbackCpuClass))).isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Could not find ").append(fallbackCpuClass).append(" in the GPU plan\n").append(executedPlan).toString());
    }

    public void assertDidFallBack(Dataset<Row> df, String fallbackCpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertDidFallBack((SparkPlan[])((Object[])new SparkPlan[]{executedPlan}), fallbackCpuClass);
    }

    public void assertContains(SparkPlan gpuPlan, String className) {
        Predef$.MODULE$.assert(this.containsPlan(gpuPlan, className, this.containsPlan$default$3()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Could not find ").append(className).append(" in the Spark plan\n").append(gpuPlan).toString());
    }

    public void assertContains(Dataset<Row> df, String gpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertContains(executedPlan, gpuClass);
    }

    public void assertNotContain(SparkPlan gpuPlan, String className) {
        Predef$.MODULE$.assert(!this.containsPlan(gpuPlan, className, this.containsPlan$default$3()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("We found ").append(className).append(" in the Spark plan\n").append(gpuPlan).toString());
    }

    public void assertNotContain(Dataset<Row> df, String gpuClass) {
        SparkPlan executedPlan = df.queryExecution().executedPlan();
        this.assertNotContain(executedPlan, gpuClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean didFallBack(Expression exp, String fallbackCpuClass) {
        if (!exp.getClass().getCanonicalName().equals("com.nvidia.spark.rapids.GpuExpression")) {
            String string = PlanUtils$.MODULE$.getBaseNameFromClass(exp.getClass().getName());
            String string2 = fallbackCpuClass;
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
        }
        if (!exp.children().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$3, fallbackCpuClass)))) return false;
        return true;
    }

    private boolean didFallBack(SparkPlan plan, String fallbackCpuClass) {
        SparkPlan executedPlan = this.extractExecutedPlan(plan);
        return !executedPlan.getClass().getCanonicalName().equals("com.nvidia.spark.rapids.GpuExec") && PlanUtils$.MODULE$.sameClass(executedPlan, fallbackCpuClass) || executedPlan.expressions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$4, fallbackCpuClass)));
    }

    private boolean containsExpression(Expression exp, String className, Map<String, Regex> regexMap) {
        return exp.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.$anonfun$containsExpression$1(className, regexMap, x0$1))).nonEmpty();
    }

    private boolean containsPlan(SparkPlan plan, String className, Map<String, Regex> regexMap) {
        return plan.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.$anonfun$containsPlan$1(className, regexMap, x0$1))).nonEmpty();
    }

    private Map<String, Regex> containsPlan$default$3() {
        return Map$.MODULE$.empty();
    }

    public static final /* synthetic */ void $anonfun$startCapture$1(long timeoutMillis$1, SparkSession spark) {
        spark.sparkContext().listenerBus().waitUntilEmpty(timeoutMillis$1);
    }

    public static final /* synthetic */ boolean $anonfun$assertDidFallBack$2(String fallbackCpuClass$1, SparkPlan executedPlan) {
        return executedPlan.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.didFallBack(x$1, fallbackCpuClass$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$containsExpression$1(String className$3, Map regexMap$1, Expression x0$1) {
        boolean bl;
        Expression expression = x0$1;
        String string = PlanUtils$.MODULE$.getBaseNameFromClass(expression.getClass().getName());
        String string2 = className$3;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            bl = true;
        } else if (expression instanceof ExecSubqueryExpression) {
            ExecSubqueryExpression execSubqueryExpression = (ExecSubqueryExpression)expression;
            bl = MODULE$.containsPlan((SparkPlan)execSubqueryExpression.plan(), className$3, (Map<String, Regex>)regexMap$1);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$containsPlan$1(String className$4, Map regexMap$2, SparkPlan x0$1) {
        boolean bl;
        SparkPlan sparkPlan = x0$1;
        if (PlanUtils$.MODULE$.sameClass(sparkPlan, className$4)) {
            bl = true;
        } else if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            bl = MODULE$.containsPlan(adaptiveSparkPlanExec.executedPlan(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)sparkPlan;
            bl = MODULE$.containsPlan(queryStageExec.plan(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof ReusedSubqueryExec) {
            ReusedSubqueryExec reusedSubqueryExec = (ReusedSubqueryExec)sparkPlan;
            bl = MODULE$.containsPlan((SparkPlan)reusedSubqueryExec.child(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan;
            bl = MODULE$.containsPlan((SparkPlan)reusedExchangeExec.child(), className$4, (Map<String, Regex>)regexMap$2);
        } else if (sparkPlan.expressions().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutionPlanCaptureCallback$.MODULE$.containsExpression(x$5, className$4, (Map<String, Regex>)regexMap$2)))) {
            bl = true;
        } else if (sparkPlan != null) {
            SparkPlan sparkPlan2 = sparkPlan;
            String sparkPlanStringForRegex = sparkPlan2.verboseStringWithSuffix(1000);
            bl = ((Regex)regexMap$2.getOrElseUpdate((Object)className$4, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(className$4)).r())).findFirstIn((CharSequence)sparkPlanStringForRegex).nonEmpty();
        } else {
            throw new MatchError((Object)sparkPlan);
        }
        return bl;
    }

    private ExecutionPlanCaptureCallback$() {
        MODULE$ = this;
        this.shouldCapture = false;
        this.execPlans = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }
}

