/*
 * Decompiled with CFR 0.152.
 */
package com.obiscr;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.obiscr.OpenAIException;
import com.obiscr.OpenAISession;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenAIAuth {
    private Proxy proxy;
    private String email;
    private String password;
    private String sessionToken;
    private final String userAgent = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36";
    private List<HttpCookie> cookies;

    public OpenAIAuth(String email, String password) {
        new OpenAIAuth(email, password, null);
    }

    public OpenAIAuth(String email, String password, Proxy proxy) {
        this.email = email;
        this.password = password;
        this.proxy = proxy;
        try {
            this.begin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String urlEncode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    private void begin() throws UnsupportedEncodingException, OpenAIException {
        String url = "https://explorer.api.openai.com/api/auth/csrf";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Accept", "*/*");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", this.userAgent);
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Referer", "https://explorer.api.openai.com/auth/login");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).headerMap(headers, true)).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() != 200 || !response.header("Content-Type").contains("json")) {
            throw new OpenAIException("begin", response.getStatus(), response.body());
        }
        JSONObject object = JSON.parseObject((String)response.body());
        this.step1(object.getString("csrfToken"));
    }

    private void step1(String token) throws UnsupportedEncodingException, OpenAIException {
        String url = "https://explorer.api.openai.com/api/auth/signin/auth0?prompt=login";
        String payload = "callbackUrl=%2F&csrfToken=" + token + "&json=true";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "explorer.api.openai.com");
        headers.put("User-Agent", this.userAgent);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Accept", "*/*");
        headers.put("Sec-Gpc", "1");
        headers.put("Accept-Language", "en-US,en;q=0.8");
        headers.put("Origin", "https://explorer.api.openai.com");
        headers.put("Sec-Fetch-Site", "same-origin");
        headers.put("Sec-Fetch-Mode", "cors");
        headers.put("Sec-Fetch-Dest", "empty");
        headers.put("Referer", "https://explorer.api.openai.com/auth/login");
        headers.put("Accept-Encoding", "gzip, deflate");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).headerMap(headers, true)).body(payload).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() == 200 && response.header("Content-Type").contains("json")) {
            JSONObject object = JSON.parseObject((String)response.body());
            url = object.getString("url");
            if (url.equals("https://explorer.api.openai.com/api/auth/error?error=OAuthSignin") || url.contains("error")) {
                throw new OpenAIException("__part_one", response.getStatus(), "You have been rate limited. Please try again later.");
            }
        } else {
            throw new OpenAIException("__part_one", response.getStatus(), response.body());
        }
        this.step2(url);
    }

    private void step2(String url) throws UnsupportedEncodingException, OpenAIException {
        Matcher matcher;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", this.userAgent);
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Referer", "https://explorer.api.openai.com/");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).headerMap(headers, true)).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() == 302 || response.getStatus() == 200) {
            String regex = "state=([\\w\\d]+)";
            Pattern pattern = Pattern.compile(regex);
            matcher = pattern.matcher(response.body());
            if (!matcher.find()) {
                throw new OpenAIException("__part_two", response.getStatus(), "state not matched in:" + response.body());
            }
        } else {
            throw new OpenAIException("__part_two", response.getStatus(), response.body());
        }
        String stateValue = matcher.group(1);
        this.step3(stateValue);
    }

    private void step3(String state) throws UnsupportedEncodingException, OpenAIException {
        String url = "https://auth0.openai.com/u/login/identifier?state=" + state;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", this.userAgent);
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Referer", "https://explorer.api.openai.com/");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).headerMap(headers, true)).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() != 200) {
            throw new OpenAIException("__part_three", response.getStatus(), response.body());
        }
        this.step4(state);
    }

    private void step4(String state) throws UnsupportedEncodingException, OpenAIException {
        String url = "https://auth0.openai.com/u/login/identifier?state=" + state;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("state", state);
        payload.put("username", this.email);
        payload.put("js-available", false);
        payload.put("webauthn-available", true);
        payload.put("is-brave", false);
        payload.put("webauthn-platform-available", true);
        payload.put("action", "default");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Origin", "https://auth0.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("User-Agent", this.userAgent);
        headers.put("Referer", "https://auth0.openai.com/u/login/identifier?state=" + state);
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).headerMap(headers, true)).form(payload).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            throw new OpenAIException("__part_four", response.getStatus(), "Your email address is invalid.");
        }
        this.step5(state);
    }

    private void step5(String state) throws UnsupportedEncodingException, OpenAIException {
        Matcher matcher;
        String url = "https://auth0.openai.com/u/login/password?state=" + state;
        String emailUrlEncoded = OpenAIAuth.urlEncode(this.email);
        String passwordUrlEncoded = OpenAIAuth.urlEncode(this.password);
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("state", state);
        payload.put("username", emailUrlEncoded);
        payload.put("password", passwordUrlEncoded);
        payload.put("action", "default");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Origin", "https://auth0.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("User-Agent", this.userAgent);
        headers.put("Referer", "https://auth0.openai.com/u/login/password?state=" + state);
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).headerMap(headers, true)).setFollowRedirects(false).form(payload).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() == 200 || response.getStatus() == 302) {
            String regex = "state=([\\w\\d]+)";
            Pattern pattern = Pattern.compile(regex);
            matcher = pattern.matcher(response.body());
            if (!matcher.find()) {
                throw new OpenAIException("__part_five", response.getStatus(), "state not matched in:" + response.body());
            }
        } else {
            throw new OpenAIException("__part_five", response.getStatus(), "Your credentials are invalid.");
        }
        String newState = matcher.group(1);
        this.step6(state, newState);
    }

    private void step6(String oldState, String newState) throws OpenAIException {
        String url = "https://auth0.openai.com/authorize/resume?state=" + newState;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", this.userAgent);
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Referer", "https://auth0.openai.com/u/login/password?state=" + oldState);
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).headerMap(headers, true)).setFollowRedirects(false).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() != 302) {
            throw new OpenAIException("__part_six", response.getStatus(), response.body());
        }
        String redirectUrl = response.header("location");
        this.step7(redirectUrl, url);
    }

    private void step7(String redirectUrl, String previousUrl) throws OpenAIException {
        String url = redirectUrl;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Accept", "application/json");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", this.userAgent);
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Referer", previousUrl);
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).setFollowRedirects(false).headerMap(headers, true)).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            throw new OpenAIException("__part_seven", response.getStatus(), response.body());
        }
        this.sessionToken = response.getCookieValue("__Secure-next-auth.session-token");
    }

    public OpenAISession auth() throws OpenAIException {
        HttpResponse response = HttpUtil.createGet((String)"https://explorer.api.openai.com/api/auth/session").cookie("__Secure-next-auth.session-token=" + this.sessionToken).cookie(this.cookies).setProxy(this.proxy).execute();
        this.cookies = response.getCookies();
        if (response.getStatus() == 200) {
            return new OpenAISession().parse(response.body());
        }
        throw new OpenAIException("getAccessToken", response.getStatus(), response.body());
    }
}

