/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.axis.TickData;
import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.marker.MarkerData;
import com.orsoncharts.marker.MarkerDataType;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartBox3D {
    private double xLength;
    private double yLength;
    private double zLength;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private List<TickData> xTicks;
    private List<TickData> yTicks;
    private List<TickData> zTicks;
    private List<MarkerData> xMarkers;
    private List<MarkerData> yMarkers;
    private List<MarkerData> zMarkers;
    private Color color;
    private ChartBoxFace faceA;
    private ChartBoxFace faceB;
    private ChartBoxFace faceC;
    private ChartBoxFace faceD;
    private ChartBoxFace faceE;
    private ChartBoxFace faceF;

    public ChartBox3D(double xLength, double yLength, double zLength, double xOffset, double yOffset, double zOffset, Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.xLength = xLength;
        this.yLength = yLength;
        this.zLength = zLength;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.color = color;
        this.xTicks = new ArrayList<TickData>(0);
        this.yTicks = new ArrayList<TickData>(0);
        this.zTicks = new ArrayList<TickData>(0);
        this.xMarkers = new ArrayList<MarkerData>(0);
        this.yMarkers = new ArrayList<MarkerData>(0);
        this.zMarkers = new ArrayList<MarkerData>(0);
    }

    public List<TickData> getXTicks() {
        return this.xTicks;
    }

    public void setXTicks(List<TickData> ticks) {
        ArgChecks.nullNotPermitted(ticks, "ticks");
        this.xTicks = ticks;
    }

    public List<TickData> getYTicks() {
        return this.yTicks;
    }

    public void setYTicks(List<TickData> ticks) {
        ArgChecks.nullNotPermitted(ticks, "ticks");
        this.yTicks = ticks;
    }

    public List<TickData> getZTicks() {
        return this.zTicks;
    }

    public void setZTicks(List<TickData> ticks) {
        ArgChecks.nullNotPermitted(ticks, "ticks");
        this.zTicks = ticks;
    }

    public List<MarkerData> getXMarkers() {
        return this.xMarkers;
    }

    public void setXMarkers(List<MarkerData> markers) {
        ArgChecks.nullNotPermitted(markers, "markers");
        this.xMarkers = markers;
    }

    public List<MarkerData> getYMarkers() {
        return this.yMarkers;
    }

    public void setYMarkers(List<MarkerData> markers) {
        ArgChecks.nullNotPermitted(markers, "markers");
        this.yMarkers = markers;
    }

    public List<MarkerData> getZMarkers() {
        return this.zMarkers;
    }

    public void setZMarkers(List<MarkerData> markers) {
        ArgChecks.nullNotPermitted(markers, "markers");
        this.zMarkers = markers;
    }

    public ChartBoxFace faceA() {
        return this.faceA;
    }

    public ChartBoxFace faceB() {
        return this.faceB;
    }

    public ChartBoxFace faceC() {
        return this.faceC;
    }

    public ChartBoxFace faceD() {
        return this.faceD;
    }

    public ChartBoxFace faceE() {
        return this.faceE;
    }

    public ChartBoxFace faceF() {
        return this.faceF;
    }

    public Object3D createObject3D() {
        TickData td3;
        TickData td2;
        TickData td1;
        TickData td0;
        Object3D box = new Object3D(this.color);
        Point3D v0 = new Point3D(this.xOffset, this.yOffset, this.zOffset);
        Point3D v1 = new Point3D(this.xLength + this.xOffset, this.yOffset, this.zOffset);
        Point3D v2 = new Point3D(this.xLength + this.xOffset, this.yLength + this.yOffset, this.zOffset);
        Point3D v3 = new Point3D(this.xOffset, this.yLength + this.yOffset, this.zOffset);
        Point3D v4 = new Point3D(this.xOffset, this.yLength + this.yOffset, this.zLength + this.zOffset);
        Point3D v5 = new Point3D(this.xOffset, this.yOffset, this.zLength + this.zOffset);
        Point3D v6 = new Point3D(this.xLength + this.xOffset, this.yOffset, this.zLength + this.zOffset);
        Point3D v7 = new Point3D(this.xLength + this.xOffset, this.yLength + this.yOffset, this.zLength + this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        box.addVertex(v4);
        box.addVertex(v5);
        box.addVertex(v6);
        box.addVertex(v7);
        this.faceA = new ChartBoxFace(box, new int[]{0, 5, 6, 1});
        this.faceB = new ChartBoxFace(box, new int[]{0, 1, 2, 3});
        this.faceC = new ChartBoxFace(box, new int[]{7, 4, 3, 2});
        this.faceD = new ChartBoxFace(box, new int[]{5, 4, 7, 6});
        this.faceE = new ChartBoxFace(box, new int[]{0, 3, 4, 5});
        this.faceF = new ChartBoxFace(box, new int[]{6, 7, 2, 1});
        box.addFace(this.faceA);
        box.addFace(this.faceB);
        box.addFace(this.faceC);
        box.addFace(this.faceD);
        box.addFace(this.faceE);
        box.addFace(this.faceF);
        int base = 8;
        for (TickData t : this.xTicks) {
            double xx = this.xOffset + this.xLength * t.getPos();
            box.addVertex(xx, this.yOffset, this.zOffset);
            box.addVertex(xx, this.yOffset, this.zOffset + this.zLength);
            box.addVertex(xx, this.yOffset + this.yLength, this.zOffset + this.zLength);
            box.addVertex(xx, this.yOffset + this.yLength, this.zOffset);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceA.addXTicks(td0, td1);
            this.faceB.addXTicks(td0, td3);
            this.faceC.addXTicks(td3, td2);
            this.faceD.addXTicks(td2, td1);
            base += 4;
        }
        for (TickData t : this.yTicks) {
            double yy = this.yOffset + this.yLength * t.getPos();
            box.addVertex(this.xOffset, yy, this.zOffset);
            box.addVertex(this.xOffset + this.xLength, yy, this.zOffset);
            box.addVertex(this.xOffset + this.xLength, yy, this.zOffset + this.zLength);
            box.addVertex(this.xOffset, yy, this.zOffset + this.zLength);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceB.addYTicks(td0, td1);
            this.faceD.addYTicks(td2, td3);
            this.faceE.addYTicks(td0, td3);
            this.faceF.addYTicks(td1, td2);
            base += 4;
        }
        for (TickData t : this.zTicks) {
            double zz = this.zOffset + this.zLength * t.getPos();
            box.addVertex(this.xOffset, this.yOffset, zz);
            box.addVertex(this.xOffset + this.xLength, this.yOffset, zz);
            box.addVertex(this.xOffset + this.xLength, this.yOffset + this.yLength, zz);
            box.addVertex(this.xOffset, this.yOffset + this.yLength, zz);
            td0 = new TickData(t, base);
            td1 = new TickData(t, base + 1);
            td2 = new TickData(t, base + 2);
            td3 = new TickData(t, base + 3);
            this.faceA.addZTicks(td0, td1);
            this.faceC.addZTicks(td3, td2);
            this.faceE.addZTicks(td0, td3);
            this.faceF.addZTicks(td1, td2);
            base += 4;
        }
        for (MarkerData m : this.xMarkers) {
            if (m.getType().equals((Object)MarkerDataType.VALUE)) {
                double xpos = this.xOffset + this.xLength * m.getValueLine().getPos();
                base += this.addXMarker(box, m, xpos, base);
                continue;
            }
            if (!m.getType().equals((Object)MarkerDataType.RANGE)) continue;
            double startX = this.xOffset + this.xLength * m.getStartLine().getPos();
            double endX = this.xOffset + this.xLength * m.getEndLine().getPos();
            base += this.addXRangeMarker(box, m, startX, endX, base);
        }
        for (MarkerData m : this.yMarkers) {
            if (m.getType().equals((Object)MarkerDataType.VALUE)) {
                double ypos = this.yOffset + this.yLength * m.getValueLine().getPos();
                base += this.addYMarker(box, m, ypos, base);
                continue;
            }
            if (!m.getType().equals((Object)MarkerDataType.RANGE)) continue;
            double startY = this.yOffset + this.yLength * m.getStartLine().getPos();
            double endY = this.yOffset + this.yLength * m.getEndLine().getPos();
            base += this.addYRangeMarker(box, m, startY, endY, base);
        }
        for (MarkerData m : this.zMarkers) {
            if (m.getType().equals((Object)MarkerDataType.VALUE)) {
                double zpos = this.zOffset + this.zLength * m.getValueLine().getPos();
                base += this.addZMarker(box, m, zpos, base);
                continue;
            }
            if (!m.getType().equals((Object)MarkerDataType.RANGE)) continue;
            double startZ = this.zOffset + this.zLength * m.getStartLine().getPos();
            double endZ = this.zOffset + this.zLength * m.getEndLine().getPos();
            base += this.addZRangeMarker(box, m, startZ, endZ, base);
        }
        return box;
    }

    private int addXMarker(Object3D box, MarkerData m, double x, int base) {
        int result = 4;
        Point3D v0 = new Point3D(x, this.yOffset, this.zOffset);
        Point3D v1 = new Point3D(x, this.yOffset, this.zOffset + this.zLength);
        Point3D v2 = new Point3D(x, this.yOffset + this.yLength, this.zOffset + this.zLength);
        Point3D v3 = new Point3D(x, this.yOffset + this.yLength, this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        MarkerData md0 = new MarkerData(m, base, base + 1);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3);
        MarkerData md3 = new MarkerData(m, base + 3, base);
        if (m.getLabelAnchor() != null) {
            Point3D v4 = this.calcAnchorXY(m.getLabelAnchor(), v0, v3, this.xLength);
            Point3D v5 = this.calcAnchorXY(m.getLabelAnchor(), v2, v1, this.xLength);
            Point3D v6 = this.calcAnchorXZ(m.getLabelAnchor(), v1, v0, this.xLength);
            Point3D v7 = this.calcAnchorXZ(m.getLabelAnchor(), v3, v2, this.xLength);
            box.addVertex(v4);
            box.addVertex(v5);
            box.addVertex(v6);
            box.addVertex(v7);
            md3.setLabelVertexIndex(base + 4);
            md1.setLabelVertexIndex(base + 5);
            md0.setLabelVertexIndex(base + 6);
            md2.setLabelVertexIndex(base + 7);
            result += 4;
        }
        this.faceA.addXMarker(md0);
        this.faceD.addXMarker(md1);
        this.faceC.addXMarker(md2);
        this.faceB.addXMarker(md3);
        return result;
    }

    private int addXRangeMarker(Object3D box, MarkerData m, double startX, double endX, int base) {
        int result = 8;
        Point3D v0 = new Point3D(startX, this.yOffset, this.zOffset);
        Point3D v1 = new Point3D(startX, this.yOffset, this.zOffset + this.zLength);
        Point3D v2 = new Point3D(startX, this.yOffset + this.yLength, this.zOffset + this.zLength);
        Point3D v3 = new Point3D(startX, this.yOffset + this.yLength, this.zOffset);
        Point3D v4 = new Point3D(endX, this.yOffset, this.zOffset);
        Point3D v5 = new Point3D(endX, this.yOffset, this.zOffset + this.zLength);
        Point3D v6 = new Point3D(endX, this.yOffset + this.yLength, this.zOffset + this.zLength);
        Point3D v7 = new Point3D(endX, this.yOffset + this.yLength, this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        box.addVertex(v4);
        box.addVertex(v5);
        box.addVertex(v6);
        box.addVertex(v7);
        MarkerData md0 = new MarkerData(m, base, base + 1, base + 4, base + 5);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2, base + 5, base + 6);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3, base + 6, base + 7);
        MarkerData md3 = new MarkerData(m, base + 3, base + 0, base + 7, base + 4);
        if (m.getLabelAnchor() != null) {
            Point3D v8 = this.calcRangeAnchorXY(m.getLabelAnchor(), v2, v1, v6, v5);
            Point3D v9 = this.calcRangeAnchorXY(m.getLabelAnchor(), v0, v3, v4, v7);
            Point3D v10 = this.calcRangeAnchorXZ(m.getLabelAnchor(), v3, v2, v7, v6);
            Point3D v11 = this.calcRangeAnchorXZ(m.getLabelAnchor(), v1, v0, v5, v4);
            box.addVertex(v8);
            box.addVertex(v9);
            box.addVertex(v10);
            box.addVertex(v11);
            md1.setLabelVertexIndex(base + 8);
            md3.setLabelVertexIndex(base + 9);
            md2.setLabelVertexIndex(base + 10);
            md0.setLabelVertexIndex(base + 11);
            result += 4;
        }
        this.faceA.addXMarker(md0);
        this.faceD.addXMarker(md1);
        this.faceC.addXMarker(md2);
        this.faceB.addXMarker(md3);
        return result;
    }

    private int addYMarker(Object3D box, MarkerData m, double y, int base) {
        int result = 4;
        Point3D v0 = new Point3D(this.xOffset, y, this.zOffset);
        Point3D v1 = new Point3D(this.xOffset, y, this.zOffset + this.zLength);
        Point3D v2 = new Point3D(this.xOffset + this.xLength, y, this.zOffset + this.zLength);
        Point3D v3 = new Point3D(this.xOffset + this.xLength, y, this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        MarkerData md0 = new MarkerData(m, base, base + 1);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3);
        MarkerData md3 = new MarkerData(m, base + 3, base);
        if (m.getLabelAnchor() != null) {
            Point3D v4 = this.calcAnchorYX(m.getLabelAnchor(), v1, v2, this.yLength);
            Point3D v5 = this.calcAnchorYX(m.getLabelAnchor(), v3, v0, this.yLength);
            Point3D v6 = this.calcAnchorYZ(m.getLabelAnchor(), v0, v1, this.yLength);
            Point3D v7 = this.calcAnchorYZ(m.getLabelAnchor(), v2, v3, this.yLength);
            box.addVertex(v4);
            box.addVertex(v5);
            box.addVertex(v6);
            box.addVertex(v7);
            md1.setLabelVertexIndex(base + 4);
            md3.setLabelVertexIndex(base + 5);
            md0.setLabelVertexIndex(base + 6);
            md2.setLabelVertexIndex(base + 7);
            result += 4;
        }
        this.faceE.addYMarker(md0);
        this.faceD.addYMarker(md1);
        this.faceF.addYMarker(md2);
        this.faceB.addYMarker(md3);
        return result;
    }

    private int addYRangeMarker(Object3D box, MarkerData m, double startY, double endY, int base) {
        int result = 8;
        Point3D v0 = new Point3D(this.xOffset, startY, this.zOffset);
        Point3D v1 = new Point3D(this.xOffset, startY, this.zOffset + this.zLength);
        Point3D v2 = new Point3D(this.xOffset + this.xLength, startY, this.zOffset + this.zLength);
        Point3D v3 = new Point3D(this.xOffset + this.xLength, startY, this.zOffset);
        Point3D v4 = new Point3D(this.xOffset, endY, this.zOffset);
        Point3D v5 = new Point3D(this.xOffset, endY, this.zOffset + this.zLength);
        Point3D v6 = new Point3D(this.xOffset + this.xLength, endY, this.zOffset + this.zLength);
        Point3D v7 = new Point3D(this.xOffset + this.xLength, endY, this.zOffset);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        box.addVertex(v4);
        box.addVertex(v5);
        box.addVertex(v6);
        box.addVertex(v7);
        MarkerData md0 = new MarkerData(m, base, base + 1, base + 4, base + 5);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2, base + 5, base + 6);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3, base + 6, base + 7);
        MarkerData md3 = new MarkerData(m, base + 3, base, base + 7, base + 4);
        if (m.getLabelAnchor() != null) {
            Point3D v8 = this.calcRangeAnchorYX(m.getLabelAnchor(), v1, v2, v5, v6);
            Point3D v9 = this.calcRangeAnchorYX(m.getLabelAnchor(), v3, v0, v7, v4);
            Point3D v10 = this.calcRangeAnchorYZ(m.getLabelAnchor(), v2, v3, v6, v7);
            Point3D v11 = this.calcRangeAnchorYZ(m.getLabelAnchor(), v0, v1, v4, v5);
            box.addVertex(v8);
            box.addVertex(v9);
            box.addVertex(v10);
            box.addVertex(v11);
            md1.setLabelVertexIndex(base + 8);
            md3.setLabelVertexIndex(base + 9);
            md2.setLabelVertexIndex(base + 10);
            md0.setLabelVertexIndex(base + 11);
            result += 4;
        }
        this.faceE.addYMarker(md0);
        this.faceD.addYMarker(md1);
        this.faceF.addYMarker(md2);
        this.faceB.addYMarker(md3);
        return result;
    }

    private int addZMarker(Object3D box, MarkerData m, double z, int base) {
        int result = 4;
        Point3D v0 = new Point3D(this.xOffset, this.yOffset, z);
        Point3D v1 = new Point3D(this.xOffset + this.xLength, this.yOffset, z);
        Point3D v2 = new Point3D(this.xOffset + this.xLength, this.yOffset + this.yLength, z);
        Point3D v3 = new Point3D(this.xOffset, this.yOffset + this.yLength, z);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        MarkerData md0 = new MarkerData(m, base, base + 1);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3);
        MarkerData md3 = new MarkerData(m, base + 3, base);
        if (m.getLabelAnchor() != null) {
            Point3D v4 = this.calcAnchorZX(m.getLabelAnchor(), v0, v1, this.zLength);
            Point3D v5 = this.calcAnchorZX(m.getLabelAnchor(), v2, v3, this.zLength);
            Point3D v6 = this.calcAnchorZY(m.getLabelAnchor(), v1, v2, this.zLength);
            Point3D v7 = this.calcAnchorZY(m.getLabelAnchor(), v3, v0, this.zLength);
            box.addVertex(v4);
            box.addVertex(v5);
            box.addVertex(v6);
            box.addVertex(v7);
            md0.setLabelVertexIndex(base + 4);
            md2.setLabelVertexIndex(base + 5);
            md1.setLabelVertexIndex(base + 6);
            md3.setLabelVertexIndex(base + 7);
            result += 4;
        }
        this.faceA.addZMarker(md0);
        this.faceF.addZMarker(md1);
        this.faceC.addZMarker(md2);
        this.faceE.addZMarker(md3);
        return result;
    }

    private int addZRangeMarker(Object3D box, MarkerData m, double startZ, double endZ, int base) {
        int result = 8;
        Point3D v0 = new Point3D(this.xOffset, this.yOffset, startZ);
        Point3D v1 = new Point3D(this.xOffset + this.xLength, this.yOffset, startZ);
        Point3D v2 = new Point3D(this.xOffset + this.xLength, this.yOffset + this.yLength, startZ);
        Point3D v3 = new Point3D(this.xOffset, this.yOffset + this.yLength, startZ);
        Point3D v4 = new Point3D(this.xOffset, this.yOffset, endZ);
        Point3D v5 = new Point3D(this.xOffset + this.xLength, this.yOffset, endZ);
        Point3D v6 = new Point3D(this.xOffset + this.xLength, this.yOffset + this.yLength, endZ);
        Point3D v7 = new Point3D(this.xOffset, this.yOffset + this.yLength, endZ);
        box.addVertex(v0);
        box.addVertex(v1);
        box.addVertex(v2);
        box.addVertex(v3);
        box.addVertex(v4);
        box.addVertex(v5);
        box.addVertex(v6);
        box.addVertex(v7);
        MarkerData md0 = new MarkerData(m, base, base + 1, base + 4, base + 5);
        MarkerData md1 = new MarkerData(m, base + 1, base + 2, base + 5, base + 6);
        MarkerData md2 = new MarkerData(m, base + 2, base + 3, base + 6, base + 7);
        MarkerData md3 = new MarkerData(m, base + 3, base, base + 7, base + 4);
        if (m.getLabelAnchor() != null) {
            Point3D v8 = this.calcRangeAnchorZX(m.getLabelAnchor(), v0, v1, v4, v5);
            Point3D v9 = this.calcRangeAnchorZX(m.getLabelAnchor(), v2, v3, v6, v7);
            Point3D v10 = this.calcRangeAnchorZY(m.getLabelAnchor(), v3, v0, v7, v4);
            Point3D v11 = this.calcRangeAnchorZY(m.getLabelAnchor(), v1, v2, v5, v6);
            box.addVertex(v8);
            box.addVertex(v9);
            box.addVertex(v10);
            box.addVertex(v11);
            md0.setLabelVertexIndex(base + 8);
            md2.setLabelVertexIndex(base + 9);
            md3.setLabelVertexIndex(base + 10);
            md1.setLabelVertexIndex(base + 11);
            result += 4;
        }
        this.faceA.addZMarker(md0);
        this.faceF.addZMarker(md1);
        this.faceC.addZMarker(md2);
        this.faceE.addZMarker(md3);
        return result;
    }

    private double hoffset(Anchor2D anchor, double length) {
        double offset = 0.0;
        if (anchor.getRefPt().isLeft()) {
            offset = length * anchor.getOffset().getDX();
        } else if (anchor.getRefPt().isRight()) {
            offset = -length * anchor.getOffset().getDX();
        }
        return offset;
    }

    private double voffset(Anchor2D anchor, double length) {
        double offset = 0.0;
        if (anchor.getRefPt().isTop()) {
            offset = length * anchor.getOffset().getDY();
        } else if (anchor.getRefPt().isBottom()) {
            offset = -length * anchor.getOffset().getDY();
        }
        return offset;
    }

    private double hpos(Anchor2D anchor, double start, double end) {
        if (anchor.getRefPt().isLeft()) {
            return start;
        }
        if (anchor.getRefPt().isRight()) {
            return end;
        }
        return (start + end) / 2.0;
    }

    private Point3D calcAnchorXY(Anchor2D anchor, Point3D start, Point3D end, double xLength) {
        double dx = this.hoffset(anchor, end.getY() - start.getY());
        double dy = this.voffset(anchor, xLength);
        double y = this.hpos(anchor, start.getY(), end.getY());
        return new Point3D(start.getX() + dy, y + dx, start.getZ());
    }

    private Point3D calcAnchorXZ(Anchor2D anchor, Point3D start, Point3D end, double xLength) {
        double dx = this.hoffset(anchor, end.getZ() - start.getZ());
        double dy = this.voffset(anchor, xLength);
        double z = this.hpos(anchor, start.getZ(), end.getZ());
        return new Point3D(start.getX() + dy, start.getY(), z + dx);
    }

    private Point3D calcAnchorYX(Anchor2D anchor, Point3D start, Point3D end, double yLength) {
        double dx = this.hoffset(anchor, end.getX() - start.getX());
        double dy = this.voffset(anchor, yLength);
        double x = this.hpos(anchor, start.getX(), end.getX());
        return new Point3D(x + dx, start.getY() + dy, start.getZ());
    }

    private Point3D calcAnchorYZ(Anchor2D anchor, Point3D start, Point3D end, double yLength) {
        double dx = this.hoffset(anchor, end.getZ() - start.getZ());
        double dy = this.voffset(anchor, yLength);
        double z = this.hpos(anchor, start.getZ(), end.getZ());
        return new Point3D(start.getX(), start.getY() + dy, z + dx);
    }

    private Point3D calcAnchorZX(Anchor2D anchor, Point3D start, Point3D end, double zLength) {
        double dx = this.hoffset(anchor, end.getX() - start.getX());
        double dy = this.voffset(anchor, zLength);
        double x = this.hpos(anchor, start.getX(), end.getX());
        return new Point3D(x + dx, start.getY(), start.getZ() + dy);
    }

    private Point3D calcAnchorZY(Anchor2D anchor, Point3D start, Point3D end, double zLength) {
        double dx = this.hoffset(anchor, end.getY() - start.getY());
        double dy = this.voffset(anchor, zLength);
        double y = this.hpos(anchor, start.getY(), end.getY());
        return new Point3D(start.getX(), y + dx, start.getZ() + dy);
    }

    private Point3D calcRangeAnchorXY(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getY(), start1.getX(), end2.getY(), end2.getX());
        return new Point3D(p.getY(), p.getX(), end1.getZ());
    }

    private Point3D calcRangeAnchorXZ(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getZ(), start1.getX(), end2.getZ(), end2.getX());
        return new Point3D(p.getY(), end1.getY(), p.getX());
    }

    private Point3D calcRangeAnchorYX(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getX(), start1.getY(), end2.getX(), end2.getY());
        return new Point3D(p.getX(), p.getY(), end1.getZ());
    }

    private Point3D calcRangeAnchorYZ(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getZ(), start1.getY(), end2.getZ(), end2.getY());
        return new Point3D(start1.getX(), p.getY(), p.getX());
    }

    private Point3D calcRangeAnchorZX(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getX(), start1.getZ(), end2.getX(), end2.getZ());
        return new Point3D(p.getX(), end1.getY(), p.getY());
    }

    private Point3D calcRangeAnchorZY(Anchor2D anchor, Point3D start1, Point3D end1, Point3D start2, Point3D end2) {
        Point2D p = anchor.resolveAnchorWithPercentOffset(start1.getY(), start1.getZ(), end2.getY(), end2.getZ());
        return new Point3D(end1.getX(), p.getX(), p.getY());
    }

    public static final class ChartBoxFace
    extends Face {
        private List<TickData> xTicksA = new ArrayList<TickData>();
        private List<TickData> xTicksB = new ArrayList<TickData>();
        private List<TickData> yTicksA = new ArrayList<TickData>();
        private List<TickData> yTicksB = new ArrayList<TickData>();
        private List<TickData> zTicksA = new ArrayList<TickData>();
        private List<TickData> zTicksB = new ArrayList<TickData>();
        private List<MarkerData> xMarkers = new ArrayList<MarkerData>();
        private List<MarkerData> yMarkers = new ArrayList<MarkerData>();
        private List<MarkerData> zMarkers = new ArrayList<MarkerData>();

        public ChartBoxFace(Object3D owner, int[] vertices) {
            super(owner, vertices);
        }

        public void clearXTicks() {
            this.xTicksA.clear();
            this.xTicksB.clear();
        }

        public List<TickData> getXTicksA() {
            return this.xTicksA;
        }

        public void addXTicks(TickData a, TickData b) {
            this.xTicksA.add(a);
            this.xTicksB.add(b);
        }

        public List<TickData> getXTicksB() {
            return this.xTicksB;
        }

        public void addYTicks(TickData a, TickData b) {
            this.yTicksA.add(a);
            this.yTicksB.add(b);
        }

        public List<TickData> getYTicksA() {
            return this.yTicksA;
        }

        public List<TickData> getYTicksB() {
            return this.yTicksB;
        }

        public void addZTicks(TickData a, TickData b) {
            this.zTicksA.add(a);
            this.zTicksB.add(b);
        }

        public List<TickData> getZTicksA() {
            return this.zTicksA;
        }

        public List<TickData> getZTicksB() {
            return this.zTicksB;
        }

        public void addXMarker(MarkerData marker) {
            ArgChecks.nullNotPermitted(marker, "marker");
            this.xMarkers.add(marker);
        }

        public List<MarkerData> getXMarkers() {
            return Collections.unmodifiableList(this.xMarkers);
        }

        public void addYMarker(MarkerData marker) {
            ArgChecks.nullNotPermitted(marker, "marker");
            this.yMarkers.add(marker);
        }

        public List<MarkerData> getYMarkers() {
            return Collections.unmodifiableList(this.yMarkers);
        }

        public void addZMarker(MarkerData marker) {
            ArgChecks.nullNotPermitted(marker, "marker");
            this.zMarkers.add(marker);
        }

        public List<MarkerData> getZMarkers() {
            return Collections.unmodifiableList(this.zMarkers);
        }

        @Override
        public float calculateAverageZValue(Point3D[] points) {
            return -123456.0f;
        }
    }
}

