/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.util.ArgChecks;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;

public class RenderedElement {
    public static final String TYPE = "type";
    public static final String BOUNDS = "bounds";
    private final Map<String, Object> properties;

    public RenderedElement(Object type, Shape bounds) {
        ArgChecks.nullNotPermitted(type, TYPE);
        this.properties = new HashMap<String, Object>();
        this.properties.put(TYPE, type);
        this.properties.put(BOUNDS, bounds);
    }

    public Object getType() {
        return this.properties.get(TYPE);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Object type = this.properties.get(TYPE);
        sb.append("RenderedElement[").append(type).append(",").append(this.properties.entrySet()).append("]");
        return sb.toString();
    }
}

