/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.Resources;
import com.orsoncharts.graphics3d.swing.DownAction;
import com.orsoncharts.graphics3d.swing.ExportToJPEGAction;
import com.orsoncharts.graphics3d.swing.ExportToPDFAction;
import com.orsoncharts.graphics3d.swing.ExportToPNGAction;
import com.orsoncharts.graphics3d.swing.ExportToSVGAction;
import com.orsoncharts.graphics3d.swing.LeftAction;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.graphics3d.swing.RightAction;
import com.orsoncharts.graphics3d.swing.RollLeftAction;
import com.orsoncharts.graphics3d.swing.RollRightAction;
import com.orsoncharts.graphics3d.swing.UpAction;
import com.orsoncharts.graphics3d.swing.ZoomInAction;
import com.orsoncharts.graphics3d.swing.ZoomOutAction;
import com.orsoncharts.graphics3d.swing.ZoomToFitAction;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ExportFormat;
import com.orsoncharts.util.ExportFormats;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class DisplayPanel3D
extends JPanel
implements MouseListener {
    private static final int FONT_SIZE = 22;
    private static Font FONT_AWESOME;
    Panel3D content;
    private JPopupMenu popup;

    public static Font getFontAwesomeFont(int size) {
        if (FONT_AWESOME == null) {
            try {
                InputStream in = DisplayPanel3D.class.getResourceAsStream("fontawesome-webfont.ttf");
                FONT_AWESOME = Font.createFont(0, in);
            }
            catch (FontFormatException ex) {
                Logger.getLogger(Panel3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Panel3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return FONT_AWESOME.deriveFont(0, size);
    }

    public DisplayPanel3D(Panel3D content) {
        this(content, true, true);
    }

    public DisplayPanel3D(Panel3D content, boolean toolbar, boolean popupMenu) {
        super(new BorderLayout());
        this.content = content;
        this.add(this.content);
        if (toolbar) {
            JToolBar tb = this.createToolBar(content);
            this.add((Component)tb, "East");
        }
        if (popupMenu) {
            this.popup = this.createPopupMenu(ExportFormat.values());
        }
        this.content.addMouseListener(this);
    }

    public Panel3D getContent() {
        return this.content;
    }

    public void setExportFormats(ExportFormat ... formats) {
        this.popup = this.createPopupMenu(formats);
    }

    private JToolBar createToolBar(Panel3D content) {
        JToolBar tb = new JToolBar(1);
        Font font = DisplayPanel3D.getFontAwesomeFont(22);
        JButton zoomInButton = new JButton(new ZoomInAction(this.content, true));
        zoomInButton.setFont(font);
        JButton zoomOutButton = new JButton(new ZoomOutAction(this.content, true));
        zoomOutButton.setFont(font);
        JButton zoomToFitButton = new JButton(new ZoomToFitAction(this.content, true));
        zoomToFitButton.setFont(font);
        JButton leftButton = new JButton(new LeftAction(content));
        leftButton.setFont(font);
        JButton rightButton = new JButton(new RightAction(content));
        rightButton.setFont(font);
        JButton upButton = new JButton(new UpAction(content));
        upButton.setFont(font);
        JButton downButton = new JButton(new DownAction(content));
        downButton.setFont(font);
        JButton rotateLeftButton = new JButton(new RollLeftAction(content));
        rotateLeftButton.setFont(font);
        JButton rotateRightButton = new JButton(new RollRightAction(content));
        rotateRightButton.setFont(font);
        tb.add(zoomInButton);
        tb.add(zoomOutButton);
        tb.add(zoomToFitButton);
        tb.add(new JToolBar.Separator());
        tb.add(leftButton);
        tb.add(rightButton);
        tb.add(upButton);
        tb.add(downButton);
        tb.add(rotateLeftButton);
        tb.add(rotateRightButton);
        return tb;
    }

    private JPopupMenu createPopupMenu(ExportFormat ... exportFormats) {
        ArgChecks.nullNotPermitted(exportFormats, "exportFormats");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new ZoomInAction(this.content, false)));
        popupMenu.add(new JMenuItem(new ZoomOutAction(this.content, false)));
        popupMenu.add(new JMenuItem(new ZoomToFitAction(this.content, false)));
        if (exportFormats.length > 0) {
            JMenu exportSubMenu = new JMenu(Resources.localString("EXPORT_AS"));
            for (ExportFormat f : exportFormats) {
                if (f.equals((Object)ExportFormat.PNG)) {
                    JMenuItem pngItem = new JMenuItem(new ExportToPNGAction(this.content));
                    exportSubMenu.add(pngItem);
                    continue;
                }
                if (f.equals((Object)ExportFormat.JPEG)) {
                    JMenuItem jpgItem = new JMenuItem(new ExportToJPEGAction(this.content));
                    exportSubMenu.add(jpgItem);
                    continue;
                }
                if (f.equals((Object)ExportFormat.PDF)) {
                    if (!ExportFormats.isOrsonPDFAvailable()) continue;
                    JMenuItem pdfItem = new JMenuItem(new ExportToPDFAction(this.content));
                    exportSubMenu.add(pdfItem);
                    continue;
                }
                if (!f.equals((Object)ExportFormat.SVG) || !ExportFormats.isJFreeSVGAvailable()) continue;
                JMenuItem svgItem = new JMenuItem(new ExportToSVGAction(this.content));
                exportSubMenu.add(svgItem);
            }
            if (exportSubMenu.getItemCount() > 0) {
                popupMenu.addSeparator();
                popupMenu.add(exportSubMenu);
            }
        }
        return popupMenu;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

