/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.Resources;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ZoomInAction
extends AbstractAction {
    private Panel3D panel;
    private double zoomMultiplier;

    public ZoomInAction(Panel3D panel, boolean fontAwesome) {
        super("\uf00e");
        ArgChecks.nullNotPermitted(panel, "panel");
        this.panel = panel;
        this.zoomMultiplier = 0.95;
        if (!fontAwesome) {
            this.putValue("Name", Resources.localString("ZOOM_IN"));
        }
        this.putValue("ActionCommandKey", "ZOOM_IN");
        this.putValue("ShortDescription", Resources.localString("ZOOM_IN"));
    }

    public double getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    public void setZoomMultiplier(double multiplier) {
        this.zoomMultiplier = multiplier;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewPoint3D viewPt = this.panel.getViewPoint();
        double minDistance = this.panel.getMinViewingDistance();
        double maxDistance = minDistance * this.panel.getMaxViewingDistanceMultiplier();
        double valRho = Math.max(minDistance, Math.min(maxDistance, viewPt.getRho() * this.zoomMultiplier));
        this.panel.getViewPoint().setRho(valRho);
        this.panel.repaint();
    }
}

