/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.label;

import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZItemKey;
import com.orsoncharts.interaction.XYZDataItemSelection;
import com.orsoncharts.label.XYZItemLabelGenerator;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.Formatter;

public class StandardXYZItemLabelGenerator
implements XYZItemLabelGenerator,
Serializable {
    public static final String KEY_AND_COORDS_3DP_TEMPLATE = "%s (%2$.3f, %3$.3f, %4$.3f)";
    public static final String COORDS_3DP_TEMPLATE = "(%2$.3f, %3$.3f, %4$.3f)";
    public static final String DEFAULT_TEMPLATE = "%s (%2$.3f, %3$.3f, %4$.3f)";
    private String template;
    private XYZDataItemSelection itemSelection;

    public StandardXYZItemLabelGenerator() {
        this("%s (%2$.3f, %3$.3f, %4$.3f)");
    }

    public StandardXYZItemLabelGenerator(String template) {
        ArgChecks.nullNotPermitted(template, "template");
        this.template = template;
        this.itemSelection = null;
    }

    public XYZDataItemSelection getItemSelection() {
        return this.itemSelection;
    }

    public void setItemSelection(XYZDataItemSelection selection) {
        this.itemSelection = selection;
    }

    @Override
    public String generateItemLabel(XYZDataset dataset, Comparable<?> seriesKey, int itemIndex) {
        XYZItemKey key;
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        if (this.itemSelection != null && !this.itemSelection.isSelected(key = new XYZItemKey(seriesKey, itemIndex))) {
            return null;
        }
        int seriesIndex = dataset.getSeriesIndex(seriesKey);
        Formatter formatter = new Formatter(new StringBuilder());
        double x = dataset.getX(seriesIndex, itemIndex);
        double y = dataset.getY(seriesIndex, itemIndex);
        double z = dataset.getZ(seriesIndex, itemIndex);
        formatter.format(this.template, seriesKey, x, y, z);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYZItemLabelGenerator)) {
            return false;
        }
        StandardXYZItemLabelGenerator that = (StandardXYZItemLabelGenerator)obj;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }
}

