/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.legend;

import com.orsoncharts.legend.ColorScaleElement;
import com.orsoncharts.legend.LegendBuilder;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.ColorScale;
import com.orsoncharts.renderer.ColorScaleRenderer;
import com.orsoncharts.renderer.FixedColorScale;
import com.orsoncharts.renderer.category.CategoryRenderer3D;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import com.orsoncharts.style.ChartStyle;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.Orientation;
import java.io.Serializable;

public class ColorScaleLegendBuilder
implements LegendBuilder,
Serializable {
    private double barWidth = 16.0;
    private double barLength = 140.0;
    private boolean ignoreFixedColorScale = true;

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double width) {
        this.barWidth = width;
    }

    public double getBarLength() {
        return this.barLength;
    }

    public void setBarLength(double length) {
        this.barLength = length;
    }

    public boolean getIgnoreFixedColorScale() {
        return this.ignoreFixedColorScale;
    }

    public void setIgnoreFixedColorScale(boolean ignore) {
        this.ignoreFixedColorScale = ignore;
    }

    @Override
    public TableElement createLegend(Plot3D plot, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        XYZRenderer r;
        ColorScaleRenderer renderer = null;
        if (plot instanceof CategoryPlot3D) {
            CategoryRenderer3D r2 = ((CategoryPlot3D)plot).getRenderer();
            if (r2 instanceof ColorScaleRenderer) {
                renderer = (ColorScaleRenderer)((Object)r2);
            }
        } else if (plot instanceof XYZPlot && (r = ((XYZPlot)plot).getRenderer()) instanceof ColorScaleRenderer) {
            renderer = (ColorScaleRenderer)((Object)r);
        }
        if (renderer == null) {
            return null;
        }
        if (this.ignoreFixedColorScale && renderer.getColorScale() instanceof FixedColorScale) {
            return null;
        }
        return this.createColorScaleLegend(renderer, orientation, anchor, style);
    }

    private TableElement createColorScaleLegend(ColorScaleRenderer r, Orientation orientation, Anchor2D anchor, ChartStyle style) {
        ColorScale scale = r.getColorScale();
        ColorScaleElement element = new ColorScaleElement(scale, orientation, this.barWidth, this.barLength, style.getLegendItemFont(), style.getLegendItemColor());
        element.setBackgroundColor(style.getLegendItemBackgroundColor());
        element.setRefPoint(anchor.getRefPt());
        return element;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColorScaleLegendBuilder)) {
            return false;
        }
        ColorScaleLegendBuilder that = (ColorScaleLegendBuilder)obj;
        if (this.barWidth != that.barWidth) {
            return false;
        }
        return this.barLength == that.barLength;
    }
}

