/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.marker;

import com.orsoncharts.marker.MarkerDataType;
import com.orsoncharts.marker.MarkerLine;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class MarkerData {
    private String markerKey;
    private MarkerDataType type;
    private Map<String, Object> data;

    public MarkerData(String key, double pos) {
        ArgChecks.nullNotPermitted(key, "key");
        this.markerKey = key;
        this.type = MarkerDataType.VALUE;
        this.data = new HashMap<String, Object>();
        this.data.put("valueLine", new MarkerLine(pos, false));
    }

    public MarkerData(String key, double startPos, boolean startPegged, double endPos, boolean endPegged) {
        ArgChecks.nullNotPermitted(key, "key");
        this.markerKey = key;
        this.type = MarkerDataType.RANGE;
        this.data = new HashMap<String, Object>();
        this.data.put("startLine", new MarkerLine(startPos, startPegged));
        this.data.put("endLine", new MarkerLine(endPos, endPegged));
    }

    public MarkerData(MarkerData source, int v0, int v1) {
        ArgChecks.nullNotPermitted(source, "source");
        if (!source.getType().equals((Object)MarkerDataType.VALUE)) {
            throw new IllegalArgumentException("Must be MarkerDataType.VALUE");
        }
        this.markerKey = source.markerKey;
        this.type = source.type;
        this.data = new HashMap<String, Object>(source.data);
        double pos = source.getValueLine().getPos();
        MarkerLine valueLine = new MarkerLine(pos, false, v0, v1);
        this.data.put("valueLine", valueLine);
    }

    public MarkerData(MarkerData source, int v0, int v1, int v2, int v3) {
        ArgChecks.nullNotPermitted(source, "source");
        if (!source.getType().equals((Object)MarkerDataType.RANGE)) {
            throw new IllegalArgumentException("Must be MarkerDataType.RANGE");
        }
        this.markerKey = source.markerKey;
        this.type = MarkerDataType.RANGE;
        this.data = new HashMap<String, Object>(source.data);
        double startPos = source.getStartLine().getPos();
        boolean startPegged = source.getStartLine().isPegged();
        MarkerLine startLine = new MarkerLine(startPos, startPegged, v0, v1);
        this.data.put("startLine", startLine);
        double endPos = source.getEndLine().getPos();
        boolean endPegged = source.getEndLine().isPegged();
        MarkerLine endLine = new MarkerLine(endPos, endPegged, v2, v3);
        this.data.put("endLine", endLine);
    }

    public String getMarkerKey() {
        return this.markerKey;
    }

    public MarkerDataType getType() {
        return this.type;
    }

    public MarkerLine getValueLine() {
        return (MarkerLine)this.data.get("valueLine");
    }

    public MarkerLine getStartLine() {
        return (MarkerLine)this.data.get("startLine");
    }

    public MarkerLine getEndLine() {
        return (MarkerLine)this.data.get("endLine");
    }

    public Anchor2D getLabelAnchor() {
        return (Anchor2D)this.data.get("labelAnchor");
    }

    public void setLabelAnchor(Anchor2D anchor) {
        this.data.put("labelAnchor", anchor);
    }

    public int getLabelVertexIndex() {
        Integer i = (Integer)this.data.get("labelVertexIndex");
        return i != null ? i : -1;
    }

    public void setLabelVertexIndex(int labelVertexIndex) {
        this.data.put("labelVertexIndex", labelVertexIndex);
    }

    public Point2D getLabelPoint() {
        return (Point2D)this.data.get("labelPoint");
    }

    public void updateProjection(Point2D[] pts) {
        if (this.type.equals((Object)MarkerDataType.VALUE)) {
            MarkerLine line = this.getValueLine();
            line.setStartPoint(pts[line.getV0()]);
            line.setEndPoint(pts[line.getV1()]);
        } else if (this.type.equals((Object)MarkerDataType.RANGE)) {
            MarkerLine startLine = this.getStartLine();
            startLine.setStartPoint(pts[startLine.getV0()]);
            startLine.setEndPoint(pts[startLine.getV1()]);
            MarkerLine endLine = this.getEndLine();
            endLine.setStartPoint(pts[endLine.getV0()]);
            endLine.setEndPoint(pts[endLine.getV1()]);
        }
        int labelVertex = this.getLabelVertexIndex();
        if (labelVertex >= 0) {
            this.data.put("labelPoint", pts[labelVertex]);
        } else {
            this.data.put("labelPoint", null);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarkerData[key=");
        sb.append(this.markerKey);
        sb.append("]");
        return sb.toString();
    }
}

